/*
 * Decompiled with CFR 0.152.
 */
package org.egov.encryption;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.contract.request.Role;
import org.egov.encryption.EncryptionService;
import org.egov.encryption.EncryptionServiceRestConnection;
import org.egov.encryption.audit.AuditService;
import org.egov.encryption.config.DecryptionPolicyConfiguration;
import org.egov.encryption.config.EncProperties;
import org.egov.encryption.config.EncryptionPolicyConfiguration;
import org.egov.encryption.masking.MaskingService;
import org.egov.encryption.models.Attribute;
import org.egov.encryption.models.UniqueIdentifier;
import org.egov.encryption.models.Visibility;
import org.egov.encryption.util.ConvertClass;
import org.egov.encryption.util.JSONBrowseUtil;
import org.egov.encryption.util.JacksonUtils;
import org.egov.encryption.util.JsonPathConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EncryptionServiceImpl
implements EncryptionService {
    private static final Logger log = LoggerFactory.getLogger(EncryptionServiceImpl.class);
    @Autowired
    private EncProperties encProperties;
    @Autowired
    private EncryptionServiceRestConnection encryptionServiceRestConnection;
    @Autowired
    private EncryptionPolicyConfiguration encryptionPolicyConfiguration;
    @Autowired
    private DecryptionPolicyConfiguration decryptionPolicyConfiguration;
    @Autowired
    private MaskingService maskingService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private ObjectMapper objectMapper;

    private JsonNode encryptJsonArray(JsonNode plaintextNode, String model, String tenantId) throws IOException {
        JsonNode encryptNode = plaintextNode.deepCopy();
        List<Attribute> attributes = this.encryptionPolicyConfiguration.getAttributeDetailsForModel(model);
        List<String> attributesToEncrypt = attributes.stream().map(Attribute::getJsonPath).collect(Collectors.toList());
        JsonNode jsonNode = JacksonUtils.filterJsonNodeForPaths(plaintextNode, attributesToEncrypt = JsonPathConverter.convertToArrayJsonPaths(attributesToEncrypt));
        if (!jsonNode.isEmpty(this.objectMapper.getSerializerProvider())) {
            JsonNode returnedEncryptedNode = this.objectMapper.valueToTree(this.encryptionServiceRestConnection.callEncrypt(tenantId, this.encProperties.getDefaultEncryptDataType(), jsonNode));
            encryptNode = JacksonUtils.merge(returnedEncryptedNode, encryptNode);
        }
        return encryptNode;
    }

    @Override
    public JsonNode encryptJson(Object plaintextJson, String model, String tenantId) throws IOException {
        JsonNode plaintextNode = this.createJsonNode(plaintextJson);
        JsonNode plaintextNodeCopy = plaintextNode.deepCopy();
        if (!plaintextNodeCopy.isArray()) {
            ArrayNode arrayNode = this.objectMapper.createArrayNode();
            arrayNode.add(plaintextNodeCopy);
            plaintextNodeCopy = arrayNode;
        }
        JsonNode encryptedNode = this.encryptJsonArray(plaintextNodeCopy, model, tenantId);
        if (!plaintextNode.isArray()) {
            return encryptedNode.get(0);
        }
        return encryptedNode;
    }

    @Override
    public <E, P> P encryptJson(Object plaintextJson, String model, String tenantId, Class<E> valueType) throws IOException {
        return ConvertClass.convertTo(this.encryptJson(plaintextJson, model, tenantId), valueType);
    }

    private JsonNode decryptJson(RequestInfo requestInfo, Object ciphertextJson, Map<Attribute, Visibility> attributesVisibilityMap, String model, String purpose, UniqueIdentifier uniqueIdentifier, String tenantId) throws IOException {
        JsonNode ciphertextNode = this.createJsonNode(ciphertextJson);
        JsonNode decryptNode = ciphertextNode.deepCopy();
        if (!decryptNode.isArray()) {
            ArrayNode arrayNode = this.objectMapper.createArrayNode();
            arrayNode.add(decryptNode);
            decryptNode = arrayNode;
        }
        if (attributesVisibilityMap.containsValue((Object)Visibility.NONE)) {
            List attributesToBeRemoved = attributesVisibilityMap.keySet().stream().filter(attribute -> attributesVisibilityMap.get(attribute) == Visibility.NONE).collect(Collectors.toList());
            List<String> pathToBeRemoved = attributesToBeRemoved.stream().map(Attribute::getJsonPath).collect(Collectors.toList());
            JsonNode nodeToBeEmptied = JacksonUtils.filterJsonNodeForPaths(decryptNode, pathToBeRemoved);
            JsonNode emptyNode = JSONBrowseUtil.mapValues(nodeToBeEmptied, __ -> "Confidential Information");
            decryptNode = JacksonUtils.merge(emptyNode, decryptNode);
        }
        List attributesToBeDecrypted = attributesVisibilityMap.keySet().stream().filter(attribute -> attributesVisibilityMap.get(attribute) != Visibility.NONE).collect(Collectors.toList());
        List<String> pathsToBeDecrypted = attributesToBeDecrypted.stream().map(Attribute::getJsonPath).collect(Collectors.toList());
        JsonNode jsonNode = JacksonUtils.filterJsonNodeForPaths(ciphertextNode, pathsToBeDecrypted = JsonPathConverter.convertToArrayJsonPaths(pathsToBeDecrypted));
        if (!jsonNode.isEmpty(this.objectMapper.getSerializerProvider())) {
            JsonNode returnedDecryptedNode = this.encryptionServiceRestConnection.callDecrypt(jsonNode, tenantId);
            decryptNode = JacksonUtils.merge(returnedDecryptedNode, decryptNode);
        }
        if (attributesVisibilityMap.containsValue((Object)Visibility.MASKED)) {
            List<Attribute> attributesToBeMasked = attributesVisibilityMap.keySet().stream().filter(attribute -> attributesVisibilityMap.get(attribute) == Visibility.MASKED).collect(Collectors.toList());
            decryptNode = this.maskingService.maskData(decryptNode, attributesToBeMasked, uniqueIdentifier, requestInfo);
        }
        this.auditService.audit(decryptNode, model, purpose, requestInfo);
        return decryptNode;
    }

    @Override
    public JsonNode decryptJson(RequestInfo requestInfo, Object ciphertextJson, String model, String purpose, String tenantId) throws IOException {
        List<String> roles = requestInfo.getUserInfo().getRoles().stream().map(Role::getCode).collect(Collectors.toList());
        Map<Attribute, Visibility> attributesVisibilityMap = this.decryptionPolicyConfiguration.getRoleAttributeAccessListForModel(requestInfo, model, roles);
        UniqueIdentifier uniqueIdentifier = this.decryptionPolicyConfiguration.getSecurityPolicyUniqueIdentifier(model);
        JsonNode decryptedNode = this.decryptJson(requestInfo, ciphertextJson, attributesVisibilityMap, model, purpose, uniqueIdentifier, tenantId);
        return decryptedNode;
    }

    @Override
    public <E, P> P decryptJson(RequestInfo requestInfo, Object ciphertextJson, String model, String purpose, Class<E> valueType, String tenantId) throws IOException {
        return ConvertClass.convertTo(this.decryptJson(requestInfo, ciphertextJson, model, purpose, tenantId), valueType);
    }

    JsonNode createJsonNode(Object json) throws IOException {
        JsonNode jsonNode = json instanceof JsonNode ? (JsonNode)json : (json instanceof String ? this.objectMapper.readTree((String)json) : this.objectMapper.valueToTree(json));
        return jsonNode;
    }

    @Override
    public String encryptValue(Object plaintext, String tenantId) throws IOException {
        return this.encryptValue(plaintext, tenantId, this.encProperties.getDefaultEncryptDataType());
    }

    @Override
    public String encryptValue(Object plaintext, String tenantId, String type) throws IOException {
        return this.encryptValue(new ArrayList<Object>(Collections.singleton(plaintext)), tenantId, type).get(0);
    }

    @Override
    public List<String> encryptValue(List<Object> plaintext, String tenantId, String type) throws IOException {
        Object encryptionResponse = this.encryptionServiceRestConnection.callEncrypt(tenantId, type, plaintext);
        return (List)ConvertClass.convertTo(this.objectMapper.valueToTree(encryptionResponse), List.class);
    }
}

