/*
 * Decompiled with CFR 0.152.
 */
package org.egov.encryption.config;

import java.util.List;
import org.egov.encryption.config.EncTenantSpecificProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:enc.properties"})
@EnableConfigurationProperties(value={EncTenantSpecificProperties.class})
public class EncProperties {
    @Value(value="${kafka.topic.audit}")
    private String auditTopicName;
    @Value(value="${egov.mdms.host}")
    private String egovMdmsHost;
    @Value(value="${egov.mdms.search.endpoint}")
    private String egovMdmsSearchEndpoint;
    @Value(value="#{'${egov.enc.state.level.tenant.ids}'.split(',')}")
    private List<String> stateLevelTenantIds;
    @Value(value="${default.encrypt.data.type}")
    private String defaultEncryptDataType;
    @Value(value="${egov.enc.host}")
    private String egovEncHost;
    @Value(value="${egov.enc.encrypt.endpoint}")
    private String egovEncEncryptPath;
    @Value(value="${egov.enc.decrypt.endpoint}")
    private String egovEncDecryptPath;

    public String getAuditTopicName() {
        return this.auditTopicName;
    }

    public String getEgovMdmsHost() {
        return this.egovMdmsHost;
    }

    public String getEgovMdmsSearchEndpoint() {
        return this.egovMdmsSearchEndpoint;
    }

    public List<String> getStateLevelTenantIds() {
        return this.stateLevelTenantIds;
    }

    public String getDefaultEncryptDataType() {
        return this.defaultEncryptDataType;
    }

    public String getEgovEncHost() {
        return this.egovEncHost;
    }

    public String getEgovEncEncryptPath() {
        return this.egovEncEncryptPath;
    }

    public String getEgovEncDecryptPath() {
        return this.egovEncDecryptPath;
    }
}

