/*
 * Decompiled with CFR 0.152.
 */
package org.egov.encryption.models;

import java.util.List;
import org.egov.encryption.models.Attribute;
import org.egov.encryption.models.RoleBasedDecryptionPolicy;
import org.egov.encryption.models.UniqueIdentifier;

public class SecurityPolicy {
    private String model = null;
    private UniqueIdentifier uniqueIdentifier = null;
    private List<Attribute> attributes = null;
    private List<RoleBasedDecryptionPolicy> roleBasedDecryptionPolicy = null;

    public static SecurityPolicyBuilder builder() {
        return new SecurityPolicyBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public UniqueIdentifier getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public List<RoleBasedDecryptionPolicy> getRoleBasedDecryptionPolicy() {
        return this.roleBasedDecryptionPolicy;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setUniqueIdentifier(UniqueIdentifier uniqueIdentifier) {
        this.uniqueIdentifier = uniqueIdentifier;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public void setRoleBasedDecryptionPolicy(List<RoleBasedDecryptionPolicy> roleBasedDecryptionPolicy) {
        this.roleBasedDecryptionPolicy = roleBasedDecryptionPolicy;
    }

    public SecurityPolicy(String model, UniqueIdentifier uniqueIdentifier, List<Attribute> attributes, List<RoleBasedDecryptionPolicy> roleBasedDecryptionPolicy) {
        this.model = model;
        this.uniqueIdentifier = uniqueIdentifier;
        this.attributes = attributes;
        this.roleBasedDecryptionPolicy = roleBasedDecryptionPolicy;
    }

    public SecurityPolicy() {
    }

    public static class SecurityPolicyBuilder {
        private String model;
        private UniqueIdentifier uniqueIdentifier;
        private List<Attribute> attributes;
        private List<RoleBasedDecryptionPolicy> roleBasedDecryptionPolicy;

        SecurityPolicyBuilder() {
        }

        public SecurityPolicyBuilder model(String model) {
            this.model = model;
            return this;
        }

        public SecurityPolicyBuilder uniqueIdentifier(UniqueIdentifier uniqueIdentifier) {
            this.uniqueIdentifier = uniqueIdentifier;
            return this;
        }

        public SecurityPolicyBuilder attributes(List<Attribute> attributes) {
            this.attributes = attributes;
            return this;
        }

        public SecurityPolicyBuilder roleBasedDecryptionPolicy(List<RoleBasedDecryptionPolicy> roleBasedDecryptionPolicy) {
            this.roleBasedDecryptionPolicy = roleBasedDecryptionPolicy;
            return this;
        }

        public SecurityPolicy build() {
            return new SecurityPolicy(this.model, this.uniqueIdentifier, this.attributes, this.roleBasedDecryptionPolicy);
        }

        public String toString() {
            return "SecurityPolicy.SecurityPolicyBuilder(model=" + this.model + ", uniqueIdentifier=" + this.uniqueIdentifier + ", attributes=" + this.attributes + ", roleBasedDecryptionPolicy=" + this.roleBasedDecryptionPolicy + ")";
        }
    }
}

