/*
 * Decompiled with CFR 0.152.
 */
package org.egov.encryption.config;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="egov.enc.tenant")
public class EncTenantSpecificProperties {
    private boolean useDefaultValues;
    private Map<String, String> host = new HashMap<String, String>();
    private Map<String, String> defaultEncryptDataType = new HashMap<String, String>();
    private Map<String, String> encryptEndpoint = new HashMap<String, String>();
    private Map<String, String> decryptEndpoint = new HashMap<String, String>();
    private Map<String, String> auditTopicName = new HashMap<String, String>();
    private Map<String, String> mdmsHost = new HashMap<String, String>();
    private Map<String, String> mdmsSearchEndpoint = new HashMap<String, String>();

    public void setHost(Map<String, String> host) {
        this.host = this.normalizeKeys(host);
    }

    public void setDefaultEncryptDataType(Map<String, String> map) {
        this.defaultEncryptDataType = this.normalizeKeys(map);
    }

    public void setEncryptEndpoint(Map<String, String> map) {
        this.encryptEndpoint = this.normalizeKeys(map);
    }

    public void setDecryptEndpoint(Map<String, String> map) {
        this.decryptEndpoint = this.normalizeKeys(map);
    }

    public void setAuditTopicName(Map<String, String> map) {
        this.auditTopicName = this.normalizeKeys(map);
    }

    public void setMdmsHost(Map<String, String> map) {
        this.mdmsHost = this.normalizeKeys(map);
    }

    public void setMdmsSearchEndpoint(Map<String, String> map) {
        this.mdmsSearchEndpoint = this.normalizeKeys(map);
    }

    private Map<String, String> normalizeKeys(Map<String, String> map) {
        if (map == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> normalized = new HashMap<String, String>();
        map.forEach((k, v) -> normalized.put(k.toLowerCase(Locale.ROOT), (String)v));
        return normalized;
    }

    private String getValue(Map<String, String> map, String tenantId, String defaultValue) {
        if (tenantId == null) {
            return defaultValue;
        }
        String key = tenantId.toLowerCase(Locale.ROOT);
        if (this.useDefaultValues) {
            return map.getOrDefault(key, defaultValue);
        }
        return map.get(key);
    }

    public String getHost(String tenantId, String defaultValue) {
        return this.getValue(this.host, tenantId, defaultValue);
    }

    public String getDefaultEncryptDataType(String tenantId, String defaultValue) {
        return this.getValue(this.defaultEncryptDataType, tenantId, defaultValue);
    }

    public String getEncryptEndpoint(String tenantId, String defaultValue) {
        return this.getValue(this.encryptEndpoint, tenantId, defaultValue);
    }

    public String getDecryptEndpoint(String tenantId, String defaultValue) {
        return this.getValue(this.decryptEndpoint, tenantId, defaultValue);
    }

    public String getAuditTopicName(String tenantId, String defaultValue) {
        return this.getValue(this.auditTopicName, tenantId, defaultValue);
    }

    public String getMdmsHost(String tenantId, String defaultValue) {
        return this.getValue(this.mdmsHost, tenantId, defaultValue);
    }

    public String getMdmsSearchEndpoint(String tenantId, String defaultValue) {
        return this.getValue(this.mdmsSearchEndpoint, tenantId, defaultValue);
    }

    public boolean isUseDefaultValues() {
        return this.useDefaultValues;
    }

    public Map<String, String> getHost() {
        return this.host;
    }

    public Map<String, String> getDefaultEncryptDataType() {
        return this.defaultEncryptDataType;
    }

    public Map<String, String> getEncryptEndpoint() {
        return this.encryptEndpoint;
    }

    public Map<String, String> getDecryptEndpoint() {
        return this.decryptEndpoint;
    }

    public Map<String, String> getAuditTopicName() {
        return this.auditTopicName;
    }

    public Map<String, String> getMdmsHost() {
        return this.mdmsHost;
    }

    public Map<String, String> getMdmsSearchEndpoint() {
        return this.mdmsSearchEndpoint;
    }

    public void setUseDefaultValues(boolean useDefaultValues) {
        this.useDefaultValues = useDefaultValues;
    }
}

