/*
 * Decompiled with CFR 0.152.
 */
package org.egov.encryption.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class JSONUtils {
    private static final Logger log = LoggerFactory.getLogger(JSONUtils.class);

    public static JsonNode merge(JsonNode newNode, JsonNode originalNode) {
        Iterator fieldNames = originalNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode jsonNode = newNode.get(fieldName);
            if (jsonNode != null) {
                if (jsonNode.isObject()) {
                    JSONUtils.merge(jsonNode, originalNode.get(fieldName));
                    continue;
                }
                if (!jsonNode.isArray()) continue;
                for (int i = 0; i < jsonNode.size(); ++i) {
                    JSONUtils.merge(jsonNode.get(i), originalNode.get(fieldName).get(i));
                }
                continue;
            }
            if (!(newNode instanceof ObjectNode)) continue;
            JsonNode value = originalNode.get(fieldName);
            ((ObjectNode)newNode).set(fieldName, value);
        }
        return newNode;
    }

    public static JsonNode filterJsonNodeWithFields(JsonNode jsonNode, List<String> filterFields) {
        if (JSONUtils.checkIfNoFieldExistsInJsonNode(jsonNode, filterFields)) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        if (jsonNode.isObject()) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            ObjectNode filteredObjectNode = mapper.createObjectNode();
            Iterator fieldIterator = objectNode.fieldNames();
            while (fieldIterator.hasNext()) {
                String field = (String)fieldIterator.next();
                if (filterFields.contains(field) && !objectNode.get(field).isNull()) {
                    filteredObjectNode.set(field, objectNode.get(field));
                    continue;
                }
                JsonNode filteredJsonNode = JSONUtils.filterJsonNodeWithFields(objectNode.get(field), filterFields);
                if (filteredJsonNode == null) continue;
                filteredObjectNode.set(field, filteredJsonNode);
            }
            if (filteredObjectNode.isEmpty(mapper.getSerializerProvider())) {
                return null;
            }
            return filteredObjectNode;
        }
        if (jsonNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            ArrayNode filteredArrayNode = mapper.createArrayNode();
            for (int i = 0; i < arrayNode.size(); ++i) {
                Object filteredJsonNode = JSONUtils.filterJsonNodeWithFields(arrayNode.get(i), filterFields);
                if (filteredJsonNode == null) {
                    filteredJsonNode = arrayNode.get(i).isArray() ? mapper.createArrayNode() : (arrayNode.get(i).isObject() ? mapper.createObjectNode() : NullNode.getInstance());
                }
                filteredArrayNode.add(filteredJsonNode);
            }
            return filteredArrayNode;
        }
        return null;
    }

    public static JsonNode filterJsonNodeWithPaths2(JsonNode jsonNode, List<String> filterPaths) {
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        ArrayNode filteredNode = null;
        if (jsonNode instanceof ArrayNode) {
            filteredNode = mapper.createArrayNode();
        } else if (jsonNode instanceof ObjectNode) {
            filteredNode = mapper.createObjectNode();
        } else {
            return null;
        }
        for (String path : filterPaths) {
            JsonNode singlePathFilterNode = JSONUtils.filterJsonNodeForPath(jsonNode, path);
            filteredNode = JSONUtils.merge(singlePathFilterNode, (JsonNode)filteredNode);
        }
        return filteredNode;
    }

    public static JsonNode filterJsonNodeForPath(JsonNode jsonNode, String filterPath) {
        ObjectMapper objectMapper = new ObjectMapper(new JsonFactory());
        if (filterPath == null) {
            return jsonNode;
        }
        if (jsonNode == null) {
            return null;
        }
        String key = JSONUtils.getFirstJsonKeyForPath(filterPath);
        ArrayNode newNode = null;
        if (key.contains("*")) {
            newNode = objectMapper.createArrayNode();
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            for (JsonNode value : arrayNode) {
                newNode.add(JSONUtils.filterJsonNodeForPath(value, JSONUtils.getRemainingJsonKeyForPath(filterPath)));
            }
        } else {
            newNode = objectMapper.createObjectNode();
            ObjectNode objectNode = (ObjectNode)jsonNode;
            JsonNode value = objectNode.get(key);
            ((ObjectNode)newNode).set(key, JSONUtils.filterJsonNodeForPath(value, JSONUtils.getRemainingJsonKeyForPath(filterPath)));
        }
        return newNode;
    }

    static String getFirstJsonKeyForPath(String path) {
        String[] keys = path.split("/", 2);
        return keys[0];
    }

    static String getRemainingJsonKeyForPath(String path) {
        String[] keys = path.split("/", 2);
        if (keys.length == 1) {
            return null;
        }
        return keys[1];
    }

    public static ArrayNode filterJsonNodeWithPaths(JsonNode jsonNode, List<String> filterPaths) {
        Configuration configuration = Configuration.defaultConfiguration().addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL, Option.SUPPRESS_EXCEPTIONS});
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        DocumentContext jsonDocument = JsonPath.using((Configuration)configuration).parse(jsonNode.toString());
        ArrayNode filteredNode = mapper.createArrayNode();
        for (String path : filterPaths) {
            Object value = jsonDocument.read(path, new Predicate[0]);
            filteredNode.add((JsonNode)mapper.convertValue(value, JsonNode.class));
        }
        return filteredNode;
    }

    public static JsonNode mergeNodesForGivenPaths(JsonNode newNode, JsonNode originalNode, List<String> filterPaths) throws IOException {
        Configuration configuration = Configuration.defaultConfiguration().addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL, Option.SUPPRESS_EXCEPTIONS});
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        JsonNode mergedNode = originalNode.deepCopy();
        DocumentContext mergedNodeDocumentContext = JsonPath.using((Configuration)configuration).parse(mergedNode.toString());
        ArrayNode newArrayNode = (ArrayNode)newNode;
        for (int i = 0; i < filterPaths.size(); ++i) {
            String path = filterPaths.get(i);
            if (mergedNodeDocumentContext.read(path, new Predicate[0]) == null) continue;
            if (path.contains("*")) {
                ArrayNode values = (ArrayNode)newArrayNode.get(i);
                for (int j = 0; j < values.size(); ++j) {
                    String absolutePath = path.replace("*", String.valueOf(j));
                    mergedNodeDocumentContext.set(absolutePath, (Object)values.get(j).textValue(), new Predicate[0]);
                }
                continue;
            }
            mergedNodeDocumentContext.set(path, (Object)newArrayNode.get(i).textValue(), new Predicate[0]);
        }
        return mapper.readTree(mergedNodeDocumentContext.jsonString());
    }

    static boolean checkIfNoFieldExistsInJsonNode(JsonNode jsonNode, List<String> fields) {
        for (String field : fields) {
            if (String.valueOf(jsonNode.findPath(field)).isEmpty()) continue;
            return false;
        }
        return true;
    }
}

