/*
 * Decompiled with CFR 0.152.
 */
package org.egov.encryption.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.util.Iterator;
import java.util.function.Function;

public class JSONBrowseUtil {
    public static <T, R> JsonNode mapValues(JsonNode jsonNode, Function<T, R> valueMapper) {
        if (jsonNode.isArray()) {
            jsonNode = JSONBrowseUtil.mapValuesForArrayNode((ArrayNode)jsonNode, valueMapper);
        } else if (jsonNode.isObject()) {
            jsonNode = JSONBrowseUtil.mapValuesForObjectNode((ObjectNode)jsonNode, valueMapper);
        } else if (jsonNode.isValueNode()) {
            jsonNode = JSONBrowseUtil.mapValuesForValueNode((ValueNode)jsonNode, valueMapper);
        }
        return jsonNode;
    }

    private static <T, R> ArrayNode mapValuesForArrayNode(ArrayNode arrayNode, Function<T, R> valueMapper) {
        for (int i = 0; i < arrayNode.size(); ++i) {
            arrayNode.set(i, JSONBrowseUtil.mapValues(arrayNode.get(i), valueMapper));
        }
        return arrayNode;
    }

    private static <T, R> ObjectNode mapValuesForObjectNode(ObjectNode objectNode, Function<T, R> valueMapper) {
        Iterator fields = objectNode.fieldNames();
        while (fields.hasNext()) {
            String field = (String)fields.next();
            objectNode.set(field, JSONBrowseUtil.mapValues(objectNode.get(field), valueMapper));
        }
        return objectNode;
    }

    private static <T, R> ValueNode mapValuesForValueNode(ValueNode valueNode, Function<T, R> valueMapper) {
        if (valueNode.isNull()) {
            return NullNode.getInstance();
        }
        return new TextNode(String.valueOf(valueMapper.apply(valueNode.asText())));
    }
}

