/*
 * Decompiled with CFR 0.152.
 */
package org.egov.encryption.config;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import net.minidev.json.JSONArray;
import org.egov.common.contract.request.RequestInfo;
import org.egov.encryption.config.EncProperties;
import org.egov.encryption.models.Attribute;
import org.egov.encryption.models.EncryptionPolicy;
import org.egov.mdms.model.MasterDetail;
import org.egov.mdms.model.MdmsCriteria;
import org.egov.mdms.model.MdmsCriteriaReq;
import org.egov.mdms.model.MdmsResponse;
import org.egov.mdms.model.ModuleDetail;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class EncryptionPolicyConfiguration {
    @Autowired
    private EncProperties encProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ObjectMapper objectMapper;
    private Map<String, List<Attribute>> keyAttributeMap;
    public static final String TENANTID_MDC_STRING = "TENANTID";

    @PostConstruct
    void initializeKeyAttributeMapFromMdms() {
        List encryptionPolicyList = null;
        try {
            MDC.put((String)TENANTID_MDC_STRING, (String)this.encProperties.getStateLevelTenantId());
            MasterDetail masterDetail = MasterDetail.builder().name("EncryptionPolicy").build();
            ModuleDetail moduleDetail = ModuleDetail.builder().moduleName("DataSecurity").masterDetails(Arrays.asList(masterDetail)).build();
            MdmsCriteria mdmsCriteria = MdmsCriteria.builder().tenantId(this.encProperties.getStateLevelTenantId()).moduleDetails(Arrays.asList(moduleDetail)).build();
            MdmsCriteriaReq mdmsCriteriaReq = MdmsCriteriaReq.builder().requestInfo(RequestInfo.builder().build()).mdmsCriteria(mdmsCriteria).build();
            ResponseEntity response = this.restTemplate.postForEntity(this.encProperties.getEgovMdmsHost() + this.encProperties.getEgovMdmsSearchEndpoint(), (Object)mdmsCriteriaReq, MdmsResponse.class, new Object[0]);
            JSONArray policyListJSON = (JSONArray)((Map)((MdmsResponse)response.getBody()).getMdmsRes().get("DataSecurity")).get("EncryptionPolicy");
            ObjectReader reader = this.objectMapper.readerFor((JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, EncryptionPolicy.class));
            encryptionPolicyList = (List)reader.readValue(policyListJSON.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.initializeKeyAttributeMap(encryptionPolicyList);
    }

    void initializeKeyAttributeMap(List<EncryptionPolicy> encryptionPolicyList) {
        this.keyAttributeMap = encryptionPolicyList.stream().collect(Collectors.toMap(EncryptionPolicy::getKey, EncryptionPolicy::getAttributeList));
    }

    public List<Attribute> getAttributesForKey(String key) {
        return this.keyAttributeMap.get(key);
    }

    public Map<String, List<Attribute>> getTypeAttributeMap(List<Attribute> attributeList) {
        HashMap<String, List<Attribute>> typeAttributeMap = new HashMap<String, List<Attribute>>();
        for (Attribute attribute : attributeList) {
            String type = attribute.getType();
            if (!typeAttributeMap.containsKey(type)) {
                ArrayList attributesToEncrypt = new ArrayList();
                typeAttributeMap.put(type, attributesToEncrypt);
            }
            ((List)typeAttributeMap.get(type)).add(attribute);
        }
        return typeAttributeMap;
    }
}

