/*
 * Decompiled with CFR 0.152.
 */
package org.egov.encryption.accesscontrol;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.egov.encryption.models.AccessType;
import org.egov.encryption.models.Attribute;
import org.egov.encryption.models.AttributeAccess;
import org.egov.encryption.models.RoleAttributeAccess;
import org.springframework.stereotype.Component;

@Component
public class AbacFilter {
    public Map<Attribute, AccessType> getAttributeAccessForRoles(List<String> roles, Map<String, List<AttributeAccess>> roleAttributeAccessMapping) {
        HashMap<Attribute, AccessType> attributeAccessTypeMap = new HashMap<Attribute, AccessType>();
        for (String role : roles) {
            if (!roleAttributeAccessMapping.containsKey(role)) continue;
            List<AttributeAccess> attributeAccessList = roleAttributeAccessMapping.get(role);
            for (AttributeAccess attributeAccess : attributeAccessList) {
                Attribute attribute = attributeAccess.getAttribute();
                AccessType accessType = attributeAccess.getAccessType();
                if (attributeAccessTypeMap.containsKey(attribute)) {
                    if (((AccessType)((Object)attributeAccessTypeMap.get(attribute))).ordinal() <= accessType.ordinal()) continue;
                    attributeAccessTypeMap.remove(attribute);
                    attributeAccessTypeMap.put(attribute, accessType);
                    continue;
                }
                attributeAccessTypeMap.put(attribute, accessType);
            }
        }
        return attributeAccessTypeMap;
    }

    public Map<Attribute, AccessType> getAttributeAccessForRoles(List<String> roles, List<RoleAttributeAccess> roleAttributeAccessList) {
        Map<String, List<AttributeAccess>> roleAttributeAccessMapping = this.makeRoleAttributeAccessMapping(roleAttributeAccessList);
        return this.getAttributeAccessForRoles(roles, roleAttributeAccessMapping);
    }

    private Map<String, List<AttributeAccess>> makeRoleAttributeAccessMapping(List<RoleAttributeAccess> roleAttributeAccessList) {
        return roleAttributeAccessList.stream().collect(Collectors.toMap(RoleAttributeAccess::getRoleCode, RoleAttributeAccess::getAttributeAccessList));
    }
}

