/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.utils;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.egov.commons.EgwStatus;
import org.egov.commons.Installment;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.EmployeeService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.messaging.MessagingService;
import org.egov.infra.utils.EgovThreadLocals;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.ModelAttribute;

@Service
public class WaterTaxUtils {
    @Qualifier(value="entityQueryService")
    @Autowired
    private PersistenceService entityQueryService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private CityService cityService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private BoundaryTypeService boundaryTypeService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private PersistenceService persistenceService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private MessagingService messagingService;
    @Autowired
    private ResourceBundleMessageSource messageSource;
    @Autowired
    private UserService userService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;

    public Boolean isSmsEnabled() {
        AppConfigValues appConfigValue = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Water Tax Management", "SENDSMSFORWATERTAX").get(0);
        return "YES".equalsIgnoreCase(appConfigValue.getValue());
    }

    public String getDepartmentForWorkFlow() {
        String department = "";
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Water Tax Management", "DEPARTMENTFORWORKFLOW");
        if (null != appConfigValue && !appConfigValue.isEmpty()) {
            department = ((AppConfigValues)appConfigValue.get(0)).getValue();
        }
        return department;
    }

    public String getDesignationForThirdPartyUser() {
        String designation = "";
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Water Tax Management", "CLERKDESIGNATIONFORCSCOPERATOR");
        if (null != appConfigValue && !appConfigValue.isEmpty()) {
            designation = ((AppConfigValues)appConfigValue.get(0)).getValue();
        }
        return designation;
    }

    public List<AppConfigValues> getThirdPartyUserRoles() {
        List appConfigValueList = this.appConfigValuesService.getConfigValuesByModuleAndKey("Water Tax Management", "ROLEFORNONEMPLOYEEINWATERTAX");
        return !appConfigValueList.isEmpty() ? appConfigValueList : null;
    }

    public List<AppConfigValues> getUserRolesForLoggedInUser() {
        List appConfigValueList = this.appConfigValuesService.getConfigValuesByModuleAndKeyByValueAsc("Water Tax Management", "RolesForSearchWAterTaxConnection");
        return !appConfigValueList.isEmpty() ? appConfigValueList : null;
    }

    public Boolean getCurrentUserRole(User currentUser) {
        Boolean applicationByOthers = false;
        for (Role userrole : currentUser.getRoles()) {
            Iterator<AppConfigValues> iterator = this.getThirdPartyUserRoles().iterator();
            if (!iterator.hasNext()) continue;
            AppConfigValues appconfig = iterator.next();
            if (userrole == null || !userrole.getName().equals(appconfig.getValue())) continue;
            applicationByOthers = true;
        }
        return applicationByOthers;
    }

    public Boolean isEmailEnabled() {
        AppConfigValues appConfigValue = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Water Tax Management", "SENDEMAILFORWATERTAX").get(0);
        return "YES".equalsIgnoreCase(appConfigValue.getValue());
    }

    public Boolean isNewConnectionAllowedIfPTDuePresent() {
        AppConfigValues appConfigValue = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Water Tax Management", "NEWCONNECTIONALLOWEDIFPTDUE").get(0);
        return "YES".equalsIgnoreCase(appConfigValue.getValue());
    }

    public Boolean isMultipleNewConnectionAllowedForPID() {
        AppConfigValues appConfigValue = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Water Tax Management", "MULTIPLENEWCONNECTIONFORPID").get(0);
        return "YES".equalsIgnoreCase(appConfigValue.getValue());
    }

    public Boolean isConnectionAllowedIfWTDuePresent(String connectionType) {
        Boolean isAllowed = false;
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Water Tax Management", connectionType);
        if (null != appConfigValue && !appConfigValue.isEmpty()) {
            return "YES".equalsIgnoreCase(((AppConfigValues)appConfigValue.get(0)).getValue());
        }
        return isAllowed;
    }

    public String documentRequiredForBPLCategory() {
        String documentName = null;
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Water Tax Management", "DOCUMENTREQUIREDFORBPL");
        if (appConfigValue != null && !appConfigValue.isEmpty()) {
            documentName = ((AppConfigValues)appConfigValue.get(0)).getValue();
        }
        return documentName;
    }

    public String getCityName() {
        return null != this.cityService.getCityByURL(EgovThreadLocals.getDomainName()).getPreferences() ? this.cityService.getCityByURL(EgovThreadLocals.getDomainName()).getPreferences().getMunicipalityName() : this.cityService.getCityByURL(EgovThreadLocals.getDomainName()).getName();
    }

    public String getCityCode() {
        return this.cityService.getCityByURL(EgovThreadLocals.getDomainName()).getCode();
    }

    public String smsAndEmailBodyByCodeAndArgsForRejection(String code, String approvalComment, String applicantName) {
        Locale locale = LocaleContextHolder.getLocale();
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{applicantName, approvalComment, this.getCityName()}, locale);
        return smsMsg;
    }

    public String emailBodyforApprovalEmailByCodeAndArgs(String code, WaterConnectionDetails waterConnectionDetails, String applicantName) {
        Locale locale = LocaleContextHolder.getLocale();
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), waterConnectionDetails.getConnection().getConsumerCode(), this.getCityName()}, locale);
        return smsMsg;
    }

    public String emailSubjectforEmailByCodeAndArgs(String code, String applicationNumber) {
        Locale locale = LocaleContextHolder.getLocale();
        String emailSubject = this.messageSource.getMessage(code, (Object[])new String[]{applicationNumber}, locale);
        return emailSubject;
    }

    public void sendSMSOnWaterConnection(String mobileNumber, String smsBody) {
        this.messagingService.sendSMS(mobileNumber, smsBody);
    }

    public void sendEmailOnWaterConnection(String email, String emailBody, String emailSubject) {
        this.messagingService.sendEmail(email, emailSubject, emailBody);
    }

    public Position getCityLevelCommissionerPosition(String commissionerDesgn) {
        return ((Assignment)this.assignmentService.findPrimaryAssignmentForDesignationName(commissionerDesgn).get(0)).getPosition();
    }

    public String getApproverUserName(Long approvalPosition) {
        Assignment assignment = null;
        if (approvalPosition != null) {
            assignment = this.assignmentService.getPrimaryAssignmentForPositionAndDate(approvalPosition, new Date());
        }
        return assignment != null ? assignment.getEmployee().getUsername() : "";
    }

    public EgwStatus getStatusByCodeAndModuleType(String code, String moduleName) {
        return (EgwStatus)this.persistenceService.find("from EgwStatus where moduleType=? and code=?", new Object[]{moduleName, code});
    }

    public Long getApproverPosition(String designationName, WaterConnectionDetails waterConnectionDetails) {
        List stateHistoryList = waterConnectionDetails.getState().getHistory();
        Long approverPosition = 0L;
        if (stateHistoryList != null && !stateHistoryList.isEmpty()) {
            block0: for (StateHistory stateHistory : stateHistoryList) {
                if (stateHistory.getOwnerPosition() == null) continue;
                List assignmentList = this.assignmentService.getAssignmentsForPosition(stateHistory.getOwnerPosition().getId(), new Date());
                for (Assignment assgn : assignmentList) {
                    if (!assgn.getDesignation().getName().equals(designationName)) continue;
                    approverPosition = stateHistory.getOwnerPosition().getId();
                    continue block0;
                }
            }
            if (approverPosition == 0L) {
                State stateObj = waterConnectionDetails.getState();
                List assignmentList = this.assignmentService.getAssignmentsForPosition(stateObj.getOwnerPosition().getId(), new Date());
                for (Assignment assgn : assignmentList) {
                    if (!assgn.getDesignation().getName().equals(designationName)) continue;
                    approverPosition = stateObj.getOwnerPosition().getId();
                    break;
                }
            }
        } else {
            Position posObjToClerk = this.positionMasterService.getCurrentPositionForUser(waterConnectionDetails.getCreatedBy().getId());
            approverPosition = posObjToClerk.getId();
        }
        return approverPosition;
    }

    public Position getZonalLevelClerkForLoggedInUser(String asessmentNumber) {
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(asessmentNumber, PropertyExternalService.FLAG_FULL_DETAILS);
        Assignment assignmentObj = null;
        BoundaryType boundaryTypeObj = this.boundaryTypeService.getBoundaryTypeByName(assessmentDetails.getBoundaryDetails().getZoneBoundaryType());
        Boundary boundaryObj = this.boundaryService.getBoundaryByTypeAndNo(boundaryTypeObj, assessmentDetails.getBoundaryDetails().getZoneNumber());
        Designation desgnObj = this.designationService.getDesignationByName(this.getDesignationForThirdPartyUser());
        Department deptObj = this.departmentService.getDepartmentByName(this.getDepartmentForWorkFlow());
        List employeeList = this.employeeService.findByDepartmentDesignationAndBoundary(deptObj.getId(), desgnObj.getId(), boundaryObj.getId());
        if (!employeeList.isEmpty()) {
            assignmentObj = this.assignmentService.getPrimaryAssignmentForEmployee(((Employee)employeeList.get(0)).getId());
        }
        return assignmentObj != null ? assignmentObj.getPosition() : null;
    }

    @ModelAttribute(value="checkOperator")
    public Boolean checkCollectionOperatorRole() {
        Boolean isCSCOperator = false;
        User userObj = this.userService.getUserById(EgovThreadLocals.getUserId());
        if (userObj != null) {
            for (Role role : userObj.getRoles()) {
                if (role == null || !role.getName().contains("CSC Operator")) continue;
                isCSCOperator = true;
                break;
            }
        }
        return isCSCOperator;
    }

    public List<Installment> getInstallmentListByStartDate(Date startDate) {
        return this.entityQueryService.findAllByNamedQuery("INSTALLMENTLISTBY_MODULE_AND_STARTYEAR", new Object[]{startDate, startDate, "Property Tax"});
    }

    public Double waterConnectionDue(long parentId) {
        Double finalDueAmount = 0.0;
        List<WaterConnectionDetails> waterConnectionDetails = this.waterConnectionDetailsService.getAllConnectionDetailsByParentConnection(parentId);
        for (WaterConnectionDetails waterconnectiondetails : waterConnectionDetails) {
            if (waterconnectiondetails.getDemand() == null) continue;
            finalDueAmount = finalDueAmount + (waterconnectiondetails.getDemand().getBaseDemand().doubleValue() - waterconnectiondetails.getDemand().getAmtCollected().doubleValue());
        }
        System.out.println("fianl due amount->" + finalDueAmount);
        return finalDueAmount;
    }
}

