/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.utils;

import java.io.Serializable;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.transaction.Transactional;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.utils.DBSequenceGenerator;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.egov.wtms.utils.WaterTaxUtils;
import org.hibernate.exception.SQLGrammarException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WaterTaxNumberGenerator {
    private static final String CONSUMER_NUMBER_SEQ_PREFIX = "SEQ_CONSUMER_NUMBER";
    private static final String WORKORDER_NUMBER_SEQ_PREFIX = "SEQ_WORKORDER_NUMBER";
    private static final String METERDEMANDNOTICE_NUMBER_SEQ_PREFIX = "SEQ_METERNOTICE_NUMBER";
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private DBSequenceGenerator dbSequenceGenerator;
    @Autowired
    private SequenceNumberGenerator sequenceNumberGenerator;
    @Autowired
    private WaterTaxUtils waterTaxUtils;

    @Transactional
    public String generateConsumerNumber() {
        try {
            Serializable sequenceNumber;
            String sequenceName = CONSUMER_NUMBER_SEQ_PREFIX;
            try {
                sequenceNumber = this.sequenceNumberGenerator.getNextSequence(CONSUMER_NUMBER_SEQ_PREFIX);
            }
            catch (SQLGrammarException e) {
                sequenceNumber = this.dbSequenceGenerator.createAndGetNextSequence(CONSUMER_NUMBER_SEQ_PREFIX);
            }
            return String.format("%s%06d", this.waterTaxUtils.getCityCode(), sequenceNumber);
        }
        catch (SQLException e) {
            throw new ApplicationRuntimeException("Error occurred while generating Consumer Number", (Throwable)e);
        }
    }

    @Transactional
    public String generateWorkOrderNumber() {
        try {
            Serializable sequenceNumber;
            String sequenceName = WORKORDER_NUMBER_SEQ_PREFIX;
            try {
                sequenceNumber = this.sequenceNumberGenerator.getNextSequence(WORKORDER_NUMBER_SEQ_PREFIX);
            }
            catch (SQLGrammarException e) {
                sequenceNumber = this.dbSequenceGenerator.createAndGetNextSequence(WORKORDER_NUMBER_SEQ_PREFIX);
            }
            return String.format("%s%06d", "", sequenceNumber);
        }
        catch (SQLException e) {
            throw new ApplicationRuntimeException("Error occurred while generating Consumer Number", (Throwable)e);
        }
    }

    @Transactional
    public String generateMeterDemandNoticeNumber() {
        try {
            Serializable sequenceNumber;
            String sequenceName = METERDEMANDNOTICE_NUMBER_SEQ_PREFIX;
            try {
                sequenceNumber = this.sequenceNumberGenerator.getNextSequence(METERDEMANDNOTICE_NUMBER_SEQ_PREFIX);
            }
            catch (SQLGrammarException e) {
                sequenceNumber = this.dbSequenceGenerator.createAndGetNextSequence(METERDEMANDNOTICE_NUMBER_SEQ_PREFIX);
            }
            return String.format("%s%06d", "", sequenceNumber);
        }
        catch (SQLException e) {
            throw new ApplicationRuntimeException("Error occurred while generating meter Generate Number", (Throwable)e);
        }
    }

    public String generateBillNumber(String installmentYear) {
        try {
            Serializable sequenceNumber;
            String sequenceName = "SEQ_BILLNO_" + installmentYear;
            try {
                sequenceNumber = this.sequenceNumberGenerator.getNextSequence(sequenceName);
            }
            catch (SQLGrammarException e) {
                sequenceNumber = this.dbSequenceGenerator.createAndGetNextSequence(sequenceName);
            }
            return String.format("%s%06d", "", sequenceNumber);
        }
        catch (SQLException e) {
            throw new ApplicationRuntimeException("Error occurred while generating water connection charges bill Number ", (Throwable)e);
        }
    }
}

