/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.service;

import java.util.ArrayList;
import java.util.List;
import org.egov.wtms.masters.entity.UsageType;
import org.egov.wtms.masters.entity.WaterPropertyUsage;
import org.egov.wtms.masters.repository.UsageTypeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class UsageTypeService {
    private final UsageTypeRepository usageTypeRepository;

    @Autowired
    public UsageTypeService(UsageTypeRepository usageTypeRepository) {
        this.usageTypeRepository = usageTypeRepository;
    }

    public UsageType findBy(Long usageTypeId) {
        return (UsageType)((Object)this.usageTypeRepository.findOne(usageTypeId));
    }

    @Transactional
    public UsageType createUsageType(UsageType usageType) {
        return (UsageType)((Object)this.usageTypeRepository.save((Object)usageType));
    }

    @Transactional
    public void updateUsageType(UsageType usageType) {
        this.usageTypeRepository.save((Object)usageType);
    }

    public List<UsageType> findAll() {
        return this.usageTypeRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public List<UsageType> findAllByNameLike(String name) {
        return this.usageTypeRepository.findByNameContainingIgnoreCase(name);
    }

    public UsageType findByName(String name) {
        return this.usageTypeRepository.findByName(name);
    }

    public UsageType load(Long id) {
        return (UsageType)((Object)this.usageTypeRepository.getOne(id));
    }

    public Page<UsageType> getListOfUsageType(Integer pageNumber, Integer pageSize) {
        PageRequest pageable = new PageRequest(pageNumber - 1, pageSize.intValue(), Sort.Direction.ASC, new String[]{"name"});
        return this.usageTypeRepository.findAll((Pageable)pageable);
    }

    public UsageType findByCode(String code) {
        return this.usageTypeRepository.findByCode(code);
    }

    public List<UsageType> getActiveUsageTypes() {
        return this.usageTypeRepository.findByActiveTrueOrderByIdAsc();
    }

    public List<UsageType> getAllUsageTypesByPropertyType(Long propertyType) {
        return this.usageTypeRepository.getAllUsageTypesByPropertyType(propertyType);
    }

    public WaterPropertyUsage getAllUsageTypesByPropertyTypeAndUsageType(String propertyType, String usageTypeCode) {
        return this.usageTypeRepository.getAllUsageTypesByPropertyTypeAndUsageType(propertyType, usageTypeCode);
    }

    public List<UsageType> getUsageTypeListForRest() {
        List<UsageType> usageTypeList = this.usageTypeRepository.findByActiveTrueOrderByIdAsc();
        ArrayList<UsageType> prepareListForRest = new ArrayList<UsageType>(0);
        for (UsageType usageType : usageTypeList) {
            UsageType usageTypeRest = new UsageType();
            usageTypeRest.setCode(usageType.getCode());
            usageTypeRest.setName(usageType.getName());
            usageTypeRest.setActive(usageType.isActive());
            prepareListForRest.add(usageTypeRest);
        }
        return prepareListForRest;
    }
}

