/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.service;

import java.util.ArrayList;
import java.util.List;
import org.egov.wtms.masters.entity.PipeSize;
import org.egov.wtms.masters.entity.PropertyPipeSize;
import org.egov.wtms.masters.repository.PipeSizeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PipeSizeService {
    private final PipeSizeRepository pipeSizeRepository;

    @Autowired
    public PipeSizeService(PipeSizeRepository pipeSizeRepository) {
        this.pipeSizeRepository = pipeSizeRepository;
    }

    public PipeSize findBy(Long pipeSizeId) {
        return (PipeSize)((Object)this.pipeSizeRepository.findOne(pipeSizeId));
    }

    @Transactional
    public PipeSize createPipeSize(PipeSize pipeSize) {
        return (PipeSize)((Object)this.pipeSizeRepository.save((Object)pipeSize));
    }

    @Transactional
    public void updatePipeSize(PipeSize pipeSize) {
        this.pipeSizeRepository.save((Object)pipeSize);
    }

    public List<PipeSize> findAll() {
        return this.pipeSizeRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"code"}));
    }

    public PipeSize load(Long id) {
        return (PipeSize)((Object)this.pipeSizeRepository.getOne(id));
    }

    public Page<PipeSize> getListOfPipeSizes(Integer pageNumber, Integer pageSize) {
        PageRequest pageable = new PageRequest(pageNumber - 1, pageSize.intValue(), Sort.Direction.ASC, new String[]{"code"});
        return this.pipeSizeRepository.findAll((Pageable)pageable);
    }

    public PipeSize findByCode(String code) {
        return this.pipeSizeRepository.findByCode(code);
    }

    public List<PipeSize> getAllActivePipeSize() {
        return this.pipeSizeRepository.findByActiveTrueOrderBySizeInInchAsc();
    }

    public List<PipeSize> getAllPipeSizesByPropertyType(Long propertyType) {
        return this.pipeSizeRepository.getAllPipeSizesByPropertyType(propertyType);
    }

    public PropertyPipeSize getAllPipeSizesByPropertyTypeAnPipeSize(String propertyType, String pipesizeCode) {
        return this.pipeSizeRepository.getAllPipeSizesByPropertyTypeAndPipesize(propertyType, pipesizeCode);
    }

    public List<PipeSize> getPipeSizeListForRest() {
        List<PipeSize> pipeSizeList = this.pipeSizeRepository.findByActiveTrueOrderBySizeInInchAsc();
        ArrayList<PipeSize> prepareListForRest = new ArrayList<PipeSize>(0);
        for (PipeSize pipeSize : pipeSizeList) {
            PipeSize pipeSizeRest = new PipeSize();
            pipeSizeRest.setCode(pipeSize.getCode());
            pipeSizeRest.setSizeInInch(pipeSize.getSizeInInch());
            pipeSizeRest.setSizeInMilimeter(pipeSize.getSizeInMilimeter());
            pipeSizeRest.setActive(pipeSize.isActive());
            prepareListForRest.add(pipeSizeRest);
        }
        return prepareListForRest;
    }
}

