/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.service;

import java.util.List;
import org.egov.wtms.masters.entity.ConnectionCategory;
import org.egov.wtms.masters.entity.DonationHeader;
import org.egov.wtms.masters.entity.UsageType;
import org.egov.wtms.masters.repository.DonationHeaderRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DonationHeaderService {
    private final DonationHeaderRepository donationHeaderRepository;

    @Autowired
    public DonationHeaderService(DonationHeaderRepository donationHeaderRepository) {
        this.donationHeaderRepository = donationHeaderRepository;
    }

    public DonationHeader findBy(Long donationHeaderId) {
        return (DonationHeader)((Object)this.donationHeaderRepository.findOne(donationHeaderId));
    }

    @Transactional
    public DonationHeader createDonationHeader(DonationHeader donationHeader) {
        return (DonationHeader)((Object)this.donationHeaderRepository.save((Object)donationHeader));
    }

    @Transactional
    public void updateDonationHeader(DonationHeader donationHeader) {
        this.donationHeaderRepository.save((Object)donationHeader);
    }

    public List<DonationHeader> findAll() {
        return this.donationHeaderRepository.findAll();
    }

    public List<DonationHeader> findAllByCategory(ConnectionCategory category) {
        return this.donationHeaderRepository.findAllByCategory(category);
    }

    public List<DonationHeader> findAllByUsageType(UsageType usageType) {
        return this.donationHeaderRepository.findAllByUsageType(usageType);
    }

    public DonationHeader load(Long id) {
        return (DonationHeader)((Object)this.donationHeaderRepository.getOne(id));
    }

    public List<DonationHeader> findByCategoryandUsage(ConnectionCategory category, UsageType usageType) {
        return this.donationHeaderRepository.findByCategoryAndUsageType(category, usageType);
    }

    public DonationHeader findByCategoryandUsageandMinPipeSize(ConnectionCategory category, UsageType usageType, double pipeSize) {
        return this.donationHeaderRepository.findByCategoryAndUsageTypeAndPipeSize(category, usageType, pipeSize);
    }
}

