/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.service;

import java.util.ArrayList;
import java.util.List;
import org.egov.wtms.masters.entity.ConnectionCategory;
import org.egov.wtms.masters.entity.PropertyCategory;
import org.egov.wtms.masters.repository.ConnectionCategoryRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ConnectionCategoryService {
    private final ConnectionCategoryRepository connectionCategoryRepository;

    @Autowired
    public ConnectionCategoryService(ConnectionCategoryRepository connectionCategoryRepository) {
        this.connectionCategoryRepository = connectionCategoryRepository;
    }

    public ConnectionCategory findBy(Long connectionCategoryId) {
        return (ConnectionCategory)((Object)this.connectionCategoryRepository.findOne(connectionCategoryId));
    }

    @Transactional
    public ConnectionCategory createConnectionCategory(ConnectionCategory connectionCategory) {
        return (ConnectionCategory)((Object)this.connectionCategoryRepository.save((Object)connectionCategory));
    }

    @Transactional
    public void updateConnectionCategory(ConnectionCategory connectionCategory) {
        this.connectionCategoryRepository.save((Object)connectionCategory);
    }

    public List<ConnectionCategory> findAll() {
        return this.connectionCategoryRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public List<ConnectionCategory> findAllByNameLike(String name) {
        return this.connectionCategoryRepository.findByNameContainingIgnoreCase(name);
    }

    public ConnectionCategory findByName(String name) {
        return this.connectionCategoryRepository.findByName(name);
    }

    public ConnectionCategory load(Long id) {
        return (ConnectionCategory)((Object)this.connectionCategoryRepository.getOne(id));
    }

    public Page<ConnectionCategory> getListOfConnectionCategory(Integer pageNumber, Integer pageSize) {
        PageRequest pageable = new PageRequest(pageNumber - 1, pageSize.intValue(), Sort.Direction.ASC, new String[]{"name"});
        return this.connectionCategoryRepository.findAll((Pageable)pageable);
    }

    public ConnectionCategory findByCode(String code) {
        return this.connectionCategoryRepository.findByCode(code);
    }

    public List<ConnectionCategory> getAllActiveConnectionCategory() {
        return this.connectionCategoryRepository.findByActiveTrueOrderByNameAsc();
    }

    public List<ConnectionCategory> getAllCategoryTypesByPropertyType(Long propertyType, String connectionType) {
        if (connectionType.equals("ADDNLCONNECTION")) {
            return this.connectionCategoryRepository.getAllCategoryTypesByPropertyTypeNotInBPL(propertyType);
        }
        return this.connectionCategoryRepository.getAllCategoryTypesByPropertyType(propertyType);
    }

    public PropertyCategory getAllCategoryTypesByPropertyTypeAndCategory(String propertyType, String categoryType) {
        return this.connectionCategoryRepository.getAllCategoryTypesByPropertyTypeAndCategory(propertyType, categoryType);
    }

    public List<ConnectionCategory> getConnectionCategoryListForRest() {
        List<ConnectionCategory> connectionCategoryList = this.connectionCategoryRepository.findByActiveTrueOrderByNameAsc();
        ArrayList<ConnectionCategory> prepareListForRest = new ArrayList<ConnectionCategory>(0);
        for (ConnectionCategory connectionCategory : connectionCategoryList) {
            ConnectionCategory connectionCategoryRest = new ConnectionCategory();
            connectionCategoryRest.setCode(connectionCategory.getCode());
            connectionCategoryRest.setName(connectionCategory.getName());
            connectionCategoryRest.setActive(connectionCategory.isActive());
            prepareListForRest.add(connectionCategoryRest);
        }
        return prepareListForRest;
    }
}

