/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.service;

import java.util.List;
import org.egov.wtms.masters.entity.ApplicationProcessTime;
import org.egov.wtms.masters.entity.ApplicationType;
import org.egov.wtms.masters.entity.ConnectionCategory;
import org.egov.wtms.masters.repository.ApplicationProcessTimeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ApplicationProcessTimeService {
    private final ApplicationProcessTimeRepository applicationProcessTimeRepository;

    @Autowired
    public ApplicationProcessTimeService(ApplicationProcessTimeRepository applicationProcessTimeRepository) {
        this.applicationProcessTimeRepository = applicationProcessTimeRepository;
    }

    public ApplicationProcessTime findBy(Long applicationProcessId) {
        return (ApplicationProcessTime)((Object)this.applicationProcessTimeRepository.findOne(applicationProcessId));
    }

    @Transactional
    public ApplicationProcessTime createApplicationProcessTime(ApplicationProcessTime applicationProcessTime) {
        return (ApplicationProcessTime)((Object)this.applicationProcessTimeRepository.save((Object)applicationProcessTime));
    }

    @Transactional
    public void updateApplicationProcessTime(ApplicationProcessTime applicationProcessTime) {
        this.applicationProcessTimeRepository.save((Object)applicationProcessTime);
    }

    public List<ApplicationProcessTime> findAll() {
        return this.applicationProcessTimeRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"applicationType", "category"}));
    }

    public List<ApplicationProcessTime> findByApplicationType(ApplicationType applicationType) {
        return this.applicationProcessTimeRepository.findByApplicationType(applicationType);
    }

    public List<ApplicationProcessTime> findByCategory(ConnectionCategory category) {
        return this.applicationProcessTimeRepository.findByCategory(category);
    }

    public ApplicationProcessTime load(Long id) {
        return (ApplicationProcessTime)((Object)this.applicationProcessTimeRepository.getOne(id));
    }

    public Page<ApplicationProcessTime> getListOfApplicationProcessTime(Integer pageNumber, Integer pageSize) {
        PageRequest pageable = new PageRequest(pageNumber - 1, pageSize.intValue(), Sort.Direction.ASC, new String[]{"applicationType", "category"});
        return this.applicationProcessTimeRepository.findAll((Pageable)pageable);
    }

    public ApplicationProcessTime findByApplicationTypeandCategory(ApplicationType applicationType, ConnectionCategory category) {
        return this.applicationProcessTimeRepository.findByApplicationTypeAndCategory(applicationType, category);
    }

    public Integer getApplicationProcessTime(ApplicationType applicationType, ConnectionCategory category) {
        ApplicationProcessTime applicationProcessTime = this.applicationProcessTimeRepository.findByActiveTrueAndApplicationTypeAndCategory(applicationType, category);
        if (applicationProcessTime != null) {
            return applicationProcessTime.getProcessingTime();
        }
        return null;
    }
}

