/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.entity;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.wtms.masters.entity.ConnectionCategory;
import org.egov.wtms.masters.entity.DonationDetails;
import org.egov.wtms.masters.entity.PipeSize;
import org.egov.wtms.masters.entity.UsageType;

@Entity
@Table(name="egwtr_donation_header")
@SequenceGenerator(name="SEQ_EGWTR_DONATION_HEADER", sequenceName="SEQ_EGWTR_DONATION_HEADER", allocationSize=1)
public class DonationHeader
extends AbstractAuditable {
    private static final long serialVersionUID = 4583091947098722880L;
    public static final String SEQ_DONATIONHEADER = "SEQ_EGWTR_DONATION_HEADER";
    @Id
    @GeneratedValue(generator="SEQ_EGWTR_DONATION_HEADER", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne
    @NotNull
    @JoinColumn(name="category", nullable=false)
    private ConnectionCategory category;
    @ManyToOne
    @NotNull
    @JoinColumn(name="usagetype", nullable=false)
    private UsageType usageType;
    @ManyToOne
    @NotNull
    @JoinColumn(name="minpipesize", nullable=false)
    private PipeSize minPipeSize;
    @ManyToOne
    @NotNull
    @JoinColumn(name="maxpipesize", nullable=false)
    private PipeSize maxPipeSize;
    @NotNull
    private Long minSumpCapacity;
    @NotNull
    private Long maxSumpCapacity;
    private boolean active;
    @OneToMany(mappedBy="donationHeader", orphanRemoval=true, cascade={CascadeType.ALL})
    private Set<DonationDetails> donationDetails = new HashSet<DonationDetails>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ConnectionCategory getCategory() {
        return this.category;
    }

    public void setCategory(ConnectionCategory category) {
        this.category = category;
    }

    public UsageType getUsageType() {
        return this.usageType;
    }

    public void setUsageType(UsageType usageType) {
        this.usageType = usageType;
    }

    public PipeSize getMinPipeSize() {
        return this.minPipeSize;
    }

    public void setMinPipeSize(PipeSize minPipeSize) {
        this.minPipeSize = minPipeSize;
    }

    public PipeSize getMaxPipeSize() {
        return this.maxPipeSize;
    }

    public void setMaxPipeSize(PipeSize maxPipeSize) {
        this.maxPipeSize = maxPipeSize;
    }

    public Long getMinSumpCapacity() {
        return this.minSumpCapacity;
    }

    public void setMinSumpCapacity(Long minSumpCapacity) {
        this.minSumpCapacity = minSumpCapacity;
    }

    public Long getMaxSumpCapacity() {
        return this.maxSumpCapacity;
    }

    public void setMaxSumpCapacity(Long maxSumpCapacity) {
        this.maxSumpCapacity = maxSumpCapacity;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Set<DonationDetails> getDonationDetails() {
        return this.donationDetails;
    }

    public void setDonationDetails(Set<DonationDetails> donationDetails) {
        this.donationDetails = donationDetails;
    }

    public void addDonationDetails(DonationDetails donationDetail) {
        this.donationDetails.add(donationDetail);
    }
}

