/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.integration;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.ptis.wtms.ConsumerConsumption;
import org.egov.ptis.wtms.PropertyWiseConsumptions;
import org.egov.ptis.wtms.WaterChargesIntegrationService;
import org.egov.wtms.application.entity.NonMeteredConnBillDetails;
import org.egov.wtms.application.entity.WaterConnection;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.WaterConnectionService;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

public class WaterChargesIntegrationServiceImpl
implements WaterChargesIntegrationService {
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private WaterConnectionService waterConnectionService;
    @Autowired
    private ConnectionDemandService connectionDemandService;
    @Autowired
    private InstallmentDao installmentDao;

    public PropertyWiseConsumptions getPropertyWiseConsumptionsForWaterCharges(String propertyId) {
        PropertyWiseConsumptions propertyWiseConsumptions = new PropertyWiseConsumptions();
        propertyWiseConsumptions.setPropertyID(propertyId);
        BigDecimal currentTotal = BigDecimal.ZERO;
        BigDecimal arrearTotal = BigDecimal.ZERO;
        Installment arrInstal = null;
        Installment currentInstallment = this.connectionDemandService.getCurrentInstallment("Property Tax", null, new Date());
        List<WaterConnection> waterConnections = this.waterConnectionService.findByPropertyIdentifier(propertyId);
        ArrayList<ConsumerConsumption> consumerConsumptions = new ArrayList<ConsumerConsumption>();
        for (WaterConnection waterConnection : waterConnections) {
            WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByConnection(waterConnection);
            if (!waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE) || !ConnectionType.NON_METERED.equals((Object)waterConnectionDetails.getConnectionType())) continue;
            ConsumerConsumption consumerConsumption = new ConsumerConsumption();
            consumerConsumption.setHscno(waterConnectionDetails.getConnection().getConsumerCode());
            Map<String, BigDecimal> resultmap = this.connectionDemandService.getDemandCollMapForPtisIntegration(waterConnectionDetails, "Property Tax", null);
            if (null == resultmap || resultmap.isEmpty()) continue;
            BigDecimal arrInstallment = resultmap.get("ARR_INSTALL_FROM");
            if (null != arrInstallment && arrInstallment != BigDecimal.ZERO) {
                arrInstal = (Installment)this.installmentDao.findById((Serializable)Long.valueOf(arrInstallment.longValue()), false);
            }
            consumerConsumption.setCurrentDue(resultmap.get("CurrentDue"));
            consumerConsumption.setArrearDue(resultmap.get("ArrearDue"));
            if (null != arrInstal) {
                consumerConsumption.setArrearFromDate(new DateTime((Object)arrInstal.getFromDate()));
                consumerConsumption.setArrearToDate(new DateTime((Object)currentInstallment.getFromDate()).minusDays(1));
            }
            consumerConsumption.setCurrentFromDate(new DateTime((Object)currentInstallment.getFromDate()));
            consumerConsumption.setCurentToDate(new DateTime((Object)currentInstallment.getToDate()));
            consumerConsumptions.add(consumerConsumption);
            currentTotal = currentTotal.add(consumerConsumption.getCurrentDue());
            arrearTotal = arrearTotal.add(consumerConsumption.getArrearDue());
        }
        propertyWiseConsumptions.setCurrentTotal(currentTotal);
        propertyWiseConsumptions.setArrearTotal(arrearTotal);
        propertyWiseConsumptions.setConsumerConsumptions(consumerConsumptions);
        return propertyWiseConsumptions;
    }

    public boolean updateBillNo(String propertyId, String billNo) {
        List<WaterConnection> waterConnections = this.waterConnectionService.findByPropertyIdentifier(propertyId);
        HashSet<NonMeteredConnBillDetails> nonMeteredConnBillDetails = null;
        for (WaterConnection waterConnection : waterConnections) {
            Map<String, BigDecimal> resultmap;
            NonMeteredConnBillDetails nonMeteredConnBillDetail = new NonMeteredConnBillDetails();
            Installment installment = null;
            WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.getActiveNonHistoryConnectionDetailsByConnection(waterConnection);
            if (!ConnectionType.NON_METERED.equals((Object)waterConnectionDetails.getConnectionType()) || null == (resultmap = this.connectionDemandService.getDemandCollMapForBill(waterConnectionDetails, "Property Tax", null)) || resultmap.isEmpty()) continue;
            nonMeteredConnBillDetails = new HashSet<NonMeteredConnBillDetails>();
            BigDecimal install = resultmap.get("inst");
            installment = (Installment)this.installmentDao.findById((Serializable)Integer.valueOf(install.intValue()), false);
            nonMeteredConnBillDetail.setBillNo(billNo);
            nonMeteredConnBillDetail.setWaterConnectionDetails(this.waterConnectionDetailsService.findBy(resultmap.get("wcdid").longValue()));
            nonMeteredConnBillDetail.setInstallment(installment);
            nonMeteredConnBillDetails.add(nonMeteredConnBillDetail);
            waterConnectionDetails.setNonmeteredBillDetails(nonMeteredConnBillDetails);
            this.waterConnectionDetailsService.save(waterConnectionDetails);
        }
        return true;
    }
}

