/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.elasticSearch.service;

import java.math.BigDecimal;
import java.util.Iterator;
import org.egov.config.search.Index;
import org.egov.config.search.IndexType;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.search.elastic.annotation.Indexing;
import org.egov.infra.utils.EgovThreadLocals;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.elasticSearch.entity.ConsumerSearch;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ConsumerIndexService {
    @Autowired
    private CityService cityService;

    @Indexing(name=Index.WATERCHARGES, type=IndexType.CONNECTIONSEARCH)
    public ConsumerSearch createConsumerIndex(WaterConnectionDetails waterConnectionDetails, AssessmentDetails assessmentDetails, BigDecimal amountTodisplayInIndex) {
        String mobileNumber = null;
        Iterator ownerNameItr = assessmentDetails.getOwnerNames().iterator();
        if (ownerNameItr != null && ownerNameItr.hasNext()) {
            mobileNumber = ((OwnerName)ownerNameItr.next()).getMobileNumber();
        }
        City cityWebsite = this.cityService.getCityByURL(EgovThreadLocals.getDomainName());
        ConsumerSearch consumerSearch = new ConsumerSearch(waterConnectionDetails.getConnection().getConsumerCode(), mobileNumber, waterConnectionDetails.getUsageType().getName(), cityWebsite.getName(), waterConnectionDetails.getCreatedDate());
        consumerSearch.setZone(assessmentDetails.getBoundaryDetails().getZoneName());
        consumerSearch.setWard(assessmentDetails.getBoundaryDetails().getWardName());
        consumerSearch.setTotalDue(assessmentDetails.getPropertyDetails().getTaxDue());
        consumerSearch.setClosureType(waterConnectionDetails.getCloseConnectionType());
        consumerSearch.setLocality(assessmentDetails.getPropertyAddress() != null ? assessmentDetails.getPropertyAddress() : "");
        consumerSearch.setPropertyId(waterConnectionDetails.getConnection().getPropertyIdentifier());
        consumerSearch.setApplicationCode(waterConnectionDetails.getApplicationType().getCode());
        consumerSearch.setStatus(waterConnectionDetails.getConnectionStatus().name());
        consumerSearch.setConnectionType(waterConnectionDetails.getConnectionType().name());
        consumerSearch.setWaterTaxDue(amountTodisplayInIndex);
        ownerNameItr = assessmentDetails.getOwnerNames().iterator();
        if (ownerNameItr.hasNext()) {
            consumerSearch.setConsumerName(((OwnerName)ownerNameItr.next()).getOwnerName());
            while (ownerNameItr.hasNext()) {
                consumerSearch.setConsumerName(consumerSearch.getConsumerName().concat(",".concat(((OwnerName)ownerNameItr.next()).getOwnerName())));
            }
        }
        return consumerSearch;
    }
}

