/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service.collection;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.models.BillReceiptInfoImpl;
import org.egov.collection.integration.models.ReceiptAccountInfo;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.integration.TaxCollection;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.workflow.WorkFlowMatrix;
import org.egov.pims.commons.Position;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.repository.WaterConnectionDetailsRepository;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.WaterConnectionSmsAndEmailService;
import org.egov.wtms.application.workflow.ApplicationWorkflowCustomDefaultImpl;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.utils.WaterTaxUtils;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class WaterTaxCollection
extends TaxCollection {
    private static final Logger LOGGER = Logger.getLogger(WaterTaxCollection.class);
    private BigDecimal totalAmount = BigDecimal.ZERO;
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private WaterConnectionDetailsRepository waterConnectionDetailsRepository;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private SimpleWorkflowService<WaterConnectionDetails> waterConnectionWorkflowService;
    @Autowired
    private WaterConnectionSmsAndEmailService waterConnectionSmsAndEmailService;
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public void updateDemandDetails(BillReceiptInfo billRcptInfo) {
        this.totalAmount = billRcptInfo.getTotalAmount();
        EgDemand demand = this.getCurrentDemand(Long.valueOf(billRcptInfo.getBillReferenceNum()));
        String indexNo = ((BillReceiptInfoImpl)billRcptInfo).getReceiptMisc().getReceiptHeader().getConsumerCode();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("updateDemandDetails : Demand before proceeding : " + demand));
            LOGGER.debug((Object)("updateDemandDetails : collection back update started for property : " + indexNo + " and receipt event is " + billRcptInfo.getEvent() + ". Total Receipt amount is." + this.totalAmount + " with receipt no." + billRcptInfo.getReceiptNum()));
        }
        if (billRcptInfo.getEvent().equals("RECEIPT_CREATED")) {
            this.updateCollForRcptCreate(demand, billRcptInfo);
            this.updateWaterConnectionDetails(demand);
            this.updateWaterTaxIndexes(demand);
        } else if (billRcptInfo.getEvent().equals("RECEIPT_CANCELLED")) {
            this.updateCollectionForRcptCancel(demand, billRcptInfo);
            this.updateWaterConnDetailsStatus(demand, billRcptInfo);
            this.updateWaterTaxIndexes(demand);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("updateDemandDetails : Demand after processed : " + demand));
        }
    }

    @Transactional
    public void updateWaterConnectionDetails(EgDemand demand) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.getWaterConnectionDetailsByDemand(demand);
        if (!waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE)) {
            waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("ESTIMATIONAMOUNTPAID", "WATERTAXAPPLICATION"));
            Long approvalPosition = 0L;
            WorkFlowMatrix wfmatrix = this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, "NEWCONNECTION", waterConnectionDetails.getCurrentState().getValue(), null);
            Position posobj = this.waterTaxUtils.getCityLevelCommissionerPosition(wfmatrix.getNextDesignation());
            if (posobj != null) {
                approvalPosition = posobj.getId();
            }
            ApplicationWorkflowCustomDefaultImpl applicationWorkflowCustomDefaultImpl = this.waterConnectionDetailsService.getInitialisedWorkFlowBean();
            applicationWorkflowCustomDefaultImpl.createCommonWorkflowTransition(waterConnectionDetails, approvalPosition, "Water connection fee collected", "NEWCONNECTION", null);
            this.waterConnectionSmsAndEmailService.sendSmsAndEmail(waterConnectionDetails, null);
            this.waterConnectionDetailsRepository.saveAndFlush((Object)waterConnectionDetails);
        }
    }

    @Transactional
    private void updateCollForRcptCreate(EgDemand demand, BillReceiptInfo billRcptInfo) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("updateCollForRcptCreate : Updating Collection Started For Demand : " + demand + " with BillReceiptInfo - " + billRcptInfo));
        }
        this.updateDemandDetailForReceiptCreate(billRcptInfo.getAccountDetails(), demand, billRcptInfo);
    }

    @Transactional
    private void updateDemandDetailForReceiptCreate(Set<ReceiptAccountInfo> accountDetails, EgDemand demand, BillReceiptInfo billRcptInfo) {
        StringBuffer query = new StringBuffer("select dmdet FROM EgDemandDetails dmdet left join fetch dmdet.egDemandReason dmdRsn ").append("left join fetch dmdRsn.egDemandReasonMaster dmdRsnMstr left join fetch dmdRsn.egInstallmentMaster installment ").append("WHERE dmdet.egDemand.id = :demand");
        List demandDetailList = this.getCurrentSession().createQuery(query.toString()).setLong("demand", demand.getId().longValue()).list();
        HashMap installmentWiseDemandDetailsByReason = new HashMap();
        HashMap<String, EgDemandDetails> demandDetailByReason = null;
        EgDemandReason dmdRsn = null;
        String installmentDesc = null;
        for (EgDemandDetails dmdDtls : demandDetailList) {
            if (dmdDtls.getAmount().compareTo(BigDecimal.ZERO) > 0) {
                dmdRsn = dmdDtls.getEgDemandReason();
                installmentDesc = dmdRsn.getEgInstallmentMaster().getDescription();
                demandDetailByReason = new HashMap<String, EgDemandDetails>();
                if (installmentWiseDemandDetailsByReason.get(installmentDesc) == null) {
                    demandDetailByReason.put(dmdRsn.getEgDemandReasonMaster().getReasonMaster(), dmdDtls);
                    installmentWiseDemandDetailsByReason.put(installmentDesc, demandDetailByReason);
                    continue;
                }
                ((Map)installmentWiseDemandDetailsByReason.get(installmentDesc)).put(dmdRsn.getEgDemandReasonMaster().getReasonMaster(), dmdDtls);
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("saveCollectionDetails - demand detail amount is zero " + dmdDtls));
        }
        EgDemandDetails demandDetail = null;
        for (ReceiptAccountInfo rcptAccInfo : accountDetails) {
            if (rcptAccInfo.getDescription() == null || rcptAccInfo.getDescription().isEmpty() || rcptAccInfo.getCrAmount() == null || rcptAccInfo.getCrAmount().compareTo(BigDecimal.ZERO) != 1) continue;
            String[] desc = rcptAccInfo.getDescription().split("-", 2);
            String reason = desc[0].trim();
            String instDesc = desc[1].trim();
            demandDetail = (EgDemandDetails)((Map)installmentWiseDemandDetailsByReason.get(instDesc)).get(reason);
            demandDetail.addCollectedWithOnePaisaTolerance(rcptAccInfo.getCrAmount());
            if (demandDetail.getEgDemandReason().getEgDemandReasonMaster().getIsDemand().booleanValue()) {
                demand.addCollected(rcptAccInfo.getCrAmount());
            }
            this.persistCollectedReceipts(demandDetail, billRcptInfo.getReceiptNum(), this.totalAmount, billRcptInfo.getReceiptDate(), demandDetail.getAmtCollected());
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("Persisted demand and receipt details for tax : " + reason + " installment : " + instDesc + " with receipt No : " + billRcptInfo.getReceiptNum() + " for Rs. " + rcptAccInfo.getCrAmount()));
        }
    }

    protected Module module() {
        return this.moduleService.getModuleByName("Water Tax Management");
    }

    public EgDemand getCurrentDemand(Long billId) {
        EgBill egBill = this.egBillDAO.findById(billId, false);
        return egBill.getEgDemand();
    }

    @Transactional
    private void updateCollectionForRcptCancel(EgDemand demand, BillReceiptInfo billRcptInfo) {
        LOGGER.debug((Object)("reconcileCollForRcptCancel : Updating Collection Started For Demand : " + demand + " with BillReceiptInfo - " + billRcptInfo));
        this.cancelBill(Long.valueOf(billRcptInfo.getBillReferenceNum()));
        if (demand.getAmtCollected() != null && demand.getAmtCollected() != BigDecimal.ZERO) {
            demand.setAmtCollected(demand.getAmtCollected().subtract(billRcptInfo.getTotalAmount()));
        }
        this.updateDmdDetForRcptCancel(demand, billRcptInfo);
        LOGGER.debug((Object)("reconcileCollForRcptCancel : Updating Collection finished For Demand : " + demand));
    }

    @Transactional
    private void cancelBill(Long billId) {
        if (billId != null) {
            EgBill egBill = this.egBillDAO.findById(billId, false);
            egBill.setIs_Cancelled("Y");
        }
    }

    @Transactional
    private void updateDmdDetForRcptCancel(EgDemand demand, BillReceiptInfo billRcptInfo) {
        LOGGER.debug((Object)"Entering method updateDmdDetForRcptCancel");
        for (ReceiptAccountInfo rcptAccInfo : billRcptInfo.getAccountDetails()) {
            if (rcptAccInfo.getCrAmount() == null || rcptAccInfo.getCrAmount().compareTo(BigDecimal.ZERO) != 1 || rcptAccInfo.getIsRevenueAccount()) continue;
            String[] desc = rcptAccInfo.getDescription().split("-", 2);
            String reason = desc[0].trim();
            String installment = desc[1].trim();
            for (EgDemandDetails demandDetail : demand.getEgDemandDetails()) {
                if (!reason.equalsIgnoreCase(demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster())) continue;
                if (demandDetail.getAmtCollected().compareTo(rcptAccInfo.getCrAmount()) < 0) {
                    throw new ApplicationRuntimeException("updateDmdDetForRcptCancel : Exception while updating cancel receipt, to be deducted amount " + rcptAccInfo.getCrAmount() + " is greater than the collected amount " + demandDetail.getAmtCollected() + " for demandDetail " + demandDetail);
                }
                demandDetail.setAmtCollected(demandDetail.getAmtCollected().subtract(rcptAccInfo.getCrAmount()));
                LOGGER.info((Object)("Deducted Collected amount Rs." + rcptAccInfo.getCrAmount() + " for tax : " + reason + " and installment : " + installment));
            }
        }
        this.updateReceiptStatusWhenCancelled(billRcptInfo.getReceiptNum());
        LOGGER.debug((Object)"Exiting method updateDmdDetForRcptCancel");
    }

    @Transactional
    private void updateWaterConnDetailsStatus(EgDemand demand, BillReceiptInfo billRcptInfo) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.getWaterConnectionDetailsByDemand(demand);
        StateHistory stateHistory = null;
        if (waterConnectionDetails.getStatus().getCode().equalsIgnoreCase("ESTIMATIONAMOUNTPAID")) {
            Position owner;
            waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("ESTIMATIONNOTICEGENERATED", "WATERTAXAPPLICATION"));
            Long approvalPosition = 0L;
            if (!waterConnectionDetails.getStateHistory().isEmpty() && waterConnectionDetails.getStateHistory() != null) {
                Collections.reverse(waterConnectionDetails.getStateHistory());
            }
            if ((owner = (stateHistory = (StateHistory)waterConnectionDetails.getStateHistory().get(0)).getOwnerPosition()) != null) {
                approvalPosition = owner.getId();
            }
            ApplicationWorkflowCustomDefaultImpl applicationWorkflowCustomDefaultImpl = this.waterConnectionDetailsService.getInitialisedWorkFlowBean();
            applicationWorkflowCustomDefaultImpl.createCommonWorkflowTransition(waterConnectionDetails, approvalPosition, "Receipt Cancelled", "NEWCONNECTION", null);
        }
    }

    private void updateWaterTaxIndexes(EgDemand demand) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.getWaterConnectionDetailsByDemand(demand);
        this.waterConnectionDetailsService.updateIndexes(waterConnectionDetails);
    }

    public List<ReceiptDetail> reconstructReceiptDetail(String billReferenceNumber, BigDecimal actualAmountPaid) {
        return null;
    }
}

