/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service.collection;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.AbstractBillable;
import org.egov.demand.model.EgBillType;
import org.egov.demand.model.EgDemand;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.BoundaryDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class WaterConnectionBillable
extends AbstractBillable
implements Billable {
    private static final String STRING_DEPARTMENT_CODE = "R";
    private static final String STRING_SERVICE_CODE = "WT";
    public static final String DEFAULT_FUNCTIONARY_CODE = "1";
    public static final String DEFAULT_FUND_SRC_CODE = "01";
    public static final String DEFAULT_FUND_CODE = "01";
    private WaterConnectionDetails WaterConnectionDetails;
    private AssessmentDetails assessmentDetails;
    private Long userId;
    private EgBillType billType;
    private Boolean isCallbackForApportion = Boolean.FALSE;
    private String referenceNumber;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private UserService userService;
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private ConnectionDemandService connectioDemanService;

    public String getBillPayee() {
        return this.buildOwnerFullName(this.getAssessmentDetails().getOwnerNames());
    }

    public String getBillAddress() {
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(this.getWaterConnectionDetails().getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS);
        return this.buildAddressDetails(assessmentDetails);
    }

    public EgDemand getCurrentDemand() {
        return this.getWaterConnectionDetails().getDemand();
    }

    public List<EgDemand> getAllDemands() {
        return null;
    }

    public EgBillType getBillType() {
        String loginUser;
        if (this.billType == null && this.getUserId() != null && !this.getUserId().equals("") && !(loginUser = this.userService.getUserById(this.getUserId()).getName()).equals("9999999999")) {
            this.billType = this.egBillDAO.getBillTypeByCode("MANUAL");
        }
        return this.billType;
    }

    public Date getBillLastDueDate() {
        return new DateTime().plusMonths(1).toDate();
    }

    public Long getBoundaryNum() {
        return this.getAssessmentDetails().getBoundaryDetails().getWardNumber();
    }

    public String getBoundaryType() {
        return "Ward";
    }

    public String getDepartmentCode() {
        return STRING_DEPARTMENT_CODE;
    }

    public BigDecimal getFunctionaryCode() {
        return new BigDecimal(DEFAULT_FUNCTIONARY_CODE);
    }

    public String getFundCode() {
        return "01";
    }

    public String getFundSourceCode() {
        return DEFAULT_FUNCTIONARY_CODE;
    }

    public Date getIssueDate() {
        return new Date();
    }

    public Date getLastDate() {
        return this.getBillLastDueDate();
    }

    public Module getModule() {
        return this.moduleService.getModuleByName("Water Tax Management");
    }

    public Boolean getOverrideAccountHeadsAllowed() {
        return false;
    }

    public Boolean getPartPaymentAllowed() {
        return false;
    }

    public String getServiceCode() {
        return STRING_SERVICE_CODE;
    }

    public BigDecimal getTotalAmount() {
        EgDemand currentDemand = this.getCurrentDemand();
        List<Object> instVsAmt = this.connectioDemanService.getDmdCollAmtInstallmentWise(currentDemand);
        BigDecimal balance = BigDecimal.ZERO;
        for (Object object : instVsAmt) {
            Object[] ddObject = (Object[])object;
            BigDecimal dmdAmt = (BigDecimal)ddObject[2];
            BigDecimal collAmt = BigDecimal.ZERO;
            if (ddObject[2] != null) {
                collAmt = new BigDecimal((Double)ddObject[3]);
            }
            balance = balance.add(dmdAmt.subtract(collAmt));
        }
        return balance;
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getDescription() {
        if (null != this.getWaterConnectionDetails().getConnection().getConsumerCode()) {
            return "Water Tax H.S.C No: " + this.getWaterConnectionDetails().getConnection().getConsumerCode();
        }
        return "Water Tax Application Number: " + this.getWaterConnectionDetails().getApplicationNumber();
    }

    public String getDisplayMessage() {
        return "Water Tax Collection";
    }

    public String getCollModesNotAllowed() {
        if (ConnectionStatus.ACTIVE.equals((Object)this.getWaterConnectionDetails().getConnectionStatus())) {
            return "bankchallan";
        }
        return "bankchallan,dd,cheque";
    }

    public String getConsumerId() {
        return this.getWaterConnectionDetails().getApplicationNumber();
    }

    public Boolean isCallbackForApportion() {
        return this.isCallbackForApportion;
    }

    public void setCallbackForApportion(Boolean b) {
        this.isCallbackForApportion = b;
    }

    public WaterConnectionDetails getWaterConnectionDetails() {
        return this.WaterConnectionDetails;
    }

    public void setWaterConnectionDetails(WaterConnectionDetails waterConnectionDetails) {
        this.WaterConnectionDetails = waterConnectionDetails;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setBillType(EgBillType billType) {
        this.billType = billType;
    }

    public String buildOwnerFullName(Set<OwnerName> ownerSet) {
        if (ownerSet == null) {
            throw new ApplicationRuntimeException("Property Owner set is null...");
        }
        String ownerFullName = "";
        HashSet<String> ownerNameSet = new HashSet<String>();
        for (OwnerName propOwnerInfo : ownerSet) {
            if (propOwnerInfo.getOwnerName() == null || propOwnerInfo.getOwnerName().trim().equals("") || ownerNameSet.contains(propOwnerInfo.getOwnerName().trim())) continue;
            if (!ownerFullName.trim().equals("") && !ownerFullName.equals("")) {
                ownerFullName = ownerFullName + ", ";
            }
            ownerNameSet.add(propOwnerInfo.getOwnerName().trim());
            ownerFullName = propOwnerInfo.getOwnerName() == null ? "" : propOwnerInfo.getOwnerName();
        }
        return ownerFullName;
    }

    public String buildAddressDetails(AssessmentDetails assessmentDetails) {
        BoundaryDetails boundaryDetails = assessmentDetails.getBoundaryDetails();
        StringBuffer address = new StringBuffer();
        if (boundaryDetails.getZoneName() != null) {
            address.append(boundaryDetails.getZoneName());
        }
        if (boundaryDetails.getWardName() != null) {
            address.append(", ").append(boundaryDetails.getWardName());
        }
        if (boundaryDetails.getLocalityName() != null) {
            address.append(", ").append(boundaryDetails.getLocalityName());
        }
        if (boundaryDetails.getBlockName() != null) {
            address.append(", ").append(boundaryDetails.getBlockName());
        }
        if (boundaryDetails.getStreetName() != null) {
            address.append(", ").append(boundaryDetails.getStreetName());
        }
        return address.toString();
    }

    public AssessmentDetails getAssessmentDetails() {
        return this.assessmentDetails;
    }

    public void setAssessmentDetails(AssessmentDetails assessmentDetails) {
        this.assessmentDetails = assessmentDetails;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }
}

