/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service.collection;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.Installment;
import org.egov.demand.interfaces.BillServiceInterface;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.EgBillDetails;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.wtms.application.service.collection.DemandComparatorByOrderId;
import org.hibernate.Session;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ConnectionBillService
extends BillServiceInterface {
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<EgBillDetails> getBilldetails(Billable billObj) {
        ArrayList<EgBillDetails> billDetails = new ArrayList<EgBillDetails>();
        EgDemand demand = billObj.getCurrentDemand();
        Date currentDate = new Date();
        HashMap installmentWise = new HashMap();
        TreeSet<Installment> sortedInstallmentSet = new TreeSet<Installment>();
        DemandComparatorByOrderId demandComparatorByOrderId = new DemandComparatorByOrderId();
        ArrayList orderedDetailsList = new ArrayList();
        for (EgDemandDetails demandDetail : demand.getEgDemandDetails()) {
            Installment installment = demandDetail.getEgDemandReason().getEgInstallmentMaster();
            if (installmentWise.get(installment) == null) {
                ArrayList<EgDemandDetails> detailsList = new ArrayList<EgDemandDetails>();
                detailsList.add(demandDetail);
                installmentWise.put(demandDetail.getEgDemandReason().getEgInstallmentMaster(), detailsList);
                sortedInstallmentSet.add(installment);
                continue;
            }
            ((List)installmentWise.get(demandDetail.getEgDemandReason().getEgInstallmentMaster())).add(demandDetail);
        }
        for (Installment i : sortedInstallmentSet) {
            List installmentWiseDetails = (List)installmentWise.get(i);
            Collections.sort(installmentWiseDetails, demandComparatorByOrderId);
            orderedDetailsList.addAll(installmentWiseDetails);
        }
        int i = 1;
        for (EgDemandDetails demandDetail : orderedDetailsList) {
            EgDemandReason reason = demandDetail.getEgDemandReason();
            Installment installment = demandDetail.getEgDemandReason().getEgInstallmentMaster();
            if (!demandDetail.getEgDemandReason().getEgDemandReasonMaster().getIsDebit().equalsIgnoreCase("N") || demandDetail.getAmount().compareTo(demandDetail.getAmtCollected()) <= 0) continue;
            EgBillDetails billdetail = new EgBillDetails();
            if (demandDetail.getAmount() != null) {
                billdetail.setDrAmount(BigDecimal.ZERO);
                billdetail.setCrAmount(demandDetail.getAmount());
            }
            LOGGER.info((Object)("demandDetail.getEgDemandReason()" + demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster() + " glcodeerror" + demandDetail.getEgDemandReason().getGlcodeId()));
            billdetail.setGlcode(demandDetail.getEgDemandReason().getGlcodeId().getGlcode());
            billdetail.setEgDemandReason(demandDetail.getEgDemandReason());
            billdetail.setAdditionalFlag(Integer.valueOf(1));
            billdetail.setCreateDate(currentDate);
            billdetail.setModifiedDate(currentDate);
            billdetail.setOrderNo(Integer.valueOf(i++));
            billdetail.setDescription(reason.getEgDemandReasonMaster().getReasonMaster() + " - " + installment.getDescription());
            billDetails.add(billdetail);
        }
        return billDetails;
    }

    public void cancelBill() {
    }

    EgBillDetails createBillDet(Integer orderNo, BigDecimal billDetAmt, String glCode, String description, Integer addlFlag) {
        if (orderNo == null || billDetAmt == null || glCode == null) {
            throw new ApplicationRuntimeException("Exception in createBillDet....");
        }
        EgBillDetails billdetail = new EgBillDetails();
        billdetail.setFunctionCode("FUNCTION_CODE");
        billdetail.setOrderNo(orderNo);
        billdetail.setCreateDate(new Date());
        billdetail.setModifiedDate(new Date());
        billdetail.setCrAmount(billDetAmt);
        billdetail.setDrAmount(BigDecimal.ZERO);
        billdetail.setGlcode(glCode);
        billdetail.setDescription(description);
        billdetail.setAdditionalFlag(addlFlag);
        LOGGER.info((Object)("Bill Detail object created with amount " + billDetAmt));
        return billdetail;
    }
}

