/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.egov.wtms.utils.WaterTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;

@Service
public class WaterConnectionSmsAndEmailService {
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    private String applicantName;
    @Autowired
    private ResourceBundleMessageSource messageSource;

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }

    public String getApplicantNameBYAssessmentDetail(WaterConnectionDetails waterConnectionDetails) {
        AssessmentDetails assessmentDetailsfullFlag = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS);
        Iterator ownerNameItr = assessmentDetailsfullFlag.getOwnerNames().iterator();
        StringBuilder consumerName = new StringBuilder();
        if (ownerNameItr.hasNext()) {
            consumerName.append(((OwnerName)ownerNameItr.next()).getOwnerName());
            while (ownerNameItr.hasNext()) {
                consumerName.append(", ".concat(((OwnerName)ownerNameItr.next()).getOwnerName()));
            }
        }
        this.applicantName = consumerName.toString();
        return this.applicantName;
    }

    public void sendSmsAndEmail(WaterConnectionDetails waterConnectionDetails, String workFlowAction) {
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_MOBILE_EMAIL);
        String email = assessmentDetails.getPrimaryEmail();
        String mobileNumber = assessmentDetails.getPrimaryMobileNo();
        if (waterConnectionDetails != null && waterConnectionDetails.getApplicationType() != null && waterConnectionDetails.getApplicationType().getCode() != null && waterConnectionDetails.getStatus() != null && waterConnectionDetails.getStatus().getCode() != null) {
            this.getApplicantNameBYAssessmentDetail(waterConnectionDetails);
            if ("NEWCONNECTION".equalsIgnoreCase(waterConnectionDetails.getApplicationType().getCode())) {
                this.getSmsAndEmailForNewConnection(waterConnectionDetails, email, mobileNumber);
            } else if ("ADDNLCONNECTION".equalsIgnoreCase(waterConnectionDetails.getApplicationType().getCode())) {
                this.getSmsAndEmailForAdditionalConnection(waterConnectionDetails, email, mobileNumber);
            } else if ("CHANGEOFUSE".equalsIgnoreCase(waterConnectionDetails.getApplicationType().getCode())) {
                this.getSmsAndEmailForChangeOfUsageConnection(waterConnectionDetails, email, mobileNumber);
            }
        }
    }

    private void getSmsAndEmailForChangeOfUsageConnection(WaterConnectionDetails waterConnectionDetails, String email, String mobileNumber) {
        String smsMsg = null;
        String body = "";
        String subject = "";
        if (waterConnectionDetails.getState().getHistory().isEmpty() && "CREATED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.changeofuseconncetioncreate.sms", waterConnectionDetails, this.applicantName, "changeofusecreate");
            body = this.EmailBodyByCodeAndArgsWithType("msg.changeofuseconncetioncreate.email.body", waterConnectionDetails, this.applicantName, "changeofusecreate");
            subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.changeofuseconncetioncreate.email.subject", waterConnectionDetails.getApplicationNumber());
        } else if ("APPROVED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.changeofuseconnection.approval.sms", waterConnectionDetails, this.applicantName, "changeofuseapprove");
            body = this.EmailBodyByCodeAndArgsWithType("msg.changeofuseconnection.approval.email.body", waterConnectionDetails, this.applicantName, "changeofuseapprove");
            subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.changeofuseconnection.approval.subject", waterConnectionDetails.getApplicationNumber());
        } else if ("ESTIMATIONNOTICEGENERATED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            if (!"BPL".equalsIgnoreCase(waterConnectionDetails.getCategory().getName())) {
                smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.changeofuseconnection.notice.gen", waterConnectionDetails, this.applicantName, "changeofusenotice");
                body = this.EmailBodyByCodeAndArgsWithType("msg.changeofuseconnection.notice.email.body", waterConnectionDetails, this.applicantName, "changeofusenotice");
                subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.changeofuseconnection.notice.email.subject", waterConnectionDetails.getApplicationNumber());
            } else {
                body = this.EmailBodyByCodeAndArgsWithType("msg.noticegen.for.bpl.email.body", waterConnectionDetails, this.applicantName, "changeofusenotice");
                subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.noticegen.for.bpl.email.subject", waterConnectionDetails.getApplicationNumber());
                smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.noticegen.for.bpl.sms", waterConnectionDetails, this.applicantName, "changeofusenotice");
            }
        } else if ("ESTIMATIONAMOUNTPAID".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.newconncetionOnFeesPaid.sms", waterConnectionDetails, this.applicantName, "changeofusefeepaid");
            body = this.EmailBodyByCodeAndArgsWithType("msg.addconncetionOnfeespaid.email.body", waterConnectionDetails, this.applicantName, "changeofusefeepaid");
            StringBuilder emailSubject = new StringBuilder(" Demand and donation amount received for water tax application ");
            emailSubject.append(waterConnectionDetails.getApplicationNumber());
            subject = emailSubject.toString();
        } else if ("SANCTIONED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            if (!"Metered".toUpperCase().equalsIgnoreCase(waterConnectionDetails.getConnectionType().toString())) {
                smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.newconncetionOnExecutionDate.sms", waterConnectionDetails, this.applicantName, "changeofuseexecution");
                body = this.EmailBodyByCodeAndArgsWithType("msg.newconncetionOnExecutionDate.email.body", waterConnectionDetails, this.applicantName, "changeofuseexecution");
            } else {
                body = this.EmailBodyByCodeAndArgsWithType("msg.conncetionexeuction.metered.email.body", waterConnectionDetails, this.applicantName, "changeofuseexecution");
                smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.conncetionexeuction.metered.sms", waterConnectionDetails, this.applicantName, "changeofuseexecution");
            }
            subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.newconncetionOnExecutionDate.email.subject", waterConnectionDetails.getConnection().getConsumerCode());
        }
        if (mobileNumber != null && smsMsg != null) {
            this.waterTaxUtils.sendSMSOnWaterConnection(mobileNumber, smsMsg);
        }
        if (email != null && body != null) {
            this.waterTaxUtils.sendEmailOnWaterConnection(email, body, subject);
        }
    }

    private void getSmsAndEmailForAdditionalConnection(WaterConnectionDetails waterConnectionDetails, String email, String mobileNumber) {
        String smsMsg = null;
        String body = "";
        String subject = "";
        if (waterConnectionDetails.getState().getHistory().isEmpty() && "CREATED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.additionalconncetioncreate.sms", waterConnectionDetails, this.applicantName, "additionalconncreate");
            body = this.EmailBodyByCodeAndArgsWithType("msg.additionalconnectioncreate.email.body", waterConnectionDetails, this.applicantName, "additionalconncreate");
            subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.additionalconnectioncreate.email.subject", waterConnectionDetails.getApplicationNumber());
        } else if ("APPROVED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.additionalconncetionapproval.sms", waterConnectionDetails, this.applicantName, "additionalconnapprove");
            body = this.EmailBodyByCodeAndArgsWithType("msg.additionalconncetionapproval.email.body", waterConnectionDetails, this.applicantName, "additionalconnapprove");
            subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.additionalconncetionapproval.email.subject", waterConnectionDetails.getApplicationNumber());
        } else if ("ESTIMATIONNOTICEGENERATED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            if (!"BPL".equalsIgnoreCase(waterConnectionDetails.getCategory().getName())) {
                smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.addconncetionOnGenerateNotice.sms", waterConnectionDetails, this.applicantName, "addconnestnotice");
                body = this.EmailBodyByCodeAndArgsWithType("msg.addconncetionOnGenerateNotice.email.body", waterConnectionDetails, this.applicantName, "addconnestnotice");
                subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.conncetionOnGenerateNotice.email.subject", waterConnectionDetails.getApplicationNumber());
            } else {
                smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.noticegen.for.bpl.sms", waterConnectionDetails, this.applicantName, "addconnestnotice");
                body = this.EmailBodyByCodeAndArgsWithType("msg.noticegen.for.bpl.email.body", waterConnectionDetails, this.applicantName, "addconnestnotice");
                subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.noticegen.for.bpl.email.subject", waterConnectionDetails.getApplicationNumber());
            }
        } else if ("ESTIMATIONAMOUNTPAID".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.newconncetionOnFeesPaid.sms", waterConnectionDetails, this.applicantName, "newconnfeepaid");
            body = this.EmailBodyByCodeAndArgsWithType("msg.addconncetionOnfeespaid.email.body", waterConnectionDetails, this.applicantName, "newconnfeepaid");
            StringBuilder emailSubject = new StringBuilder(" Demand and donation amount received for water tax application ");
            emailSubject.append(waterConnectionDetails.getApplicationNumber());
            subject = emailSubject.toString();
        } else if ("SANCTIONED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            if (!"Metered".toUpperCase().equalsIgnoreCase(waterConnectionDetails.getConnectionType().toString())) {
                smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.newconncetionOnExecutionDate.sms", waterConnectionDetails, this.applicantName, "newconnexecutiondate");
                body = this.EmailBodyByCodeAndArgsWithType("msg.newconncetionOnExecutionDate.email.body", waterConnectionDetails, this.applicantName, "newconnexecutiondate");
            } else {
                body = this.EmailBodyByCodeAndArgsWithType("msg.conncetionexeuction.metered.email.body", waterConnectionDetails, this.applicantName, "newconnexecutiondate");
                smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.conncetionexeuction.metered.sms", waterConnectionDetails, this.applicantName, "newconnexecutiondate");
            }
            subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.newconncetionOnExecutionDate.email.subject", waterConnectionDetails.getConnection().getConsumerCode());
        }
        if (mobileNumber != null && smsMsg != null) {
            this.waterTaxUtils.sendSMSOnWaterConnection(mobileNumber, smsMsg);
        }
        if (email != null && body != null) {
            this.waterTaxUtils.sendEmailOnWaterConnection(email, body, subject);
        }
    }

    public void getSmsAndEmailForNewConnection(WaterConnectionDetails waterConnectionDetails, String email, String mobileNumber) {
        String smsMsg = null;
        String body = "";
        String subject = "";
        if (waterConnectionDetails.getState().getHistory().isEmpty() && "CREATED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.newconncetioncreate.sms", waterConnectionDetails, this.applicantName, "newconncreate");
            body = this.EmailBodyByCodeAndArgsWithType("msg.newconncetioncreate.email.body", waterConnectionDetails, this.applicantName, "newconncreate");
            subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.newconncetioncreate.email.subject", waterConnectionDetails.getApplicationNumber());
        } else if ("APPROVED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.newconncetionapproval.sms", waterConnectionDetails, this.applicantName, "newconnapprove");
            body = this.EmailBodyByCodeAndArgsWithType("msg.newconncetionapproval.email.body", waterConnectionDetails, this.applicantName, "newconnapprove");
            subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.newconncetionapprove.email.subject", waterConnectionDetails.getApplicationNumber());
        } else if ("ESTIMATIONNOTICEGENERATED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            if (!"BPL".equalsIgnoreCase(waterConnectionDetails.getCategory().getName())) {
                smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.newconncetionOnGenerateNotice.sms", waterConnectionDetails, this.applicantName, "newconnestnotice");
                body = this.EmailBodyByCodeAndArgsWithType("msg.newconncetionOnGenerateNotice.email.body", waterConnectionDetails, this.applicantName, "newconnestnotice");
                subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.conncetionOnGenerateNotice.email.subject", waterConnectionDetails.getApplicationNumber());
            } else {
                smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.noticegen.for.bpl.sms", waterConnectionDetails, this.applicantName, "newconnestnotice");
                body = this.EmailBodyByCodeAndArgsWithType("msg.noticegen.for.bpl.email.body", waterConnectionDetails, this.applicantName, "newconnestnotice");
                subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.noticegen.for.bpl.email.subject", waterConnectionDetails.getApplicationNumber());
            }
        } else if ("ESTIMATIONAMOUNTPAID".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.newconncetionOnFeesPaid.sms", waterConnectionDetails, this.applicantName, "newconnfeepaid");
            body = this.EmailBodyByCodeAndArgsWithType("msg.addconncetionOnfeespaid.email.body", waterConnectionDetails, this.applicantName, "newconnfeepaid");
            StringBuilder emailSubject = new StringBuilder(" Demand and donation amount received for water tax application ");
            emailSubject.append(waterConnectionDetails.getApplicationNumber());
            subject = emailSubject.toString();
        } else if ("SANCTIONED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            if (!"Metered".toUpperCase().equalsIgnoreCase(waterConnectionDetails.getConnectionType().toString())) {
                smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.newconncetionOnExecutionDate.sms", waterConnectionDetails, this.applicantName, "newconnexecutiondate");
                body = this.EmailBodyByCodeAndArgsWithType("msg.newconncetionOnExecutionDate.email.body", waterConnectionDetails, this.applicantName, "newconnexecutiondate");
            } else {
                smsMsg = this.SmsBodyByCodeAndArgsWithType("msg.conncetionexeuction.metered.sms", waterConnectionDetails, this.applicantName, "newconnexecutiondate");
                body = this.EmailBodyByCodeAndArgsWithType("msg.conncetionexeuction.metered.email.body", waterConnectionDetails, this.applicantName, "newconnexecutiondate");
            }
            subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.newconncetionOnExecutionDate.email.subject", waterConnectionDetails.getConnection().getConsumerCode());
        }
        if (mobileNumber != null && smsMsg != null) {
            this.waterTaxUtils.sendSMSOnWaterConnection(mobileNumber, smsMsg);
        }
        if (email != null && body != null) {
            this.waterTaxUtils.sendEmailOnWaterConnection(email, body, subject);
        }
    }

    public void sendSmsAndEmailOnRejection(WaterConnectionDetails waterConnectionDetails, String approvalComent) {
        if ((waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equalsIgnoreCase("ADDNLCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equalsIgnoreCase("CHANGEOFUSE")) && waterConnectionDetails.getStatus().getCode().equals("CANCELLED")) {
            AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_MOBILE_EMAIL);
            String email = assessmentDetails.getPrimaryEmail();
            String mobileNumber = assessmentDetails.getPrimaryMobileNo();
            this.getApplicantNameBYAssessmentDetail(waterConnectionDetails);
            String smsMsg = "";
            String body = "";
            String subject = "";
            if (this.waterTaxUtils.isSmsEnabled().booleanValue() && mobileNumber != null) {
                StringBuffer smsBody;
                if (waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION")) {
                    smsBody = new StringBuffer().append("Dear ").append(this.applicantName).append(",Your new water tap connection application is being rejected and ").append("the reason for rejection ").append(approvalComent).append(" Please get in touch with ULB official to raise a new application with proper information to get a water connection.").append("\nThanks,").append(this.waterTaxUtils.getCityName());
                    smsMsg = smsBody.toString();
                } else if (waterConnectionDetails.getApplicationType().getCode().equals("ADDNLCONNECTION")) {
                    smsBody = new StringBuffer().append("Dear ").append(this.applicantName).append(",Your additional water tap connection application is being rejected and ").append("the reason for rejection ").append(approvalComent).append(" Please get in touch with ULB official to raise a new application with proper information to get a water connection.").append("\nThanks,").append(this.waterTaxUtils.getCityName());
                    smsMsg = smsBody.toString();
                } else if (waterConnectionDetails.getApplicationType().getCode().equals("CHANGEOFUSE")) {
                    smsBody = new StringBuffer().append("Dear ").append(this.applicantName).append(",Your change of use  connection application is being rejected and ").append("the reason for rejection ").append(approvalComent).append(" Please get in touch with ULB official to raise a new application with proper information to get a water connection.").append("\nThanks,").append(this.waterTaxUtils.getCityName());
                    smsMsg = smsBody.toString();
                }
                this.waterTaxUtils.sendSMSOnWaterConnection(mobileNumber, smsMsg);
            }
            if (this.waterTaxUtils.isSmsEnabled().booleanValue() && email != null) {
                StringBuffer bodyMsg;
                if (waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION")) {
                    bodyMsg = new StringBuffer().append("Dear ").append(this.applicantName).append(",\n\nYour new water tap connection application is being rejected and the reason for rejection ").append(approvalComent).append("\n \n Please get in touch with ULB official to raise a new application with proper information to get a water connection.").append("\n\nThis is computer generated email and does not need any signature and also please  do not reply to this email.").append("\n\nThanks ,\n").append(this.waterTaxUtils.getCityName());
                    StringBuffer subjectMsg = new StringBuffer().append("Water tap connection application").append(waterConnectionDetails.getApplicationNumber()).append("rejected.");
                    body = bodyMsg.toString();
                    subject = subjectMsg.toString();
                } else if (waterConnectionDetails.getApplicationType().getCode().equals("ADDNLCONNECTION")) {
                    bodyMsg = new StringBuffer().append("Dear ").append(this.applicantName).append(",\n\nYour Additional water tap connection application is being rejected and the reason for rejection ").append(approvalComent).append("\n \n Please get in touch with ULB official to raise a new application with proper information to get a water connection.").append("\n\nThis is computer generated email and does not need any signature and also please  do not reply to this email.").append("\n\nThanks ,\n").append(this.waterTaxUtils.getCityName());
                    body = bodyMsg.toString();
                    StringBuffer subjectMsg = new StringBuffer().append("Water tap connection application").append(waterConnectionDetails.getApplicationNumber()).append("rejected.");
                    subject = subjectMsg.toString();
                } else if (waterConnectionDetails.getApplicationType().getCode().equals("CHANGEOFUSE")) {
                    bodyMsg = new StringBuffer().append("Dear ").append(this.applicantName).append(",\n\nYour Change Of use water tap connection application is being rejected and the reason for rejection ").append(approvalComent).append("\n \n Please get in touch with ULB official to raise a new application with proper information to get a water connection.").append("\n\nThis is computer generated email and does not need any signature and also please  do not reply to this email.").append("\n\nThanks ,\n").append(this.waterTaxUtils.getCityName());
                    body = bodyMsg.toString();
                    StringBuffer subjectMsg = new StringBuffer().append("Water tap connection application").append(waterConnectionDetails.getApplicationNumber()).append("rejected.");
                    subject = subjectMsg.toString();
                }
                this.waterTaxUtils.sendEmailOnWaterConnection(email, body, subject);
            }
        }
    }

    public String smsAndEmailBodyByCodeAndArgs(String code, WaterConnectionDetails waterConnectionDetails, String applicantName) {
        String smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), this.waterTaxUtils.getCityName()}, null);
        return smsMsg;
    }

    public String EmailBodyByCodeAndArgsWithType(String code, WaterConnectionDetails waterConnectionDetails, String applicantName, String type) {
        String emailBody = "";
        DecimalFormat amountFormat = new DecimalFormat("#.00");
        if (type.equalsIgnoreCase("newconncreate") || type.equalsIgnoreCase("additionalconncreate")) {
            emailBody = this.messageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), this.waterTaxUtils.getCityName()}, null);
        } else if (type.equalsIgnoreCase("newconnapprove") || type.equalsIgnoreCase("additionalconnapprove")) {
            emailBody = this.messageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), waterConnectionDetails.getConnection().getConsumerCode(), this.waterTaxUtils.getCityName()}, null);
        } else if (type.equalsIgnoreCase("newconnestnotice") || type.equalsIgnoreCase("addconnestnotice")) {
            emailBody = !"BPL".equalsIgnoreCase(waterConnectionDetails.getCategory().getName()) ? this.messageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), String.valueOf(amountFormat.format(waterConnectionDetails.getDonationCharges())), String.valueOf(amountFormat.format(waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges())), String.valueOf(amountFormat.format(waterConnectionDetails.getDonationCharges() + waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges())), this.waterTaxUtils.getCityName()}, null) : this.messageSource.getMessage(code, (Object[])new String[]{applicantName, "NEWCONNECTION".equalsIgnoreCase(waterConnectionDetails.getApplicationType().getCode()) ? "new water" : "additioanl water", waterConnectionDetails.getApplicationNumber(), String.valueOf(amountFormat.format(waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges())), this.waterTaxUtils.getCityName()}, null);
        } else if (type.equalsIgnoreCase("newconnexecutiondate") || type.equalsIgnoreCase("changeofuseexecution")) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            emailBody = !"Metered".toUpperCase().equalsIgnoreCase(waterConnectionDetails.getConnectionType().toString()) ? this.messageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getConnection().getConsumerCode(), formatter.format(waterConnectionDetails.getExecutionDate()).toString(), amountFormat.format(waterConnectionDetails.getDemand().getBaseDemand()).toString(), this.waterTaxUtils.getCityName()}, null) : this.messageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getConnection().getConsumerCode(), formatter.format(waterConnectionDetails.getExecutionDate()).toString(), this.waterTaxUtils.getCityName()}, null);
        } else if (type.equalsIgnoreCase("newconnfeepaid") || type.equalsIgnoreCase("addconnfeepaid") || type.equalsIgnoreCase("changeofusefeepaid")) {
            String amountToDisplay = String.valueOf(amountFormat.format(waterConnectionDetails.getDonationCharges() + waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges()));
            StringBuffer emailBodyBuilder = new StringBuffer().append("Dear ").append(applicantName).append(",").append("\n\nWe have received Estimation and donation amount of Rs.").append(amountToDisplay).append("/- against your water connection application number ").append(waterConnectionDetails.getApplicationNumber()).append(".We will be now processing your application to issue an work order.\n\nThis is computer generated email and does not need any signature and also please do not reply to this email.\n\nRegards,").append("\n").append(this.waterTaxUtils.getCityName());
            emailBody = emailBodyBuilder.toString();
        } else if ("changeofusecreate".equalsIgnoreCase(type)) {
            emailBody = this.messageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getConnection().getConsumerCode(), waterConnectionDetails.getApplicationNumber(), this.waterTaxUtils.getCityName()}, null);
        } else if ("changeofuseapprove".equalsIgnoreCase(type)) {
            emailBody = this.messageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), this.waterTaxUtils.getCityName()}, null);
        } else if ("changeofusenotice".equalsIgnoreCase(type)) {
            emailBody = !"BPL".equalsIgnoreCase(waterConnectionDetails.getCategory().getName()) ? this.messageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), String.valueOf(amountFormat.format(waterConnectionDetails.getDonationCharges())), String.valueOf(amountFormat.format(waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges())), String.valueOf(amountFormat.format(waterConnectionDetails.getDonationCharges() + waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges())), this.waterTaxUtils.getCityName()}, null) : this.messageSource.getMessage(code, (Object[])new String[]{applicantName, "change of", waterConnectionDetails.getApplicationNumber(), String.valueOf(amountFormat.format(waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges())), this.waterTaxUtils.getCityName()}, null);
        }
        return emailBody;
    }

    public String SmsBodyByCodeAndArgsWithType(String code, WaterConnectionDetails waterConnectionDetails, String applicantName, String type) {
        String smsMsg = "";
        DecimalFormat amountFormat = new DecimalFormat("#.00");
        if (type.equalsIgnoreCase("newconncreate") || type.equalsIgnoreCase("additionalconncreate")) {
            smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), this.waterTaxUtils.getCityName()}, null);
        } else if (type.equalsIgnoreCase("newconnapprove") || type.equalsIgnoreCase("additionalconnapprove")) {
            smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), waterConnectionDetails.getConnection().getConsumerCode(), this.waterTaxUtils.getCityName()}, null);
        } else if (type.equalsIgnoreCase("newconnestnotice") || type.equalsIgnoreCase("addconnestnotice")) {
            smsMsg = !"BPL".equalsIgnoreCase(waterConnectionDetails.getCategory().getName()) ? this.messageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), String.valueOf(amountFormat.format(waterConnectionDetails.getDonationCharges())), String.valueOf(amountFormat.format(waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges())), String.valueOf(amountFormat.format(waterConnectionDetails.getDonationCharges() + waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges())), this.waterTaxUtils.getCityName()}, null) : this.messageSource.getMessage(code, (Object[])new String[]{applicantName, "NEWCONNECTION".equalsIgnoreCase(waterConnectionDetails.getApplicationType().getCode()) ? "new water" : "additional water", waterConnectionDetails.getApplicationNumber(), String.valueOf(amountFormat.format(waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges())), this.waterTaxUtils.getCityName()}, null);
        } else if (type.equalsIgnoreCase("newconnexecutiondate") || type.equalsIgnoreCase("changeofuseexecution")) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            smsMsg = !"Metered".toUpperCase().equalsIgnoreCase(waterConnectionDetails.getConnectionType().toString()) ? this.messageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getConnection().getConsumerCode(), formatter.format(waterConnectionDetails.getExecutionDate()).toString(), amountFormat.format(waterConnectionDetails.getDemand().getBaseDemand()).toString(), this.waterTaxUtils.getCityName()}, null) : this.messageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getConnection().getConsumerCode(), formatter.format(waterConnectionDetails.getExecutionDate()).toString(), this.waterTaxUtils.getCityName()}, null);
        } else if (type.equalsIgnoreCase("newconnfeepaid") || type.equalsIgnoreCase("addconnfeepaid") || type.equalsIgnoreCase("changeofusefeepaid")) {
            String amountToDisplay = String.valueOf(amountFormat.format(waterConnectionDetails.getDonationCharges() + waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges()));
            StringBuffer smsBody = new StringBuffer().append("Dear ").append(applicantName).append(",We have received Estimation and donation amount of Rs.").append(amountToDisplay).append("/- against your water connection application number ").append(waterConnectionDetails.getApplicationNumber()).append(".We will be now processing your application to issue an work order.\nThanks,\n").append(this.waterTaxUtils.getCityName());
            smsMsg = smsBody.toString();
        } else if ("changeofusecreate".equalsIgnoreCase(type)) {
            smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getConnection().getConsumerCode(), waterConnectionDetails.getApplicationNumber(), this.waterTaxUtils.getCityName()}, null);
        } else if ("changeofuseapprove".equalsIgnoreCase(type)) {
            smsMsg = this.messageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), this.waterTaxUtils.getCityName()}, null);
        } else if ("changeofusenotice".equalsIgnoreCase(type)) {
            smsMsg = !"BPL".equalsIgnoreCase(waterConnectionDetails.getCategory().getName()) ? this.messageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), String.valueOf(amountFormat.format(waterConnectionDetails.getDonationCharges())), String.valueOf(amountFormat.format(waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges())), String.valueOf(amountFormat.format(waterConnectionDetails.getDonationCharges() + waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges())), this.waterTaxUtils.getCityName()}, null) : this.messageSource.getMessage(code, (Object[])new String[]{applicantName, "change of", waterConnectionDetails.getApplicationNumber(), String.valueOf(amountFormat.format(waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges())), this.waterTaxUtils.getCityName()}, null);
        }
        return smsMsg;
    }
}

