/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.validation.ValidationException;
import org.egov.commons.EgModules;
import org.egov.commons.Installment;
import org.egov.demand.model.EgDemand;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EisCommonService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.search.elastic.entity.ApplicationIndex;
import org.egov.infra.search.elastic.entity.ApplicationIndexBuilder;
import org.egov.infra.search.elastic.service.ApplicationIndexService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.ApplicationNumberGenerator;
import org.egov.infra.utils.EgovThreadLocals;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.workflow.WorkFlowMatrix;
import org.egov.pims.commons.Position;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.ApplicationDocuments;
import org.egov.wtms.application.entity.WaterConnection;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.repository.WaterConnectionDetailsRepository;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.WaterConnectionSmsAndEmailService;
import org.egov.wtms.application.workflow.ApplicationWorkflowCustomDefaultImpl;
import org.egov.wtms.elasticSearch.service.ConsumerIndexService;
import org.egov.wtms.masters.entity.ApplicationType;
import org.egov.wtms.masters.entity.DocumentNames;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.egov.wtms.masters.service.ApplicationProcessTimeService;
import org.egov.wtms.masters.service.ApplicationTypeService;
import org.egov.wtms.masters.service.DocumentNamesService;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.egov.wtms.utils.WaterTaxNumberGenerator;
import org.egov.wtms.utils.WaterTaxUtils;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class WaterConnectionDetailsService {
    protected WaterConnectionDetailsRepository waterConnectionDetailsRepository;
    private static final Logger LOG = LoggerFactory.getLogger(WaterConnectionDetailsService.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private UserService userService;
    @Autowired
    private ApplicationNumberGenerator applicationNumberGenerator;
    @Autowired
    private ApplicationTypeService applicationTypeService;
    @Autowired
    private SimpleWorkflowService<WaterConnectionDetails> waterConnectionWorkflowService;
    @Autowired
    private ApplicationProcessTimeService applicationProcessTimeService;
    @Autowired
    private ApplicationIndexService applicationIndexService;
    @Autowired
    private DocumentNamesService documentNamesService;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private WaterTaxNumberGenerator waterTaxNumberGenerator;
    @Autowired
    private ConsumerIndexService consumerIndexService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private ConnectionDemandService connectionDemandService;
    @Autowired
    private WaterConnectionSmsAndEmailService waterConnectionSmsAndEmailService;

    @Autowired
    public WaterConnectionDetailsService(WaterConnectionDetailsRepository waterConnectionDetailsRepository) {
        this.waterConnectionDetailsRepository = waterConnectionDetailsRepository;
    }

    public WaterConnectionDetails findBy(Long waterConnectionId) {
        return (WaterConnectionDetails)((Object)this.waterConnectionDetailsRepository.findOne(waterConnectionId));
    }

    public List<WaterConnectionDetails> findAll() {
        return this.waterConnectionDetailsRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"applicationNumber"}));
    }

    public WaterConnectionDetails findByApplicationNumber(String applicationNumber) {
        return this.waterConnectionDetailsRepository.findByApplicationNumber(applicationNumber);
    }

    public WaterConnectionDetails load(Long id) {
        return (WaterConnectionDetails)((Object)this.waterConnectionDetailsRepository.getOne(id));
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public Page<WaterConnectionDetails> getListWaterConnectionDetails(Integer pageNumber, Integer pageSize) {
        PageRequest pageable = new PageRequest(pageNumber - 1, pageSize.intValue(), Sort.Direction.ASC, new String[]{"applicationNumber"});
        return this.waterConnectionDetailsRepository.findAll((Pageable)pageable);
    }

    @Transactional
    public WaterConnectionDetails createNewWaterConnection(WaterConnectionDetails waterConnectionDetails, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        if (waterConnectionDetails.getApplicationNumber() == null) {
            waterConnectionDetails.setApplicationNumber(this.applicationNumberGenerator.generate());
        }
        waterConnectionDetails.setApplicationDate(new Date());
        Integer appProcessTime = this.applicationProcessTimeService.getApplicationProcessTime(waterConnectionDetails.getApplicationType(), waterConnectionDetails.getCategory());
        if (appProcessTime != null) {
            waterConnectionDetails.setDisposalDate(this.getDisposalDate(waterConnectionDetails, appProcessTime));
        }
        WaterConnectionDetails savedWaterConnectionDetails = (WaterConnectionDetails)((Object)this.waterConnectionDetailsRepository.save((Object)waterConnectionDetails));
        if (this.userService.getUserById(waterConnectionDetails.getCreatedBy().getId()).getUsername().equals("anonymous")) {
            EgovThreadLocals.setUserId((Long)Long.valueOf("40"));
            savedWaterConnectionDetails.setCreatedBy(this.userService.getUserById(EgovThreadLocals.getUserId()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" persisting WaterConnectionDetail object is completed and WorkFlow API Stared ");
        }
        ApplicationWorkflowCustomDefaultImpl applicationWorkflowCustomDefaultImpl = this.getInitialisedWorkFlowBean();
        if (LOG.isDebugEnabled()) {
            LOG.debug("applicationWorkflowCustomDefaultImpl initialization is done");
        }
        applicationWorkflowCustomDefaultImpl.createCommonWorkflowTransition(savedWaterConnectionDetails, approvalPosition, approvalComent, additionalRule, workFlowAction);
        this.updateIndexes(savedWaterConnectionDetails);
        this.waterConnectionSmsAndEmailService.sendSmsAndEmail(waterConnectionDetails, workFlowAction);
        if (LOG.isDebugEnabled()) {
            LOG.debug("updating water Connection Deatail is complted");
        }
        return savedWaterConnectionDetails;
    }

    @Transactional
    public WaterConnectionDetails createExisting(WaterConnectionDetails waterConnectionDetails) {
        waterConnectionDetails.getExistingConnection().setWaterConnectionDetails(waterConnectionDetails);
        waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("SANCTIONED", "WATERTAXAPPLICATION"));
        if (waterConnectionDetails.getApplicationType().getCode().equalsIgnoreCase("ADDNLCONNECTION")) {
            WaterConnectionDetails primaryConnectionDetails = this.getPrimaryConnectionDetailsByPropertyIdentifier(waterConnectionDetails.getConnection().getPropertyIdentifier());
            waterConnectionDetails.getConnection().setParentConnection(primaryConnectionDetails.getConnection());
        }
        WaterConnectionDetails savedWaterConnectionDetails = (WaterConnectionDetails)((Object)this.waterConnectionDetailsRepository.save((Object)waterConnectionDetails));
        this.updateConsmerIndex(savedWaterConnectionDetails);
        return savedWaterConnectionDetails;
    }

    public List<ConnectionType> getAllConnectionTypes() {
        return Arrays.asList(ConnectionType.values());
    }

    public Map<String, String> getConnectionTypesMap() {
        LinkedHashMap<String, String> connectionTypeMap = new LinkedHashMap<String, String>();
        connectionTypeMap.put(ConnectionType.METERED.toString(), "Metered");
        connectionTypeMap.put(ConnectionType.NON_METERED.toString(), "Non-metered");
        return connectionTypeMap;
    }

    public List<DocumentNames> getAllActiveDocumentNames(ApplicationType applicationType) {
        return this.documentNamesService.getAllActiveDocumentNamesByApplicationType(applicationType);
    }

    public WaterConnectionDetails findByApplicationNumberOrConsumerCodeAndStatus(String number, ConnectionStatus connectionStatus) {
        return this.waterConnectionDetailsRepository.findByApplicationNumberOrConnection_ConsumerCodeAndConnectionStatus(number, number, connectionStatus);
    }

    public WaterConnectionDetails findByApplicationNumberOrConsumerCode(String number) {
        return this.waterConnectionDetailsRepository.findByApplicationNumberOrConnection_ConsumerCode(number, number);
    }

    public WaterConnectionDetails findByConnection(WaterConnection waterConnection) {
        return this.waterConnectionDetailsRepository.findByConnection(waterConnection);
    }

    public WaterConnectionDetails findByConsumerCodeAndConnectionStatus(String comsumerCode, ConnectionStatus connectionStatus) {
        return this.waterConnectionDetailsRepository.findByConnection_ConsumerCodeAndConnectionStatus(comsumerCode, connectionStatus);
    }

    public WaterConnectionDetails getActiveConnectionDetailsByConnection(WaterConnection waterConnection) {
        return this.waterConnectionDetailsRepository.findByConnectionAndConnectionStatus(waterConnection, ConnectionStatus.ACTIVE);
    }

    public WaterConnectionDetails getPrimaryConnectionDetailsByPropertyIdentifier(String propertyIdentifier) {
        return this.waterConnectionDetailsRepository.getPrimaryConnectionDetailsByPropertyID(propertyIdentifier);
    }

    public List<WaterConnectionDetails> getAllConnectionDetailsByParentConnection(Long parentId) {
        return this.waterConnectionDetailsRepository.getAllConnectionDetailsByParentConnection(parentId);
    }

    public List<Hashtable<String, Object>> getHistory(WaterConnectionDetails waterConnectionDetails) {
        User user = null;
        ArrayList<Hashtable<String, Object>> historyTable = new ArrayList<Hashtable<String, Object>>();
        State state = waterConnectionDetails.getState();
        Hashtable<String, Object> map = new Hashtable<String, Object>(0);
        if (null != state) {
            map.put("date", state.getDateInfo());
            map.put("comments", state.getComments());
            map.put("updatedBy", state.getLastModifiedBy().getName());
            map.put("status", state.getValue());
            Position ownerPosition = state.getOwnerPosition();
            user = state.getOwnerUser();
            if (null != user) {
                map.put("user", user.getUsername());
                map.put("department", null != this.eisCommonService.getDepartmentForUser(user.getId()) ? this.eisCommonService.getDepartmentForUser(user.getId()).getName() : "");
            } else if (null != ownerPosition && null != ownerPosition.getDeptDesig()) {
                user = this.eisCommonService.getUserForPosition(ownerPosition.getId(), new Date());
                map.put("user", null != user.getUsername() ? user.getUsername() : "");
                map.put("department", null != ownerPosition.getDeptDesig().getDepartment() ? ownerPosition.getDeptDesig().getDepartment().getName() : "");
            }
            historyTable.add(map);
            if (!waterConnectionDetails.getStateHistory().isEmpty() && waterConnectionDetails.getStateHistory() != null) {
                Collections.reverse(waterConnectionDetails.getStateHistory());
            }
            for (StateHistory stateHistory : waterConnectionDetails.getStateHistory()) {
                Hashtable<String, Object> HistoryMap = new Hashtable<String, Object>(0);
                HistoryMap.put("date", stateHistory.getDateInfo());
                HistoryMap.put("comments", stateHistory.getComments());
                HistoryMap.put("updatedBy", stateHistory.getLastModifiedBy().getName());
                HistoryMap.put("status", stateHistory.getValue());
                Position owner = stateHistory.getOwnerPosition();
                user = stateHistory.getOwnerUser();
                if (null != user) {
                    HistoryMap.put("user", user.getUsername());
                    HistoryMap.put("department", null != this.eisCommonService.getDepartmentForUser(user.getId()) ? this.eisCommonService.getDepartmentForUser(user.getId()).getName() : "");
                } else if (null != owner && null != owner.getDeptDesig()) {
                    user = this.eisCommonService.getUserForPosition(owner.getId(), new Date());
                    HistoryMap.put("user", null != user.getUsername() ? user.getUsername() : "");
                    HistoryMap.put("department", null != owner.getDeptDesig().getDepartment() ? owner.getDeptDesig().getDepartment().getName() : "");
                }
                historyTable.add(HistoryMap);
            }
        }
        return historyTable;
    }

    @Transactional
    public WaterConnectionDetails updateWaterConnection(WaterConnectionDetails waterConnectionDetails, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, String mode) throws ValidationException {
        this.applicationStatusChange(waterConnectionDetails, workFlowAction, mode);
        if ("CLOSERAPPROVED".equals(waterConnectionDetails.getStatus().getCode()) && waterConnectionDetails.getCloseConnectionType() != null && workFlowAction.equals("Approve")) {
            waterConnectionDetails.setApplicationType(this.applicationTypeService.findByCode("CLOSINGCONNECTION"));
            waterConnectionDetails.setCloseApprovalDate(new Date());
        }
        if ("RECONNECTIONAPPROVED".equals(waterConnectionDetails.getStatus().getCode()) && waterConnectionDetails.getCloseConnectionType().equals("T") && waterConnectionDetails.getReConnectionReason() != null && workFlowAction.equals("Approve") && ConnectionType.NON_METERED.equals((Object)waterConnectionDetails.getConnectionType())) {
            waterConnectionDetails.setApplicationType(this.applicationTypeService.findByCode("RECONNECTION"));
            waterConnectionDetails.setConnectionStatus(ConnectionStatus.ACTIVE);
            waterConnectionDetails.setReconnectionApprovalDate(new Date());
            Installment nonMeterReconnInstallment = null;
            Boolean reconnInSameInstallment = null;
            if (this.checkTwoDatesAreInSameInstallment(waterConnectionDetails).booleanValue()) {
                Installment nonMeterCurrentInstallment = this.connectionDemandService.getCurrentInstallment("Property Tax", null, waterConnectionDetails.getReconnectionApprovalDate());
                Calendar cal = Calendar.getInstance();
                cal.setTime(nonMeterCurrentInstallment.getToDate());
                cal.add(5, 1);
                Date newDateForNextInstall = cal.getTime();
                nonMeterReconnInstallment = this.connectionDemandService.getCurrentInstallment("Property Tax", null, newDateForNextInstall);
                reconnInSameInstallment = Boolean.TRUE;
            } else {
                nonMeterReconnInstallment = this.connectionDemandService.getCurrentInstallment("Property Tax", null, waterConnectionDetails.getReconnectionApprovalDate());
                reconnInSameInstallment = Boolean.FALSE;
            }
            this.connectionDemandService.updateDemandForNonmeteredConnection(waterConnectionDetails, nonMeterReconnInstallment, reconnInSameInstallment);
            this.updateIndexes(waterConnectionDetails);
        }
        if (ConnectionType.NON_METERED.equals((Object)waterConnectionDetails.getConnectionType()) && "SANCTIONED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            this.connectionDemandService.updateDemandForNonmeteredConnection(waterConnectionDetails, null, null);
            this.updateIndexes(waterConnectionDetails);
        }
        WaterConnectionDetails updatedWaterConnectionDetails = (WaterConnectionDetails)((Object)this.waterConnectionDetailsRepository.save((Object)waterConnectionDetails));
        ApplicationWorkflowCustomDefaultImpl applicationWorkflowCustomDefaultImpl = this.getInitialisedWorkFlowBean();
        if (waterConnectionDetails.getCloseConnectionType() != null) {
            additionalRule = "CLOSECONNECTION";
        }
        if (waterConnectionDetails.getReConnectionReason() != null) {
            additionalRule = "RECONNECTION";
        }
        applicationWorkflowCustomDefaultImpl.createCommonWorkflowTransition(updatedWaterConnectionDetails, approvalPosition, approvalComent, additionalRule, workFlowAction);
        if (waterConnectionDetails.getCloseConnectionType() != null && waterConnectionDetails.getReConnectionReason() == null && waterConnectionDetails.getStatus().getCode().equals("CANCELLED") && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.INACTIVE)) {
            waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("SANCTIONED", "WATERTAXAPPLICATION"));
            waterConnectionDetails.setConnectionStatus(ConnectionStatus.ACTIVE);
            waterConnectionDetails.setCloseConnectionType(null);
            waterConnectionDetails.setCloseconnectionreason(null);
            waterConnectionDetails.setApplicationType(this.applicationTypeService.findByCode(waterConnectionDetails.getPreviousApplicationType()));
            this.updateIndexes(waterConnectionDetails);
            updatedWaterConnectionDetails = (WaterConnectionDetails)((Object)this.waterConnectionDetailsRepository.save((Object)waterConnectionDetails));
        }
        if (waterConnectionDetails.getReConnectionReason() != null && waterConnectionDetails.getCloseConnectionType() == "T" && waterConnectionDetails.getStatus().getCode().equals("CANCELLED") && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.INACTIVE)) {
            waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("CLOSERSANCTIONED", "WATERTAXAPPLICATION"));
            waterConnectionDetails.setConnectionStatus(ConnectionStatus.CLOSED);
            waterConnectionDetails.setReConnectionReason(null);
            waterConnectionDetails.setApplicationType(this.applicationTypeService.findByCode("CLOSINGCONNECTION"));
            this.updateIndexes(waterConnectionDetails);
            updatedWaterConnectionDetails = (WaterConnectionDetails)((Object)this.waterConnectionDetailsRepository.save((Object)waterConnectionDetails));
        }
        if (!workFlowAction.equalsIgnoreCase("Reject")) {
            this.waterConnectionSmsAndEmailService.sendSmsAndEmail(waterConnectionDetails, workFlowAction);
        }
        return updatedWaterConnectionDetails;
    }

    public ApplicationWorkflowCustomDefaultImpl getInitialisedWorkFlowBean() {
        ApplicationWorkflowCustomDefaultImpl applicationWorkflowCustomDefaultImpl = null;
        if (null != this.context) {
            applicationWorkflowCustomDefaultImpl = (ApplicationWorkflowCustomDefaultImpl)this.context.getBean("applicationWorkflowCustomDefaultImpl");
        }
        return applicationWorkflowCustomDefaultImpl;
    }

    public Boolean checkTwoDatesAreInSameInstallment(WaterConnectionDetails waterConnectionDetails) {
        Boolean DateInSameInstallment = Boolean.FALSE;
        Installment nonMeterClosedInstallment = this.connectionDemandService.getCurrentInstallment("Property Tax", null, waterConnectionDetails.getCloseApprovalDate());
        Installment nonMeterReconnInstallment = this.connectionDemandService.getCurrentInstallment("Property Tax", null, waterConnectionDetails.getReconnectionApprovalDate());
        if (nonMeterClosedInstallment.getInstallmentNumber().equals(nonMeterReconnInstallment.getInstallmentNumber())) {
            DateInSameInstallment = Boolean.TRUE;
        }
        return DateInSameInstallment;
    }

    public void applicationStatusChange(WaterConnectionDetails waterConnectionDetails, String workFlowAction, String mode) {
        if (null != waterConnectionDetails && null != waterConnectionDetails.getStatus() && null != waterConnectionDetails.getStatus().getCode()) {
            if (waterConnectionDetails.getStatus().getCode().equals("CREATED") && waterConnectionDetails.getState() != null && workFlowAction.equals("Submit")) {
                waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("VERIFIED", "WATERTAXAPPLICATION"));
                this.updateIndexes(waterConnectionDetails);
            } else if (waterConnectionDetails.getStatus().getCode().equals("VERIFIED")) {
                waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("ESTIMATIONNOTICEGENERATED", "WATERTAXAPPLICATION"));
                this.updateIndexes(waterConnectionDetails);
            } else if (waterConnectionDetails.getStatus().getCode().equals("ESTIMATIONNOTICEGENERATED")) {
                waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("ESTIMATIONAMOUNTPAID", "WATERTAXAPPLICATION"));
                this.updateIndexes(waterConnectionDetails);
            } else if (waterConnectionDetails.getStatus().getCode().equals("ESTIMATIONAMOUNTPAID") && workFlowAction.equalsIgnoreCase("Approve")) {
                if (waterConnectionDetails.getConnection().getConsumerCode() == null) {
                    waterConnectionDetails.getConnection().setConsumerCode(this.waterTaxNumberGenerator.generateConsumerNumber());
                }
                waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("APPROVED", "WATERTAXAPPLICATION"));
                this.updateIndexes(waterConnectionDetails);
            } else if (waterConnectionDetails.getStatus().getCode().equals("APPROVED")) {
                waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("WORKORDERGENERATED", "WATERTAXAPPLICATION"));
                this.updateIndexes(waterConnectionDetails);
            } else if ("WORKORDERGENERATED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
                waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("SANCTIONED", "WATERTAXAPPLICATION"));
                this.updateIndexes(waterConnectionDetails);
            } else if ("SANCTIONED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode()) && waterConnectionDetails.getCloseConnectionType() != null) {
                waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("CLOSERINITIATED", "WATERTAXAPPLICATION"));
                this.updateIndexes(waterConnectionDetails);
            } else if (!workFlowAction.equals("Reject")) {
                if (!mode.equals("closeredit") && "CLOSERINITIATED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode()) && waterConnectionDetails.getCloseConnectionType() != null) {
                    waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("CLOSERINPROGRESS", "WATERTAXAPPLICATION"));
                    this.updateIndexes(waterConnectionDetails);
                } else if (workFlowAction.equals("Approve") && "CLOSERINPROGRESS".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode()) && waterConnectionDetails.getCloseConnectionType() != null) {
                    waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("CLOSERAPPROVED", "WATERTAXAPPLICATION"));
                    this.updateIndexes(waterConnectionDetails);
                } else if ("CLOSERAPPROVED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode()) && waterConnectionDetails.getCloseConnectionType() != null) {
                    waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("CLOSERSANCTIONED", "WATERTAXAPPLICATION"));
                    this.updateIndexes(waterConnectionDetails);
                } else if ("CLOSERSANCTIONED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode()) && waterConnectionDetails.getCloseConnectionType().equals("T")) {
                    waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("RECONNECTIONINITIATED", "WATERTAXAPPLICATION"));
                    this.updateIndexes(waterConnectionDetails);
                } else if (!workFlowAction.equals("Reject") && !mode.equals("reconnectioneredit")) {
                    if ("RECONNECTIONINITIATED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode()) && waterConnectionDetails.getCloseConnectionType().equals("T")) {
                        waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("RECONNECTIONINPROGRESS", "WATERTAXAPPLICATION"));
                        this.updateIndexes(waterConnectionDetails);
                    } else if (workFlowAction.equals("Approve") && "RECONNECTIONINPROGRESS".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode()) && waterConnectionDetails.getCloseConnectionType().equals("T")) {
                        waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("RECONNECTIONAPPROVED", "WATERTAXAPPLICATION"));
                        this.updateIndexes(waterConnectionDetails);
                    } else if ("RECONNECTIONAPPROVED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode()) && waterConnectionDetails.getCloseConnectionType().equals("T")) {
                        waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("RECONNECTIONSANCTIONED", "WATERTAXAPPLICATION"));
                        this.updateIndexes(waterConnectionDetails);
                    }
                }
            }
        }
    }

    public Long getApprovalPositionByMatrixDesignation(WaterConnectionDetails waterConnectionDetails, Long approvalPosition, String additionalRule, String mode, String workFlowAction) {
        WorkFlowMatrix wfmatrix = this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, waterConnectionDetails.getCurrentState().getValue(), null);
        if (waterConnectionDetails.getStatus() != null && waterConnectionDetails.getStatus().getCode() != null) {
            Position posobj;
            if (waterConnectionDetails.getStatus().getCode().equals("CREATED") && waterConnectionDetails.getState() != null) {
                approvalPosition = mode.equals("edit") ? waterConnectionDetails.getState().getOwnerPosition().getId() : this.waterTaxUtils.getApproverPosition(wfmatrix.getNextDesignation(), waterConnectionDetails);
            } else if (waterConnectionDetails.getStatus().getCode().equals("APPROVED") || "ESTIMATIONNOTICEGENERATED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
                approvalPosition = this.waterTaxUtils.getApproverPosition(wfmatrix.getNextDesignation(), waterConnectionDetails);
            } else if (waterConnectionDetails.getStatus().getCode().equals("ESTIMATIONAMOUNTPAID") || waterConnectionDetails.getStatus().getCode().equals("CLOSERINPROGRESS") || waterConnectionDetails.getStatus().getCode().equals("CLOSERAPPROVED") || waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONAPPROVED") || workFlowAction.equals("Reject") && waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONINITIATED")) {
                approvalPosition = this.waterTaxUtils.getApproverPosition(wfmatrix.getNextDesignation(), waterConnectionDetails);
            } else if ((waterConnectionDetails.getStatus().getCode().equals("VERIFIED") || !workFlowAction.equals("Reject") && waterConnectionDetails.getStatus().getCode().equals("CLOSERINITIATED") || !waterConnectionDetails.getState().getValue().equals("Rejected") && !workFlowAction.equals("Reject") && (waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONINITIATED") || waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONINPROGRESS"))) && (posobj = this.waterTaxUtils.getCityLevelCommissionerPosition(wfmatrix.getNextDesignation())) != null) {
                approvalPosition = posobj.getId();
            }
        }
        return approvalPosition;
    }

    public void updateConsmerIndex(WaterConnectionDetails waterConnectionDetails) {
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS);
        BigDecimal amountTodisplayInIndex = this.getTotalAmount(waterConnectionDetails);
        if (waterConnectionDetails.getLegacy().booleanValue()) {
            this.consumerIndexService.createConsumerIndex(waterConnectionDetails, assessmentDetails, amountTodisplayInIndex);
        }
    }

    public void updateIndexes(WaterConnectionDetails waterConnectionDetails) {
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS);
        if (LOG.isDebugEnabled()) {
            LOG.debug(" updating Indexes Started... ");
        }
        BigDecimal amountTodisplayInIndex = BigDecimal.ZERO;
        if (waterConnectionDetails.getConnection().getConsumerCode() != null) {
            amountTodisplayInIndex = this.getTotalAmount(waterConnectionDetails);
        }
        if (waterConnectionDetails.getLegacy().booleanValue()) {
            this.consumerIndexService.createConsumerIndex(waterConnectionDetails, assessmentDetails, amountTodisplayInIndex);
            return;
        }
        Iterator ownerNameItr = assessmentDetails.getOwnerNames().iterator();
        StringBuilder consumerName = new StringBuilder();
        if (ownerNameItr.hasNext()) {
            consumerName.append(((OwnerName)ownerNameItr.next()).getOwnerName());
            while (ownerNameItr.hasNext()) {
                consumerName.append(", ".concat(((OwnerName)ownerNameItr.next()).getOwnerName()));
            }
        }
        if (waterConnectionDetails.getStatus() != null && !waterConnectionDetails.getStatus().getCode().equals("CREATED")) {
            if (waterConnectionDetails.getStatus() != null && (waterConnectionDetails.getStatus().getCode().equals("APPROVED") || waterConnectionDetails.getStatus().getCode().equals("VERIFIED") || waterConnectionDetails.getStatus().getCode().equals("ESTIMATIONNOTICEGENERATED") || waterConnectionDetails.getStatus().getCode().equals("ESTIMATIONAMOUNTPAID") || waterConnectionDetails.getStatus().getCode().equals("CANCELLED") || waterConnectionDetails.getStatus().getCode().equals("CLOSERINITIATED") || waterConnectionDetails.getStatus().getCode().equals("CLOSERINPROGRESS") || waterConnectionDetails.getStatus().getCode().equals("CLOSERAPPROVED") || waterConnectionDetails.getStatus().getCode().equals("CLOSERSANCTIONED") || waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONINITIATED") || waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONINPROGRESS") || waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONSANCTIONED") || waterConnectionDetails.getStatus().getCode().equals("WORKORDERGENERATED") || waterConnectionDetails.getStatus().getCode().equals("SANCTIONED") || waterConnectionDetails.getStatus().getCode().equals("CLOSERSANCTIONED"))) {
                ApplicationIndex applicationIndex = this.applicationIndexService.findByApplicationNumber(waterConnectionDetails.getApplicationNumber());
                applicationIndex.setStatus(waterConnectionDetails.getStatus().getDescription());
                applicationIndex.setApplicantAddress(assessmentDetails.getPropertyAddress());
                if (waterConnectionDetails.getConnection().getConsumerCode() != null) {
                    applicationIndex.setConsumerCode(waterConnectionDetails.getConnection().getConsumerCode());
                }
                this.applicationIndexService.updateApplicationIndex(applicationIndex);
            }
            if (waterConnectionDetails.getStatus().getCode().equals("SANCTIONED") && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.INPROGRESS) && !waterConnectionDetails.getApplicationType().getCode().equalsIgnoreCase("CHANGEOFUSE")) {
                waterConnectionDetails.setConnectionStatus(ConnectionStatus.ACTIVE);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(" updating Consumer Index Started... ");
                }
                if (!waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.INACTIVE) || !waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.INPROGRESS)) {
                    this.consumerIndexService.createConsumerIndex(waterConnectionDetails, assessmentDetails, amountTodisplayInIndex);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(" updating Consumer Index completed... ");
                }
            }
            if (waterConnectionDetails.getStatus().getCode().equals("SANCTIONED") && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE)) {
                this.consumerIndexService.createConsumerIndex(waterConnectionDetails, assessmentDetails, amountTodisplayInIndex);
            }
            if (waterConnectionDetails.getStatus().getCode().equals("CLOSERSANCTIONED") || waterConnectionDetails.getStatus().getCode().equals("CLOSERAPPROVED") && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.CLOSED)) {
                this.consumerIndexService.createConsumerIndex(waterConnectionDetails, assessmentDetails, amountTodisplayInIndex);
            }
            if (waterConnectionDetails.getCloseConnectionType() != null && waterConnectionDetails.getCloseConnectionType().equals("T") && (waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONAPPROVED") || waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONSANCTIONED"))) {
                waterConnectionDetails.setConnectionStatus(ConnectionStatus.ACTIVE);
                this.consumerIndexService.createConsumerIndex(waterConnectionDetails, assessmentDetails, amountTodisplayInIndex);
            }
        } else {
            String strQuery = "select md from EgModules md where md.name=:name";
            Query hql = this.getCurrentSession().createQuery("select md from EgModules md where md.name=:name");
            hql.setParameter("name", (Object)"Water Tax");
            if (LOG.isDebugEnabled()) {
                LOG.debug(" updating Application Index creation Started... ");
            }
            ApplicationIndexBuilder applicationIndexBuilder = new ApplicationIndexBuilder(((EgModules)hql.uniqueResult()).getName(), waterConnectionDetails.getApplicationNumber(), waterConnectionDetails.getApplicationDate(), waterConnectionDetails.getApplicationType().getName(), consumerName.toString(), waterConnectionDetails.getStatus().getDescription().toString(), "/wtms/application/view/" + waterConnectionDetails.getApplicationNumber(), assessmentDetails.getPropertyAddress());
            if (waterConnectionDetails.getDisposalDate() != null) {
                applicationIndexBuilder.disposalDate(waterConnectionDetails.getDisposalDate());
            }
            if ((ownerNameItr = assessmentDetails.getOwnerNames().iterator()) != null && ownerNameItr.hasNext()) {
                applicationIndexBuilder.mobileNumber(((OwnerName)ownerNameItr.next()).getMobileNumber());
            }
            ApplicationIndex applicationIndex = applicationIndexBuilder.build();
            this.applicationIndexService.createApplicationIndex(applicationIndex);
            if (LOG.isDebugEnabled()) {
                LOG.debug(" updating Application Index creation complted... ");
            }
        }
    }

    public Date getDisposalDate(WaterConnectionDetails waterConnectionDetails, Integer appProcessTime) {
        Calendar c = Calendar.getInstance();
        c.setTime(waterConnectionDetails.getApplicationDate());
        c.add(5, appProcessTime);
        return c.getTime();
    }

    public WaterConnectionDetails getParentConnectionDetails(String propertyIdentifier, ConnectionStatus connectionStatus) {
        return this.waterConnectionDetailsRepository.findByConnection_PropertyIdentifierAndConnectionStatusAndConnection_ParentConnectionIsNull(propertyIdentifier, connectionStatus);
    }

    public WaterConnectionDetails getParentConnectionDetailsForParentConnectionNotNull(String consumercode, ConnectionStatus connectionStatus) {
        return this.waterConnectionDetailsRepository.findByConnection_ConsumerCodeAndConnectionStatusAndAndConnection_ParentConnectionIsNotNull(consumercode, connectionStatus);
    }

    public WaterConnectionDetails getWaterConnectionDetailsByDemand(EgDemand demand) {
        return this.waterConnectionDetailsRepository.findByDemand(demand);
    }

    @Transactional
    public void save(WaterConnectionDetails detail) {
        this.waterConnectionDetailsRepository.save((Object)detail);
    }

    public WaterConnectionDetails getActiveNonHistoryConnectionDetailsByConnection(WaterConnection waterConnection) {
        return this.waterConnectionDetailsRepository.findByConnectionAndConnectionStatusAndIsHistory(waterConnection, ConnectionStatus.ACTIVE, Boolean.FALSE);
    }

    public BigDecimal getTotalAmount(WaterConnectionDetails waterConnectionDetails) {
        EgDemand currentDemand = waterConnectionDetails.getDemand();
        BigDecimal balance = BigDecimal.ZERO;
        if (currentDemand != null) {
            List<Object> instVsAmt = this.connectionDemandService.getDmdCollAmtInstallmentWise(currentDemand);
            for (Object object : instVsAmt) {
                Object[] ddObject = (Object[])object;
                BigDecimal dmdAmt = (BigDecimal)ddObject[2];
                BigDecimal collAmt = BigDecimal.ZERO;
                if (ddObject[2] != null) {
                    collAmt = new BigDecimal((Double)ddObject[3]);
                }
                balance = balance.add(dmdAmt.subtract(collAmt));
            }
        }
        return balance;
    }

    public List<ApplicationDocuments> getApplicationDocForExceptClosureAndReConnection(WaterConnectionDetails waterConnectionDetails) {
        ArrayList<ApplicationDocuments> tempDocList = new ArrayList<ApplicationDocuments>();
        if (waterConnectionDetails != null) {
            for (ApplicationDocuments appDoc : waterConnectionDetails.getApplicationDocs()) {
                if (appDoc.getDocumentNames() == null || !appDoc.getDocumentNames().getApplicationType().getCode().equals("NEWCONNECTION") && !appDoc.getDocumentNames().getApplicationType().getCode().equals("ADDNLCONNECTION") && !appDoc.getDocumentNames().getApplicationType().getCode().equals("CHANGEOFUSE")) continue;
                tempDocList.add(appDoc);
            }
        }
        return tempDocList;
    }
}

