/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.validation.ValidationException;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.demand.dao.DemandGenericDao;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgBillType;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.EgovThreadLocals;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.DemandDetail;
import org.egov.wtms.application.entity.FieldInspectionDetails;
import org.egov.wtms.application.entity.WaterConnection;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.repository.WaterConnectionDetailsRepository;
import org.egov.wtms.application.rest.WaterTaxDue;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.WaterConnectionService;
import org.egov.wtms.application.service.collection.ConnectionBillService;
import org.egov.wtms.application.service.collection.WaterConnectionBillable;
import org.egov.wtms.masters.entity.DonationDetails;
import org.egov.wtms.masters.entity.WaterRatesDetails;
import org.egov.wtms.masters.entity.WaterRatesHeader;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.egov.wtms.masters.service.DonationDetailsService;
import org.egov.wtms.masters.service.DonationHeaderService;
import org.egov.wtms.masters.service.WaterRatesDetailsService;
import org.egov.wtms.masters.service.WaterRatesHeaderService;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.egov.wtms.utils.WaterTaxNumberGenerator;
import org.egov.wtms.utils.WaterTaxUtils;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ConnectionDemandService {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private DonationDetailsService donationDetailsService;
    @Autowired
    private DonationHeaderService donationHeaderService;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private DemandGenericDao demandGenericDao;
    @Autowired
    WaterConnectionService waterConnectionService;
    @Autowired
    WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    private ConnectionBillService connectionBillService;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private WaterConnectionDetailsRepository waterConnectionDetailsRepository;
    @Autowired
    private WaterRatesDetailsService waterRatesDetailsService;
    @Autowired
    private WaterRatesHeaderService waterRatesHeaderService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private WaterTaxNumberGenerator waterTaxNumberGenerator;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public EgDemand createDemand(WaterConnectionDetails waterConnectionDetails) {
        HashMap<String, Double> feeDetails = new HashMap<String, Double>();
        DonationDetails donationDetails = null;
        FieldInspectionDetails fieldInspectionDetails = waterConnectionDetails.getFieldInspectionDetails();
        if (null != fieldInspectionDetails) {
            feeDetails.put("WTAXFIELDINSPEC", fieldInspectionDetails.getEstimationCharges());
        }
        if (!("BPL".equalsIgnoreCase(waterConnectionDetails.getCategory().getCode()) || "CHANGEOFUSE".equalsIgnoreCase(waterConnectionDetails.getApplicationType().getCode()) && ("RESIDENTIAL".equalsIgnoreCase(waterConnectionDetails.getPropertyType().getCode()) || ConnectionType.NON_METERED.equals((Object)waterConnectionDetails.getConnectionType())))) {
            donationDetails = this.donationDetailsService.findByDonationHeader(this.donationHeaderService.findByCategoryandUsageandMinPipeSize(waterConnectionDetails.getCategory(), waterConnectionDetails.getUsageType(), waterConnectionDetails.getPipeSize().getSizeInInch()));
        }
        if (donationDetails != null) {
            feeDetails.put("WTAXDONATION", donationDetails.getAmount());
            waterConnectionDetails.setDonationCharges(donationDetails.getAmount());
        }
        Installment installment = this.installmentDao.getInsatllmentByModuleForGivenDateAndInstallmentType(this.moduleService.getModuleByName("Water Tax Management"), new Date(), "Yearly");
        HashSet<EgDemandDetails> dmdDetailSet = new HashSet<EgDemandDetails>();
        for (String demandReason : feeDetails.keySet()) {
            dmdDetailSet.add(this.createDemandDetails((Double)feeDetails.get(demandReason), demandReason, installment));
        }
        EgDemand egDemand = new EgDemand();
        egDemand.setEgInstallmentMaster(installment);
        egDemand.getEgDemandDetails().addAll(dmdDetailSet);
        egDemand.setIsHistory("N");
        egDemand.setCreateDate(new Date());
        egDemand.setModifiedDate(new Date());
        return egDemand;
    }

    private EgDemandDetails createDemandDetails(Double amount, String demandReason, Installment installment) {
        EgDemandReason demandReasonObj = this.getDemandReasonByCodeAndInstallment(demandReason, installment);
        EgDemandDetails demandDetail = new EgDemandDetails();
        demandDetail.setAmount(BigDecimal.valueOf(amount));
        demandDetail.setAmtCollected(BigDecimal.ZERO);
        demandDetail.setAmtRebate(BigDecimal.ZERO);
        demandDetail.setEgDemandReason(demandReasonObj);
        demandDetail.setCreateDate(new Date());
        demandDetail.setModifiedDate(new Date());
        return demandDetail;
    }

    private EgDemandDetails createDemandDetailsrForDataEntry(BigDecimal amount, BigDecimal collectAmount, String demandReason, String installment, DemandDetail demandTempObj, WaterConnectionDetails waterConnectionDetails) {
        Installment installObj = this.waterConnectionDetailsRepository.findInstallmentByDescription("Property Tax", installment);
        EgDemandDetails demandDetailBean = null;
        EgDemandDetails demandDetailsObj = this.waterConnectionDetailsRepository.findEgDemandDetailById(demandTempObj.getId());
        EgDemandReason demandReasonObj = this.getDemandReasonByCodeAndInstallment(demandReason, installObj);
        if (demandDetailsObj != null && demandTempObj.getId() != null) {
            demandDetailBean = demandDetailsObj;
            if (demandDetailsObj.getAmount().compareTo(amount) != 0) {
                demandDetailBean.setAmount(amount);
            }
            if (demandDetailsObj.getAmtCollected().compareTo(collectAmount) != 0) {
                demandDetailBean.setAmtCollected(collectAmount);
            }
            demandDetailBean.setEgDemandReason(demandReasonObj);
            demandDetailBean.setModifiedDate(new Date());
        } else {
            demandDetailBean = new EgDemandDetails();
            demandDetailBean.setAmount(amount);
            demandDetailBean.setAmtCollected(collectAmount);
            demandDetailBean.setAmtRebate(BigDecimal.ZERO);
            demandDetailBean.setEgDemandReason(demandReasonObj);
            demandDetailBean.setCreateDate(new Date());
            demandDetailBean.setModifiedDate(new Date());
        }
        return demandDetailBean;
    }

    public EgDemandReason getDemandReasonByCodeAndInstallment(String demandReason, Installment installment) {
        Query demandQuery = this.getCurrentSession().getNamedQuery("DEMANDREASONBY_CODE_AND_INSTALLMENTID");
        demandQuery.setParameter(0, (Object)demandReason);
        demandQuery.setParameter(1, (Object)installment.getId());
        EgDemandReason demandReasonObj = (EgDemandReason)demandQuery.uniqueResult();
        return demandReasonObj;
    }

    public HashMap<String, Double> getSplitFee(WaterConnectionDetails waterConnectionDetails) {
        EgDemand demand = waterConnectionDetails.getDemand();
        HashMap<String, Double> splitAmount = new HashMap<String, Double>();
        if (demand != null && demand.getEgDemandDetails() != null && demand.getEgDemandDetails().size() > 0) {
            for (EgDemandDetails detail : demand.getEgDemandDetails()) {
                if ("WTAXFIELDINSPEC".equals(detail.getEgDemandReason().getEgDemandReasonMaster().getCode())) {
                    splitAmount.put("WTAXFIELDINSPEC", detail.getAmount().doubleValue());
                    continue;
                }
                if (!"WTAXDONATION".equals(detail.getEgDemandReason().getEgDemandReasonMaster().getCode())) continue;
                splitAmount.put("WTAXDONATION", detail.getAmount().doubleValue());
            }
        }
        return splitAmount;
    }

    public WaterTaxDue getDueDetailsByConsumerCode(String consumerCode) {
        WaterTaxDue waterTaxDue = new WaterTaxDue();
        ArrayList<String> consumerCodes = new ArrayList<String>();
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCode(consumerCode);
        if (null != waterConnectionDetails) {
            this.getDueInfo(waterConnectionDetails);
            consumerCodes.add(waterConnectionDetails.getConnection().getConsumerCode());
            waterTaxDue.setConsumerCode(consumerCodes);
            waterTaxDue.setPropertyID(waterConnectionDetails.getConnection().getPropertyIdentifier());
            waterTaxDue.setConnectionCount(consumerCodes.size());
            waterTaxDue.setIsSuccess(true);
        } else {
            waterTaxDue.setIsSuccess(false);
            waterTaxDue.setConsumerCode(Collections.EMPTY_LIST);
            waterTaxDue.setConnectionCount(0);
            waterTaxDue.setErrorCode("WTAX100");
            waterTaxDue.setErrorMessage("Water Connection details with Consumer code " + consumerCode + " does not exist");
        }
        return waterTaxDue;
    }

    public WaterTaxDue getDueDetailsByPropertyId(String propertyIdentifier) {
        BigDecimal arrDmd = new BigDecimal(0);
        BigDecimal arrColl = new BigDecimal(0);
        BigDecimal currDmd = new BigDecimal(0);
        BigDecimal currColl = new BigDecimal(0);
        BigDecimal totalDue = new BigDecimal(0);
        WaterTaxDue waterTaxDue = null;
        List<WaterConnection> waterConnections = this.waterConnectionService.findByPropertyIdentifier(propertyIdentifier);
        if (waterConnections.isEmpty()) {
            waterTaxDue = new WaterTaxDue();
            waterTaxDue.setConsumerCode(Collections.EMPTY_LIST);
            waterTaxDue.setConnectionCount(0);
            waterTaxDue.setIsSuccess(false);
            waterTaxDue.setErrorCode("WTAX101");
            waterTaxDue.setErrorMessage("Water Connection details with Assessment Number " + propertyIdentifier + " does not exist");
        } else {
            waterTaxDue = new WaterTaxDue();
            ArrayList<String> consumerCodes = new ArrayList<String>();
            for (WaterConnection connection : waterConnections) {
                if (connection.getConsumerCode() == null) continue;
                WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByConnection(connection);
                waterTaxDue = this.getDueInfo(waterConnectionDetails);
                waterTaxDue.setPropertyID(propertyIdentifier);
                consumerCodes.add(connection.getConsumerCode());
                arrDmd = arrDmd.add(waterTaxDue.getArrearDemand());
                arrColl = arrColl.add(waterTaxDue.getArrearCollection());
                currDmd = currDmd.add(waterTaxDue.getCurrentDemand());
                currColl = currColl.add(waterTaxDue.getCurrentCollection());
                totalDue = totalDue.add(waterTaxDue.getTotalTaxDue());
            }
            waterTaxDue.setArrearDemand(arrDmd);
            waterTaxDue.setArrearCollection(arrColl);
            waterTaxDue.setCurrentDemand(currDmd);
            waterTaxDue.setCurrentCollection(currColl);
            waterTaxDue.setTotalTaxDue(totalDue);
            waterTaxDue.setConsumerCode(consumerCodes);
            waterTaxDue.setConnectionCount(waterConnections.size());
            waterTaxDue.setIsSuccess(true);
        }
        return waterTaxDue;
    }

    private WaterTaxDue getDueInfo(WaterConnectionDetails waterConnectionDetails) {
        Map<String, BigDecimal> resultmap = this.getDemandCollMap(waterConnectionDetails);
        WaterTaxDue waterTaxDue = new WaterTaxDue();
        if (null != resultmap && !resultmap.isEmpty()) {
            BigDecimal currDmd = resultmap.get("CURR_DMD");
            waterTaxDue.setCurrentDemand(currDmd);
            BigDecimal arrDmd = resultmap.get("ARR_DMD");
            waterTaxDue.setArrearDemand(arrDmd);
            BigDecimal currCollection = resultmap.get("CURR_COLL");
            waterTaxDue.setCurrentCollection(currCollection);
            BigDecimal arrCollection = resultmap.get("ARR_COLL");
            waterTaxDue.setArrearCollection(arrCollection);
            BigDecimal taxDue = currDmd.add(arrDmd).subtract(currCollection).subtract(arrCollection);
            waterTaxDue.setTotalTaxDue(taxDue);
        }
        return waterTaxDue;
    }

    public Map<String, BigDecimal> getDemandCollMap(WaterConnectionDetails waterConnectionDetails) {
        EgDemand currDemand = waterConnectionDetails.getDemand();
        Installment installment = null;
        List<Object> dmdCollList = new ArrayList();
        Installment currInst = null;
        Integer instId = null;
        BigDecimal currDmd = BigDecimal.ZERO;
        BigDecimal arrDmd = BigDecimal.ZERO;
        BigDecimal currCollection = BigDecimal.ZERO;
        BigDecimal arrColelection = BigDecimal.ZERO;
        HashMap<String, BigDecimal> retMap = new HashMap<String, BigDecimal>();
        if (currDemand != null) {
            dmdCollList = this.getDmdCollAmtInstallmentWise(currDemand);
        }
        currInst = this.installmentDao.getInsatllmentByModuleForGivenDateAndInstallmentType(this.moduleService.getModuleByName("Water Tax Management"), new Date(), "Yearly");
        for (Object object : dmdCollList) {
            Object[] listObj = (Object[])object;
            instId = Integer.valueOf(listObj[1].toString());
            installment = (Installment)this.installmentDao.findById((Serializable)instId, false);
            if (currInst.equals((Object)installment)) {
                if (listObj[3] != null && !listObj[3].equals(BigDecimal.ZERO)) {
                    currCollection = currCollection.add(new BigDecimal((Double)listObj[3]));
                }
                currDmd = currDmd.add((BigDecimal)listObj[2]);
                continue;
            }
            arrDmd = arrDmd.add((BigDecimal)listObj[2]);
            if (listObj[3] == null || listObj[3].equals(BigDecimal.ZERO)) continue;
            arrColelection = arrColelection.add((BigDecimal)listObj[2]);
        }
        retMap.put("CURR_DMD", currDmd);
        retMap.put("ARR_DMD", arrDmd);
        retMap.put("CURR_COLL", currCollection);
        retMap.put("ARR_COLL", arrColelection);
        return retMap;
    }

    public List<Object> getDmdCollAmtInstallmentWise(EgDemand egDemand) {
        StringBuffer strBuf = new StringBuffer(2000);
        strBuf.append("select dmdRes.id,dmdRes.id_installment, sum(dmdDet.amount) as amount, sum(dmdDet.amt_collected) as amt_collected, sum(dmdDet.amt_rebate) as amt_rebate, inst.start_date from eg_demand_details dmdDet,eg_demand_reason dmdRes, eg_installment_master inst,eg_demand_reason_master dmdresmas where dmdDet.id_demand_reason=dmdRes.id and dmdDet.id_demand =:dmdId and dmdRes.id_installment = inst.id and dmdresmas.id = dmdres.id_demand_reason_master group by dmdRes.id,dmdRes.id_installment, inst.start_date order by inst.start_date ");
        return this.getCurrentSession().createSQLQuery(strBuf.toString()).setLong("dmdId", egDemand.getId().longValue()).list();
    }

    public String generateBill(String consumerCode, String applicationTypeCode) {
        String collectXML = "";
        SimpleDateFormat formatYear = new SimpleDateFormat("yyyy");
        String currentInstallmentYear = null;
        WaterConnectionBillable waterConnectionBillable = (WaterConnectionBillable)((Object)this.context.getBean("waterConnectionBillable"));
        WaterConnectionDetails waterConnectionDetails = applicationTypeCode.equals("CHANGEOFUSE") ? this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCodeAndStatus(consumerCode, ConnectionStatus.ACTIVE) : this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCode(consumerCode);
        if (ConnectionStatus.INPROGRESS.equals((Object)waterConnectionDetails.getConnectionStatus())) {
            currentInstallmentYear = formatYear.format(this.getCurrentInstallment("Water Tax Management", "Yearly", new Date()).getInstallmentYear());
        } else if (ConnectionStatus.ACTIVE.equals((Object)waterConnectionDetails.getConnectionStatus()) && ConnectionType.NON_METERED.equals((Object)waterConnectionDetails.getConnectionType())) {
            currentInstallmentYear = formatYear.format(this.getCurrentInstallment("Property Tax", null, new Date()).getInstallmentYear());
        } else if (ConnectionStatus.ACTIVE.equals((Object)waterConnectionDetails.getConnectionStatus()) && ConnectionType.METERED.equals((Object)waterConnectionDetails.getConnectionType())) {
            currentInstallmentYear = formatYear.format(this.getCurrentInstallment("Water Tax Management", "Monthly", new Date()).getInstallmentYear());
        }
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS);
        waterConnectionBillable.setWaterConnectionDetails(waterConnectionDetails);
        waterConnectionBillable.setAssessmentDetails(assessmentDetails);
        waterConnectionBillable.setUserId(EgovThreadLocals.getUserId());
        waterConnectionBillable.setReferenceNumber(this.waterTaxNumberGenerator.generateBillNumber(currentInstallmentYear));
        waterConnectionBillable.setBillType(this.getBillTypeByCode("AUTO"));
        String billXml = this.connectionBillService.getBillXML(waterConnectionBillable);
        collectXML = URLEncoder.encode(billXml);
        return collectXML;
    }

    public EgBillType getBillTypeByCode(String typeCode) {
        EgBillType billType = this.egBillDAO.getBillTypeByCode(typeCode);
        return billType;
    }

    public EgDemand getDemandByInstAndApplicationNumber(Installment installment, String consumerCode) {
        return this.waterConnectionDetailsRepository.findByApplicationNumberAndInstallment(installment, consumerCode).getDemand();
    }

    @Transactional
    public WaterConnectionDetails updateDemandForMeteredConnection(WaterConnectionDetails waterConnectionDetails, BigDecimal billAmount, Date currentDate) {
        Installment installment = this.getCurrentInstallment("Water Tax Management", "Monthly", currentDate);
        EgDemand demandObj = waterConnectionDetails.getDemand();
        HashSet<EgDemandDetails> dmdDetailSet = new HashSet<EgDemandDetails>();
        dmdDetailSet.add(this.createDemandDetails(Double.parseDouble(billAmount.toString()), "WTAXCHARGES", installment));
        demandObj.setBaseDemand(demandObj.getBaseDemand().add(billAmount));
        demandObj.setEgInstallmentMaster(installment);
        demandObj.getEgDemandDetails().addAll(dmdDetailSet);
        demandObj.setModifiedDate(new Date());
        waterConnectionDetails.setDemand(demandObj);
        List billlist = this.demandGenericDao.getAllBillsForDemand(demandObj, "N", "N");
        if (!billlist.isEmpty()) {
            EgBill billObj = (EgBill)billlist.get(0);
            billObj.setIs_History("Y");
            billObj.setModifiedDate(new Date());
            this.egBillDAO.create(billObj);
        }
        this.generateBillForMeterAndMonthly(waterConnectionDetails.getConnection().getConsumerCode());
        return waterConnectionDetails;
    }

    @Transactional
    public WaterConnectionDetails updateDemandForNonMeteredConnectionDataEntry(WaterConnectionDetails waterConnectionDetails) {
        EgDemand demandObj = null;
        demandObj = waterConnectionDetails.getDemand() == null ? new EgDemand() : waterConnectionDetails.getDemand();
        HashSet<EgDemandDetails> dmdDetailSet = new HashSet<EgDemandDetails>();
        for (DemandDetail demanddetailBean : waterConnectionDetails.getDemandDetailBeanList()) {
            if (demanddetailBean.getActualAmount().equals(BigDecimal.ZERO) || demanddetailBean.getActualCollection().compareTo(demanddetailBean.getActualAmount()) == 1) continue;
            demandObj.setBaseDemand(this.getTotalAmountForBaseDemand(demanddetailBean, demandObj.getBaseDemand()));
            demandObj.setAmtCollected(this.getTotalCollectedAmountForDemand(demanddetailBean, demandObj.getAmtCollected()));
            dmdDetailSet.add(this.createDemandDetailsrForDataEntry(demanddetailBean.getActualAmount(), demanddetailBean.getActualCollection(), demanddetailBean.getReasonMaster(), demanddetailBean.getInstallment(), demanddetailBean, waterConnectionDetails));
        }
        demandObj.getEgDemandDetails().addAll(dmdDetailSet);
        int listlength = waterConnectionDetails.getDemand().getEgDemandDetails().size() - 1;
        Installment installObj = this.waterConnectionDetailsRepository.findInstallmentByDescription("Property Tax", waterConnectionDetails.getDemandDetailBeanList().get(listlength).getInstallment());
        demandObj.setEgInstallmentMaster(installObj);
        demandObj.setModifiedDate(new Date());
        if (demandObj.getIsHistory() == null) {
            demandObj.setIsHistory("N");
        }
        if (demandObj.getCreateDate() == null) {
            demandObj.setCreateDate(new Date());
        }
        waterConnectionDetails.setDemand(demandObj);
        return waterConnectionDetails;
    }

    public BigDecimal getTotalAmountForBaseDemand(DemandDetail demanddetailBean, BigDecimal baseDemandAmount) {
        BigDecimal currentTotalAmount = BigDecimal.ZERO;
        EgDemandDetails demandDetailsObj = this.waterConnectionDetailsRepository.findEgDemandDetailById(demanddetailBean.getId());
        if (demanddetailBean.getId() == null) {
            currentTotalAmount = baseDemandAmount.add(demanddetailBean.getActualAmount());
        } else if (demanddetailBean.getActualAmount().compareTo(demandDetailsObj.getAmount()) == -1) {
            BigDecimal diffExtraless = demandDetailsObj.getAmount().subtract(demanddetailBean.getActualAmount());
            currentTotalAmount = baseDemandAmount.subtract(diffExtraless);
        } else if (demanddetailBean.getActualAmount().compareTo(demandDetailsObj.getAmount()) == 1) {
            BigDecimal diffExtra = demanddetailBean.getActualAmount().subtract(demandDetailsObj.getAmount());
            currentTotalAmount = baseDemandAmount.add(diffExtra);
        } else if (demanddetailBean.getActualAmount().compareTo(demandDetailsObj.getAmount()) == 0) {
            currentTotalAmount = baseDemandAmount;
        }
        return currentTotalAmount;
    }

    public BigDecimal getTotalCollectedAmountForDemand(DemandDetail demanddetailBean, BigDecimal demandAmountCollected) {
        BigDecimal currentTotalAmount = BigDecimal.ZERO;
        EgDemandDetails demandDetailsObj = this.waterConnectionDetailsRepository.findEgDemandDetailById(demanddetailBean.getId());
        if (demanddetailBean.getId() == null) {
            currentTotalAmount = demandAmountCollected.add(demanddetailBean.getActualCollection());
        } else if (demanddetailBean.getActualCollection().compareTo(demandDetailsObj.getAmtCollected()) == -1) {
            BigDecimal diffExtraless = demandDetailsObj.getAmtCollected().subtract(demanddetailBean.getActualCollection());
            currentTotalAmount = demandAmountCollected.subtract(diffExtraless);
        } else if (demanddetailBean.getActualCollection().compareTo(demandDetailsObj.getAmtCollected()) == 1) {
            BigDecimal diffExtra = demanddetailBean.getActualCollection().subtract(demandDetailsObj.getAmtCollected());
            currentTotalAmount = demandAmountCollected.add(diffExtra);
        } else if (demanddetailBean.getActualCollection().compareTo(demandDetailsObj.getAmtCollected()) == 0) {
            currentTotalAmount = demandAmountCollected;
        }
        return currentTotalAmount;
    }

    @Transactional
    public String generateBillForMeterAndMonthly(String consumerCode) {
        WaterConnectionBillable waterConnectionBillable = (WaterConnectionBillable)((Object)this.context.getBean("waterConnectionBillable"));
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(consumerCode, ConnectionStatus.ACTIVE);
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS);
        waterConnectionBillable.setWaterConnectionDetails(waterConnectionDetails);
        waterConnectionBillable.setAssessmentDetails(assessmentDetails);
        waterConnectionBillable.setUserId(EgovThreadLocals.getUserId());
        waterConnectionBillable.setReferenceNumber(this.waterTaxNumberGenerator.generateMeterDemandNoticeNumber());
        waterConnectionBillable.setBillType(this.getBillTypeByCode("MANUAL"));
        String billObj = this.connectionBillService.getBillXML(waterConnectionBillable);
        return billObj;
    }

    public WaterConnectionDetails updateDemandForNonmeteredConnection(WaterConnectionDetails waterConnectionDetails, Installment installment, Boolean reconnInSameInstallment) throws ValidationException {
        Date InstallemntStartDate = null;
        if (installment == null) {
            installment = this.getCurrentInstallment("Property Tax", null, new Date());
            InstallemntStartDate = new Date();
        } else {
            InstallemntStartDate = reconnInSameInstallment != false ? installment.getFromDate() : waterConnectionDetails.getReconnectionApprovalDate();
        }
        double totalWaterRate = 0.0;
        WaterRatesHeader waterRatesHeader = this.waterRatesHeaderService.findByConnectionTypeAndUsageTypeAndWaterSourceAndPipeSize(waterConnectionDetails.getConnectionType(), waterConnectionDetails.getUsageType(), waterConnectionDetails.getWaterSource(), waterConnectionDetails.getPipeSize());
        WaterRatesDetails waterRatesDetails = this.waterRatesDetailsService.findByWaterRatesHeader(waterRatesHeader);
        int noofmonths = DateUtils.noOfMonths((Date)InstallemntStartDate, (Date)installment.getToDate());
        if (null == waterRatesDetails) {
            throw new ValidationException("err.water.rate.not.found");
        }
        totalWaterRate = noofmonths > 0 ? waterRatesDetails.getMonthlyRate() * (double)(noofmonths + 1) : waterRatesDetails.getMonthlyRate();
        EgDemand demand = waterConnectionDetails.getDemand();
        EgDemandDetails demandDetails = this.createDemandDetails(totalWaterRate, "WTAXCHARGES", installment);
        demand.setBaseDemand(BigDecimal.valueOf(totalWaterRate));
        demand.setEgInstallmentMaster(installment);
        demand.getEgDemandDetails().add(demandDetails);
        demand.setModifiedDate(new Date());
        waterConnectionDetails.setDemand(demand);
        return waterConnectionDetails;
    }

    public Map<String, BigDecimal> getDemandCollMapForPtisIntegration(WaterConnectionDetails waterConnectionDetails, String moduleName, String installmentType) {
        EgDemand currDemand = waterConnectionDetails.getDemand();
        Installment installment = null;
        List<Object> dmdCollList = new ArrayList();
        Installment currInst = null;
        Integer instId = null;
        BigDecimal curDue = BigDecimal.ZERO;
        BigDecimal arrDue = BigDecimal.ZERO;
        BigDecimal arrearInstallmentfrom = BigDecimal.ZERO;
        HashMap<String, BigDecimal> retMap = new HashMap<String, BigDecimal>();
        if (currDemand != null) {
            dmdCollList = this.getDmdCollAmtInstallmentWiseWithIsDmdTrue(currDemand);
        }
        currInst = this.getCurrentInstallment(moduleName, null, new Date());
        for (Object object : dmdCollList) {
            Object[] listObj = (Object[])object;
            instId = Integer.valueOf(listObj[2].toString());
            installment = (Installment)this.installmentDao.findById((Serializable)instId, false);
            if (currInst.equals((Object)installment)) {
                curDue = new BigDecimal(listObj[6].toString());
                continue;
            }
            arrDue = (BigDecimal)listObj[6];
            if (arrDue.signum() <= 0 || null != arrearInstallmentfrom) continue;
            arrearInstallmentfrom = BigDecimal.valueOf(instId.intValue());
        }
        retMap.put("ArrearDue", arrDue);
        retMap.put("CurrentDue", curDue);
        retMap.put("ARR_INSTALL_FROM", arrearInstallmentfrom);
        return retMap;
    }

    public List<Object> getDmdCollAmtInstallmentWiseWithIsDmdTrue(EgDemand egDemand) {
        StringBuffer strBuf = new StringBuffer(2000);
        strBuf.append("SELECT wcdid,dmdResId,installment,amount,amt_collected,amt_rebate,amount-amt_collected AS balance,instStartDate FROM (SELECT wcd.id AS wcdid,dmdRes.id AS dmdResId,dmdRes.id_installment AS installment,SUM(dmdDet.amount) AS amount,SUM(dmdDet.amt_collected) AS amt_collected,SUM(dmdDet.amt_rebate) AS amt_rebate,inst.start_date AS inststartdate FROM eg_demand_details dmdDet,eg_demand_reason dmdRes,eg_installment_master inst,eg_demand_reason_master dmdresmas,egwtr_connectiondetails wcd WHERE dmdDet.id_demand_reason=dmdRes.id AND dmdDet.id_demand =:dmdId AND dmdRes.id_installment = inst.id AND dmdresmas.id = dmdres.id_demand_reason_master AND dmdresmas.isdemand=TRUE AND wcd.demand = dmdDet.id_demand GROUP BY dmdRes.id, dmdRes.id_installment,inst.start_date,wcd.id ORDER BY inst.start_date) AS dcb");
        return this.getCurrentSession().createSQLQuery(strBuf.toString()).setLong("dmdId", egDemand.getId().longValue()).list();
    }

    public Installment getCurrentInstallment(String moduleName, String installmentType, Date date) {
        if (null == installmentType) {
            return this.installmentDao.getInsatllmentByModuleForGivenDate(this.moduleService.getModuleByName(moduleName), new Date());
        }
        return this.installmentDao.getInsatllmentByModuleForGivenDateAndInstallmentType(this.moduleService.getModuleByName(moduleName), date, installmentType);
    }

    public Map<String, BigDecimal> getDemandCollMapForBill(WaterConnectionDetails waterConnectionDetails, String moduleName, String installmentType) {
        EgDemand currDemand = waterConnectionDetails.getDemand();
        List<Object> dmdCollList = new ArrayList();
        Integer instId = null;
        Double balance = null;
        Integer val = null;
        HashMap<String, BigDecimal> retMap = new HashMap<String, BigDecimal>();
        if (currDemand != null) {
            dmdCollList = this.getDmdCollAmtInstallmentWiseWithIsDmdTrue(currDemand);
        }
        for (Object object : dmdCollList) {
            Object[] listObj = (Object[])object;
            balance = (Double)listObj[6];
            if (BigDecimal.valueOf(balance).signum() <= 0) continue;
            val = Integer.valueOf(listObj[0].toString());
            instId = Integer.valueOf(listObj[2].toString());
            retMap.put("wcdid", BigDecimal.valueOf(val.intValue()));
            retMap.put("inst", BigDecimal.valueOf(instId.intValue()));
        }
        return retMap;
    }

    public Boolean meterEntryAllReadyExistForCurrentMonth(WaterConnectionDetails waterConnectionDetails, Date givenDate) {
        Boolean currrentInstallMentExist = false;
        Installment installment = this.getCurrentInstallment("Water Tax Management", "Monthly", givenDate);
        if (waterConnectionDetails.getDemand() != null && waterConnectionDetails.getDemand().getEgInstallmentMaster() != null && installment != null && installment.getInstallmentNumber().equals(waterConnectionDetails.getDemand().getEgInstallmentMaster().getInstallmentNumber())) {
            currrentInstallMentExist = true;
        }
        return currrentInstallMentExist;
    }
}

