/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.utils;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.pims.commons.Position;
import org.egov.works.lineestimate.entity.DocumentDetails;
import org.egov.works.lineestimate.entity.enums.LineEstimateStatus;
import org.egov.works.lineestimate.repository.DocumentDetailsRepository;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class WorksUtils {
    @Autowired
    private DocumentDetailsRepository documentDetailsRepository;
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private FinancialYearHibernateDAO financialYearHibernateDAO;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @PersistenceContext
    private EntityManager entityManager;

    public void persistDocuments(List<DocumentDetails> documentDetailsList) {
        if (documentDetailsList != null && !documentDetailsList.isEmpty()) {
            for (DocumentDetails doc : documentDetailsList) {
                this.documentDetailsRepository.save(doc);
            }
        }
    }

    public List<DocumentDetails> getDocumentDetails(MultipartFile[] files, Object object, String objectType) throws IOException {
        ArrayList<DocumentDetails> documentDetailsList = new ArrayList<DocumentDetails>();
        Long id = null;
        Method method = null;
        try {
            method = object.getClass().getMethod("getId", null);
            id = (Long)method.invoke(object, null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ApplicationRuntimeException("lineestimate.document.error", (Throwable)e);
        }
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isEmpty()) continue;
                DocumentDetails documentDetails = new DocumentDetails();
                documentDetails.setObjectId(id);
                documentDetails.setObjectType(objectType);
                documentDetails.setFileStore(this.fileStoreService.store(files[i].getInputStream(), files[i].getOriginalFilename(), files[i].getContentType(), "WMS"));
                documentDetailsList.add(documentDetails);
            }
        }
        return documentDetailsList;
    }

    public void deleteDocuments(Long documentId) {
        this.documentDetailsRepository.delete(documentId);
    }

    public List<DocumentDetails> findByObjectIdAndObjectType(Long objectId, String objectType) {
        return this.documentDetailsRepository.findByObjectIdAndObjectType(objectId, objectType);
    }

    public Long getApproverPosition(String designationName, State state, Long createdById) {
        String[] desgnArray;
        Set stateHistoryList = state.getHistory();
        Long approverPosition = 0L;
        String[] stringArray = desgnArray = designationName != null ? designationName.split(",") : null;
        if (stateHistoryList != null && !stateHistoryList.isEmpty()) {
            for (StateHistory stateHistory : stateHistoryList) {
                if (stateHistory.getOwnerPosition() == null) continue;
                List assignmentList = this.assignmentService.getAssignmentsForPosition(stateHistory.getOwnerPosition().getId(), new Date());
                block1: for (Assignment assgn : assignmentList) {
                    if (desgnArray == null) continue;
                    String[] stringArray2 = desgnArray;
                    int n = stringArray2.length;
                    for (int i = 0; i < n; ++i) {
                        String str = stringArray2[i];
                        if (!assgn.getDesignation().getName().equalsIgnoreCase(str)) continue;
                        approverPosition = stateHistory.getOwnerPosition().getId();
                        continue block1;
                    }
                }
            }
            if (approverPosition == 0L) {
                State stateObj = state;
                List assignmentList = this.assignmentService.getAssignmentsForPosition(stateObj.getOwnerPosition().getId(), new Date());
                block3: for (Assignment assgn : assignmentList) {
                    if (desgnArray == null) continue;
                    for (String str : desgnArray) {
                        if (!assgn.getDesignation().getName().equalsIgnoreCase(str)) continue;
                        approverPosition = stateObj.getOwnerPosition().getId();
                        continue block3;
                    }
                }
            }
        } else {
            Position posObjToClerk = this.positionMasterService.getCurrentPositionForUser(createdById);
            approverPosition = posObjToClerk.getId();
        }
        return approverPosition;
    }

    public String getApproverName(Long approvalPosition) {
        Assignment assignment = null;
        List<Object> asignList = null;
        if (approvalPosition != null) {
            assignment = this.assignmentService.getPrimaryAssignmentForPositionAndDate(approvalPosition, new Date());
        }
        if (assignment != null) {
            asignList = new ArrayList<Assignment>();
            asignList.add(assignment);
        } else if (assignment == null) {
            asignList = this.assignmentService.getAssignmentsForPosition(approvalPosition, new Date());
        }
        return !asignList.isEmpty() ? ((Assignment)asignList.get(0)).getEmployee().getName() : "";
    }

    public String getPathVars(EgwStatus status, State state, Long id, Long approvalPosition) {
        Assignment currentUserAssignment = this.assignmentService.getPrimaryAssignmentForGivenRange(this.securityUtils.getCurrentUser().getId(), new Date(), new Date());
        Assignment assignObj = null;
        List<Object> asignList = null;
        if (approvalPosition != null) {
            assignObj = this.assignmentService.getPrimaryAssignmentForPositon(approvalPosition);
        }
        if (assignObj != null) {
            asignList = new ArrayList<Assignment>();
            asignList.add(assignObj);
        } else if (assignObj == null && approvalPosition != null) {
            asignList = this.assignmentService.getAssignmentsForPosition(approvalPosition, new Date());
        }
        String nextDesign = "";
        if (asignList != null) {
            nextDesign = !asignList.isEmpty() ? ((Assignment)asignList.get(0)).getDesignation().getName() : "";
        }
        String pathVars = "";
        pathVars = !status.getCode().equalsIgnoreCase(LineEstimateStatus.REJECTED.toString()) ? id + "," + this.getApproverName(approvalPosition) + "," + (currentUserAssignment != null ? currentUserAssignment.getDesignation().getName() : "") + "," + (nextDesign != null ? nextDesign : "") : id + "," + this.getApproverName(state.getOwnerPosition().getId()) + "," + (currentUserAssignment != null ? currentUserAssignment.getDesignation().getName() : "") + "," + (nextDesign != null ? state.getOwnerPosition().getDeptDesig().getDesignation().getName() : "");
        return pathVars;
    }

    public String getUserDesignation(User user) {
        List assignmentList = new ArrayList();
        assignmentList = this.assignmentService.findByEmployeeAndGivenDate(user != null ? user.getId() : null, new Date());
        if (!assignmentList.isEmpty()) {
            return ((Assignment)assignmentList.get(0)).getDesignation().getName();
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public EgwStatus getStatusByModuleAndCode(String moduleType, String code) {
        return this.egwStatusHibernateDAO.getStatusByModuleAndCode(moduleType, code);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public List<EgwStatus> getStatusByModule(String moduleType) {
        return this.egwStatusHibernateDAO.getStatusByModule(moduleType);
    }

    public String getExceptionalUOMS() {
        List exceptionalUomValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "EXCEPTIONALUOMS");
        String exceptionaluoms = "";
        for (AppConfigValues appVal : exceptionalUomValues) {
            exceptionaluoms = exceptionaluoms + appVal.getValue() + ":";
        }
        return exceptionaluoms;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public EgwStatus getStatusById(Integer id) {
        return this.egwStatusHibernateDAO.findById(id, true);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public CFinancialYear getFinancialYearByDate(Date billdate) {
        return this.financialYearHibernateDAO.getFinancialYearByDate(billdate);
    }

    public List<Hashtable<String, Object>> getWorkFlowHistory(State state, List<StateHistory> history) {
        User user = null;
        Assignment assignment = null;
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm a");
        ArrayList<Hashtable<String, Object>> historyTable = new ArrayList<Hashtable<String, Object>>();
        Hashtable<String, String> map = new Hashtable<String, String>(0);
        if (null != state) {
            for (StateHistory stateHistory : history) {
                if (stateHistory.getValue().equals("NEW")) continue;
                Hashtable<String, String> HistoryMap = new Hashtable<String, String>(0);
                HistoryMap.put("date", sdf.format(stateHistory.getDateInfo()));
                HistoryMap.put("comments", stateHistory.getComments());
                if (StringUtils.isNotBlank((CharSequence)stateHistory.getNextAction())) {
                    HistoryMap.put("status", stateHistory.getValue() + "-" + stateHistory.getNextAction());
                } else {
                    HistoryMap.put("status", stateHistory.getValue());
                }
                user = stateHistory.getLastModifiedBy();
                if (null != user) {
                    assignment = this.assignmentService.getPrimaryAssignmentForUser(user.getId());
                    HistoryMap.put("user", user.getName());
                    HistoryMap.put("designation", assignment.getDesignation().getName());
                }
                historyTable.add(HistoryMap);
            }
            if (!state.getValue().equals("NEW")) {
                map.put("date", sdf.format(state.getDateInfo()));
                map.put("comments", state.getComments() != null ? state.getComments() : "");
                if (StringUtils.isNotBlank((CharSequence)state.getNextAction())) {
                    map.put("status", state.getValue() + "-" + state.getNextAction());
                } else {
                    map.put("status", state.getValue());
                }
                user = state.getLastModifiedBy();
                if (null != user) {
                    assignment = this.assignmentService.getPrimaryAssignmentForUser(user.getId());
                    map.put("user", user.getName());
                    map.put("designation", assignment.getDesignation().getName());
                }
                historyTable.add(map);
            }
        }
        return historyTable;
    }

    public List<FileStoreMapper> getLatestSorRateUploadOriginalFiles() {
        return ((Session)this.entityManager.unwrap(Session.class)).createQuery("from FileStoreMapper where fileName like '%sor_original%' order by id desc ").setMaxResults(5).list();
    }

    public List<FileStoreMapper> getLatestSorRateUploadOutPutFiles() {
        return ((Session)this.entityManager.unwrap(Session.class)).createQuery("from FileStoreMapper where fileName like '%sor_output%' order by id desc ").setMaxResults(5).list();
    }

    public Date getCutOffDate() {
        Date cutOffDate = null;
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
        List cutOffDateAppConfig = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "CUTOFFDATEFORLEGACYDATAENTRY");
        if (cutOffDateAppConfig != null && !cutOffDateAppConfig.isEmpty()) {
            AppConfigValues appConfigValue = (AppConfigValues)cutOffDateAppConfig.get(0);
            try {
                cutOffDate = formatter.parse(appConfigValue.getValue());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return cutOffDate;
    }
}

