/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.infra.exception.ApplicationException;
import org.egov.infstr.models.EgChecklists;
import org.egov.model.bills.EgBilldetails;
import org.egov.model.bills.EgBillregister;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.mb.entity.MBForCancelledBill;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.models.contractorBill.AssetForBill;
import org.egov.works.models.contractorBill.DeductionTypeForBill;
import org.egov.works.models.contractorBill.StatutoryDeductionsForBill;
import org.egov.works.models.contractorBill.WorkCompletionDetailInfo;
import org.egov.works.models.contractorBill.WorkCompletionInfo;
import org.egov.works.services.BaseService;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderEstimate;

public interface ContractorBillService
extends BaseService<ContractorBillRegister, Long> {
    public List getBillType();

    public boolean contractorBillNumberChangeRequired(EgBillregister var1, WorkOrder var2, CFinancialYear var3);

    public String generateContractorBillNumber(ContractorBillRegister var1);

    public BigDecimal getUtlizedAmountForUnArrovedBill(Long var1, Date var2);

    public BigDecimal getApprovedMBAmount(Long var1, Long var2, Date var3);

    public BigDecimal calculateTotalPendingAdvance(BigDecimal var1, Date var2, WorkOrderEstimate var3, Long var4);

    public Map<String, String[]> getStandardDeductionsFromConfig();

    public List<String> searchContractorBill(Map<String, Object> var1, List<Object> var2);

    public BigDecimal getTotalValueWoForUptoBillDate(Date var1, Long var2, Long var3);

    public List<String> getSortedDeductionsFromConfig(String var1);

    public List<StatutoryDeductionsForBill> getStatutoryListForBill(Long var1);

    public List<StatutoryDeductionsForBill> getStatutoryDeductionSortedOrder(List<String> var1, List<StatutoryDeductionsForBill> var2);

    public List<DeductionTypeForBill> getStandardDeductionForBill(Long var1);

    public List<DeductionTypeForBill> getStandardDeductionSortedOrder(List<String> var1, List<DeductionTypeForBill> var2);

    public List<AssetForBill> getAssetForBill(Long var1);

    public BigDecimal getAdvanceAdjustmentAmountForBill(Long var1, Long var2);

    public List<EgBilldetails> getCustomDeductionListforglcodes(List<BigDecimal> var1, Long var2);

    public BigDecimal getNetPayableAmountForGlCodeId(Long var1) throws NumberFormatException, ApplicationException;

    public BigDecimal getTotAmtForStatutory(Date var1, Long var2, StatutoryDeductionsForBill var3, Long var4);

    public BigDecimal getTotAmtForAdvanceAdjustment(Date var1, Long var2, Long var3);

    public BigDecimal getTotAmtForStandard(Date var1, Long var2, DeductionTypeForBill var3, Long var4);

    public BigDecimal getTotAmtForCustom(Date var1, Long var2, EgBilldetails var3, Long var4);

    public List<EgBilldetails> getCustomDeductionList(Long var1, Long var2, List<StatutoryDeductionsForBill> var3, List<DeductionTypeForBill> var4, List<EgBilldetails> var5) throws NumberFormatException, ApplicationException;

    public List<EgBilldetails> getRetentionMoneyDeductionList(Long var1, List<StatutoryDeductionsForBill> var2, List<DeductionTypeForBill> var3) throws NumberFormatException, ApplicationException;

    public BigDecimal getNetPaybleCode(Long var1) throws Exception;

    public List<MBHeader> getMbListForBillAndWorkordrId(Long var1, Long var2);

    public List<MBForCancelledBill> getMbListForCancelBill(Long var1);

    public List<EgBilldetails> getAccountDetailsList(Long var1, Long var2, List<StatutoryDeductionsForBill> var3, List<DeductionTypeForBill> var4, List<EgBilldetails> var5, List<EgBilldetails> var6) throws NumberFormatException, ApplicationException;

    public void setAllViewLists(Long var1, Long var2, Long var3, List<StatutoryDeductionsForBill> var4, List<DeductionTypeForBill> var5, List<EgBilldetails> var6, List<EgBilldetails> var7, List<AssetForBill> var8) throws NumberFormatException, ApplicationException;

    public List<EgChecklists> getEgcheckList(Long var1) throws NumberFormatException, ApplicationException;

    public WorkCompletionInfo setWorkCompletionInfoFromBill(ContractorBillRegister var1, WorkOrderEstimate var2);

    public List<WorkCompletionDetailInfo> setWorkCompletionDetailInfoList(WorkOrderEstimate var1);

    public BigDecimal getApprovedMBAmountforBill(ContractorBillRegister var1);

    public BigDecimal getApprovedMBAmountOfTenderedItemsForBill(ContractorBillRegister var1);

    public Double getTotalActualExpenseForProject(AbstractEstimate var1, Date var2);

    public List<EgBillregister> getListOfApprovedBillforEstimate(AbstractEstimate var1, Date var2);

    public List<EgBillregister> getListOfNonCancelledBillsforEstimate(AbstractEstimate var1, Date var2);

    public BigDecimal getBilledAmount(AbstractEstimate var1);

    public BigDecimal getBilledAmountForDate(AbstractEstimate var1, Date var2);

    public BigDecimal getApprovedMBAmountOfTenderedItems(Long var1, Long var2, Date var3);

    public List<CChartOfAccounts> getBudgetHeadForDepositCOA(AbstractEstimate var1);

    public String validateForBudgetHeadInWorkflow(Set<EgBilldetails> var1, AbstractEstimate var2);

    public List<Integer> getProjCodeIdsListForDepositCode(Integer var1, Long var2, Long var3);

    public BigDecimal getTotalExpenditure(List<Integer> var1, String var2);

    public Object[] getLatestMBCreatedDateAndRefNo(Long var1, Long var2);

    public Collection<StatutoryDeductionsForBill> getStatutoryDeductions(List<StatutoryDeductionsForBill> var1);

    public Collection<EgBilldetails> getCustomDeductionTypes(List<EgBilldetails> var1);

    public Collection<EgBilldetails> getRetentionMoneyTypes(List<EgBilldetails> var1);

    public Collection<AssetForBill> getAssetAndAccountDetails(List<AssetForBill> var1);

    public Collection<DeductionTypeForBill> getStandardDeductionTypes(List<DeductionTypeForBill> var1);
}

