/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.models.masters;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.Valid;
import org.egov.commons.Bank;
import org.egov.commons.EgwStatus;
import org.egov.commons.utils.EntityType;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.OptionalPattern;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.works.models.masters.ContractorDetail;
import org.egov.works.models.masters.ExemptionForm;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGW_CONTRACTOR")
@Unique(fields={"code"}, id="id", tableName="EGW_CONTRACTOR", columnName={"CODE"}, message="contractor.code.isunique")
@NamedQueries(value={@NamedQuery(name="GET_CONTRACTORS_BY_STATUS", query=" select distinct cont from Contractor cont inner join cont.contractorDetails as cd where cd.status.description = ? ")})
@SequenceGenerator(name="SEQ_EGW_CONTRACTOR", sequenceName="SEQ_EGW_CONTRACTOR", allocationSize=1)
public class Contractor
extends AbstractAuditable
implements EntityType {
    private static final long serialVersionUID = 6858362239507609219L;
    public static final String SEQ_EGW_CONTRACTOR = "SEQ_EGW_CONTRACTOR";
    public static final String GET_CONTRACTORS_BY_STATUS = "GET_CONTRACTORS_BY_STATUS";
    @Id
    @GeneratedValue(generator="SEQ_EGW_CONTRACTOR", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Required(message="contractor.code.null")
    @Length(max=50, message="contractor.code.length")
    @OptionalPattern(regex="[0-9a-zA-Z-& :,/.()@]+", message="contractor.code.alphaNumeric")
    private String code;
    @Required(message="contractor.name.null")
    @Length(max=100, message="contractor.name.length")
    @OptionalPattern(regex="[0-9a-zA-Z-& :,/.()@]+", message="contractor.name.alphaNumeric")
    private String name;
    @Length(max=250, message="contractor.correspondenceAddress.length")
    @Column(name="CORRESPONDENCE_ADDRESS")
    @OptionalPattern(regex="[0-9a-zA-Z_@./#&+/-/!(){}\",^$%*|=;:<>?`~ ]+", message="contractor.correspondenceaddress.alphaNumeric")
    private String correspondenceAddress;
    @Length(max=250, message="contractor.paymentAddress.length")
    @Column(name="PAYMENT_ADDRESS")
    @OptionalPattern(regex="[0-9a-zA-Z_@./#&+/-/!(){}\",^$%*|=;:<>?`~ ]+", message="contractor.paymentaddress.alphaNumeric")
    private String paymentAddress;
    @Length(max=100, message="contractor.contactPerson.length")
    @OptionalPattern(regex="[0-9a-zA-Z ]+", message="contractor.contactPerson.alphaNumeric")
    @Column(name="CONTACT_PERSON")
    private String contactPerson;
    @OptionalPattern(regex="^[\\w!#$%&'*+/=?`{|}~^-]+(?:\\.[\\w!#$%&'*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$", message="contractor.email.invalid")
    @Length(max=100, message="contractor.email.length")
    private String email;
    @Length(max=1024, message="contractor.narration.length")
    @OptionalPattern(regex="[0-9a-zA-Z_@./#&+/-/!(){}\",^$%*|=;:<>?`~ ]+", message="contractor.narration.alphaNumeric")
    private String narration;
    @Length(max=10, message="contractor.panNumber.length")
    @OptionalPattern(regex="[a-zA-Z]{5}[0-9]{4}[a-zA-Z]{1}", message="contractor.panNumber.alphaNumeric")
    @Column(name="PAN_NUMBER")
    private String panNumber;
    @Length(max=14, message="contractor.tinNumber.length")
    @OptionalPattern(regex="[0-9a-zA-Z]+", message="contractor.tinNumber.alphaNumeric")
    @Column(name="TIN_NUMBER")
    private String tinNumber;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="BANK_ID")
    private Bank bank;
    @Length(max=15, message="contractor.ifscCode.length")
    @OptionalPattern(regex="[0-9a-zA-Z]+", message="contractor.ifscCode.alphaNumeric")
    @Column(name="IFSC_CODE")
    private String ifscCode;
    @Length(max=22, message="contractor.bankAccount.length")
    @OptionalPattern(regex="[0-9a-zA-Z]+", message="contractor.bankAccount.alphaNumeric")
    @Column(name="BANK_ACCOUNT")
    private String bankAccount;
    @Length(max=50, message="contractor.pwdApprovalCode.length")
    @OptionalPattern(regex="[0-9a-zA-Z-& :,/.()@]+", message="contractor.pwdApprovalCode.alphaNumeric")
    @Column(name="PWD_APPROVAL_CODE")
    private String pwdApprovalCode;
    @Enumerated(value=EnumType.STRING)
    @Column(name="EXEMPTION")
    private ExemptionForm exemptionForm;
    @Valid
    @JsonIgnore
    @OneToMany(mappedBy="contractor", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=ContractorDetail.class)
    private List<ContractorDetail> contractorDetails = new LinkedList<ContractorDetail>();

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCorrespondenceAddress() {
        return this.correspondenceAddress;
    }

    public void setCorrespondenceAddress(String correspondenceAddress) {
        this.correspondenceAddress = correspondenceAddress;
    }

    public String getPaymentAddress() {
        return this.paymentAddress;
    }

    public void setPaymentAddress(String paymentAddress) {
        this.paymentAddress = paymentAddress;
    }

    public String getContactPerson() {
        return this.contactPerson;
    }

    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getNarration() {
        return this.narration;
    }

    public void setNarration(String narration) {
        this.narration = narration;
    }

    public String getPanNumber() {
        return this.panNumber;
    }

    public void setPanNumber(String panNumber) {
        this.panNumber = panNumber;
    }

    public String getTinNumber() {
        return this.tinNumber;
    }

    public void setTinNumber(String tinNumber) {
        this.tinNumber = tinNumber;
    }

    public Bank getBank() {
        return this.bank;
    }

    public void setBank(Bank bank) {
        this.bank = bank;
    }

    public String getIfscCode() {
        return this.ifscCode;
    }

    public void setIfscCode(String ifscCode) {
        this.ifscCode = ifscCode;
    }

    public String getBankAccount() {
        return this.bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getPwdApprovalCode() {
        return this.pwdApprovalCode;
    }

    public void setPwdApprovalCode(String pwdApprovalCode) {
        this.pwdApprovalCode = pwdApprovalCode;
    }

    public List<ContractorDetail> getContractorDetails() {
        return this.contractorDetails;
    }

    public ExemptionForm getExemptionForm() {
        return this.exemptionForm;
    }

    public void setExemptionForm(ExemptionForm exemptionForm) {
        this.exemptionForm = exemptionForm;
    }

    public void setContractorDetails(List<ContractorDetail> contractorDetails) {
        this.contractorDetails = contractorDetails;
    }

    public void addContractorDetail(ContractorDetail contractorDetail) {
        this.contractorDetails.add(contractorDetail);
    }

    public List<ValidationError> validate() {
        List<ValidationError> errorList = null;
        if (this.contractorDetails != null && this.contractorDetails.isEmpty()) {
            return Arrays.asList(new ValidationError("contractorDetails", "contractor.details.altleastone_details_needed"));
        }
        if (this.contractorDetails != null && !this.contractorDetails.isEmpty()) {
            for (ContractorDetail contractorDetail : this.contractorDetails) {
                errorList = contractorDetail.validate();
                if (errorList == null) continue;
                return errorList;
            }
        }
        return errorList;
    }

    public String getBankaccount() {
        return this.bankAccount;
    }

    public String getBankname() {
        if (this.bank == null) {
            return "";
        }
        return this.bank.getName();
    }

    public String getIfsccode() {
        return this.ifscCode;
    }

    public String getPanno() {
        return this.panNumber;
    }

    public String getTinno() {
        return this.tinNumber;
    }

    public String getModeofpay() {
        return null;
    }

    public Integer getEntityId() {
        return this.id.intValue();
    }

    public String getEntityDescription() {
        return this.getName();
    }

    public EgwStatus getEgwStatus() {
        return null;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

