/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.milestone.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.works.milestone.entity.SearchRequestMilestone;
import org.egov.works.milestone.entity.TrackMilestone;
import org.egov.works.milestone.repository.TrackMilestoneRepository;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TrackMilestoneService {
    @PersistenceContext
    private EntityManager entityManager;
    private final TrackMilestoneRepository trackMilestoneRepository;

    @Autowired
    public TrackMilestoneService(TrackMilestoneRepository trackMilestoneRepository) {
        this.trackMilestoneRepository = trackMilestoneRepository;
    }

    public List<TrackMilestone> searchTrackMilestone(SearchRequestMilestone searchRequestMilestone) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(TrackMilestone.class).createAlias("milestone", "milestone").createAlias("milestone.workOrderEstimate", "woe").createAlias("woe.estimate", "estimate").createAlias("estimate.lineEstimateDetails", "led").createAlias("led.lineEstimate", "le").createAlias("status", "status").createAlias("woe.workOrder", "wo").createAlias("led.projectCode", "projectCode");
        if (searchRequestMilestone != null) {
            if (searchRequestMilestone.getDepartment() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"le.executingDepartment.id", (Object)searchRequestMilestone.getDepartment()));
            }
            if (searchRequestMilestone.getTrackMilestoneFromDate() != null) {
                criteria.add((Criterion)Restrictions.ge((String)"createdDate", (Object)searchRequestMilestone.getTrackMilestoneFromDate()));
            }
            if (searchRequestMilestone.getTrackMilestoneToDate() != null) {
                DateTime dateTime = new DateTime(searchRequestMilestone.getTrackMilestoneToDate().getTime()).plusDays(1);
                criteria.add((Criterion)Restrictions.le((String)"createdDate", (Object)dateTime.toDate()));
            }
            if (searchRequestMilestone.getStatus() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"status.code", (Object)searchRequestMilestone.getStatus()));
            }
            if (searchRequestMilestone.getSubTypeOfWork() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"le.subTypeOfWork.id", (Object)searchRequestMilestone.getSubTypeOfWork()));
            }
            if (searchRequestMilestone.getTypeOfWork() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"le.typeOfWork.id", (Object)searchRequestMilestone.getTypeOfWork()));
            }
            if (searchRequestMilestone.getWorkIdentificationNumber() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"projectCode.code", (Object)searchRequestMilestone.getWorkIdentificationNumber()).ignoreCase());
            }
            if (searchRequestMilestone.getWorkOrderNumber() != null) {
                criteria.add(Restrictions.ilike((String)"wo.workOrderNumber", (String)searchRequestMilestone.getWorkOrderNumber(), (MatchMode)MatchMode.ANYWHERE));
            }
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public List<String> findWorkIdentificationNumbersTrackMilestone(String code) {
        List<String> workIdNumbers = this.trackMilestoneRepository.findWorkIdentificationNumbersTrackMilestone("%" + code + "%");
        return workIdNumbers;
    }

    @Transactional
    public TrackMilestone save(TrackMilestone trackMilestone) {
        return (TrackMilestone)((Object)this.trackMilestoneRepository.save((Object)trackMilestone));
    }

    public TrackMilestone getTrackMilestoneByMilestoneId(Long id) {
        return this.trackMilestoneRepository.findByMilestone_Id(id);
    }
}

