/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.milestone.entity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.egov.commons.EgwStatus;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.works.milestone.entity.Milestone;
import org.egov.works.milestone.entity.TrackMilestoneActivity;

@Entity
@Table(name="EGW_TRACK_MILESTONE")
@Unique(id="id", tableName="EGW_TRACK_MILESTONE")
@SequenceGenerator(name="SEQ_EGW_TRACK_MILESTONE", sequenceName="SEQ_EGW_TRACK_MILESTONE", allocationSize=1)
public class TrackMilestone
extends StateAware {
    private static final long serialVersionUID = -366602348464540736L;
    public static final String SEQ_EGW_TRACK_MILESTONE = "SEQ_EGW_TRACK_MILESTONE";
    @Id
    @GeneratedValue(generator="SEQ_EGW_TRACK_MILESTONE", strategy=GenerationType.SEQUENCE)
    private Long id;
    private BigDecimal totalPercentage;
    private boolean projectCompleted;
    @Temporal(value=TemporalType.DATE)
    private Date approvedDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="status", nullable=false)
    private EgwStatus status;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="milestone", nullable=false)
    private Milestone milestone;
    @OrderBy(value="id")
    @OneToMany(mappedBy="trackMilestone", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=TrackMilestoneActivity.class)
    private List<TrackMilestoneActivity> activities = new LinkedList<TrackMilestoneActivity>();
    private transient String ownerName;
    @Transient
    private String approvalComent;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BigDecimal getTotalPercentage() {
        return this.totalPercentage;
    }

    public void setTotalPercentage(BigDecimal totalPercentage) {
        this.totalPercentage = totalPercentage;
    }

    public Date getApprovedDate() {
        return this.approvedDate;
    }

    public void setApprovedDate(Date approvedDate) {
        this.approvedDate = approvedDate;
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }

    public Milestone getMilestone() {
        return this.milestone;
    }

    public void setMilestone(Milestone milestone) {
        this.milestone = milestone;
    }

    public String getStateDetails() {
        return "Estimate Number : " + this.milestone.getWorkOrderEstimate().getEstimate().getEstimateNumber();
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public List<TrackMilestoneActivity> getActivities() {
        return this.activities;
    }

    public void addActivity(TrackMilestoneActivity activity) {
        this.activities.add(activity);
    }

    public void setActivities(List<TrackMilestoneActivity> activities) {
        this.activities = activities;
    }

    public String getApprovalComent() {
        return this.approvalComent;
    }

    public void setApprovalComent(String approvalComent) {
        this.approvalComent = approvalComent;
    }

    public boolean isProjectCompleted() {
        return this.projectCompleted;
    }

    public void setProjectCompleted(boolean projectCompleted) {
        this.projectCompleted = projectCompleted;
    }

    public static enum Actions {
        SUBMIT_FOR_APPROVAL,
        APPROVE,
        REJECT,
        CANCEL;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum TrackMilestoneStatus {
        CREATED,
        APPROVED,
        REJECTED,
        CANCELLED,
        RESUBMITTED;

    }
}

