/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.mb.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.GreaterThan;
import org.egov.infra.persistence.validator.annotation.OptionalPattern;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.mb.entity.MBMeasurementSheet;
import org.egov.works.workorder.entity.WorkOrderActivity;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGW_MB_DETAILS")
@NamedQueries(value={@NamedQuery(name="prevCumulativeQuantity", query=" select sum(mbd.quantity) from MBDetails mbd where (mbd.mbHeader.createdDate < (select createdDate from MBHeader where id = ?) or (select count(*) from MBHeader where id = ?) = 0 ) and mbd.mbHeader.egwStatus.code != ? group by mbd.workOrderActivity having mbd.workOrderActivity.id = ?"), @NamedQuery(name="prevCumulativeQuantityForCQ", query=" select sum(mbd.quantity) from MBDetails mbd where (mbd.mbHeader.createdDate < (select createdDate from MBHeader where id = ?) or (select count(*) from MBHeader where id = ?) = 0 ) and mbd.mbHeader.egwStatus.code != ? and (mbd.workOrderActivity.workOrderEstimate.workOrder = ? or mbd.workOrderActivity.workOrderEstimate.workOrder.parent = ?) group by mbd.workOrderActivity,mbd.workOrderActivity.activity having (mbd.workOrderActivity.id = ? or mbd.workOrderActivity.activity.id = ? ) "), @NamedQuery(name="prevCumulativeQuantityForREs", query=" select sum(mbd.quantity) from MBDetails mbd where (mbd.mbHeader.createdDate < (select createdDate from MBHeader where id = ?) or (select count(*) from MBHeader where id = ?) = 0 ) and mbd.mbHeader.egwStatus.code != ? group by mbd.workOrderActivity.activity.parent having ((mbd.workOrderActivity.activity.parent is not null and mbd.workOrderActivity.activity.parent.id = ?)) "), @NamedQuery(name="totalApprovedMBAmount", query=" select sum(mbd.quantity*mbd.workOrderActivity.approvedRate) from MBDetails mbd where mbd.mbHeader.egwStatus.code = ? and mbd.mbHeader.workOrderEstimate.workOrder.id = ? and mbd.mbHeader.workOrderEstimate.id = ? and trunc(mbd.mbHeader.state.createdDate) <= ? and mbd.mbHeader.egBillregister is null "), @NamedQuery(name="totalApprovedMBAmountForCancelledBill", query="select sum(mbd.quantity*mbd.workOrderActivity.approvedRate) from MBDetails mbd where mbd.mbHeader.egwStatus.code = ? and mbd.mbHeader.workOrderEstimate.workOrder.id = ? and mbd.mbHeader.workOrderEstimate.id = ? and trunc(mbd.mbHeader.state.createdDate) <= ? and mbd.mbHeader.egBillregister is not null and mbd.mbHeader.egBillregister.status.code = ?"), @NamedQuery(name="getUtlizedAmountForUnArrovedBill", query=" \tselect sum(reg.passedamount) from MBHeader mbh join mbh.egBillregister as reg where  reg.status.code not in (?) and mbh.workOrder.id = ? and trunc(reg.billdate) <= ? and reg.egBillregistermis.voucherHeader is null"), @NamedQuery(name="gettotalApprovedMBs", query=" \tselect mbd.workOrderActivity.id,mbd.quantity  from MBDetails mbd where mbd.mbHeader.egwStatus.code = ? and mbd.mbHeader.isLegacyMB!=1 and mbd.mbHeader.workOrderEstimate.workOrder.id = ? and mbd.mbHeader.workOrderEstimate.id = ? and trunc(mbd.mbHeader.state.createdDate) <= ? and mbd.mbHeader.egBillregister is null group by mbd.workOrderActivity.id,mbd.quantity, mbd.mbHeader.id "), @NamedQuery(name="gettotalApprovedMBsForCancelledBill", query=" select mbd.workOrderActivity.id,mbd.quantity from MBDetails mbd where mbd.mbHeader.egwStatus.code = ? and mbd.mbHeader.isLegacyMB!=1 and mbd.mbHeader.workOrderEstimate.workOrder.id = ? and mbd.mbHeader.workOrderEstimate.id = ? and trunc(mbd.mbHeader.state.createdDate) <= ? and mbd.mbHeader.egBillregister is not null and mbd.mbHeader.egBillregister.status.code = ? group by mbd.workOrderActivity.id,mbd.quantity, mbd.mbHeader.id "), @NamedQuery(name="getMBAmountForBill", query=" select mbd.workOrderActivity.id,mbd.quantity  from MBDetails mbd where mbd.mbHeader.egwStatus.code = ?  and mbd.mbHeader.isLegacyMB!=1 and mbd.mbHeader.egBillregister.id = ? group by mbd.workOrderActivity.id,mbd.quantity, mbd.mbHeader.id "), @NamedQuery(name="totalEstimatedQuantity", query="  select sum(woa.approvedQuantity) from WorkOrderActivity woa where woa.workOrderEstimate.workOrder.egwStatus.code<>'CANCELLED' and woa.workOrderEstimate.workOrder = ? group by woa,woa.activity having (id = ? or activity.id = ?) "), @NamedQuery(name="totalEstimatedQuantityForRE", query="select sum(woa.approvedQuantity*coalesce((CASE WHEN woa.activity.revisionType = 'REDUCED_QUANTITY' THEN -1 WHEN woa.activity.revisionType = 'ADDITIONAL_QUANTITY' THEN 1 WHEN woa.activity.revisionType = 'NON_TENDERED_ITEM' THEN 1 WHEN woa.activity.revisionType = 'LUMP_SUM_ITEM' THEN 1 END),1)) from WorkOrderActivity woa where woa.activity.abstractEstimate.egwStatus.code = 'APPROVED' and woa.activity.createdDate < ? and woa.workOrderEstimate.workOrder.egwStatus.code<>'CANCELLED' and ((woa.activity.parent is null and woa.workOrderEstimate.workOrder = ?) or (woa.workOrderEstimate.workOrder.parent is not null and woa.workOrderEstimate.workOrder.parent = ?)) group by woa.activity.parent having (woa.activity.parent is not null and woa.activity.parent.id = ? )"), @NamedQuery(name="totalEstimatedQuantityInRE", query="  select sum(woa.approvedQuantity) from WorkOrderActivity woa where woa.activity.abstractEstimate.egwStatus.code != 'CANCELLED' and woa.activity.abstractEstimate.id != ? and woa.workOrderEstimate.workOrder.egwStatus.code<>'CANCELLED' and (woa.workOrderEstimate.workOrder = ? or (woa.activity.parent is null and woa.workOrderEstimate.workOrder.parent is not null and woa.workOrderEstimate.workOrder.parent = ?)) group by woa,woa.activity having (id = ? or activity.id = ?)"), @NamedQuery(name="totalEstimatedQuantityForREinRE", query=" select sum(woa.approvedQuantity*coalesce((CASE WHEN woa.activity.revisionType = 'REDUCED_QUANTITY' THEN -1 WHEN woa.activity.revisionType = 'ADDITIONAL_QUANTITY' THEN 1 WHEN woa.activity.revisionType = 'NON_TENDERED_ITEM' THEN 1 WHEN woa.activity.revisionType = 'LUMP_SUM_ITEM' THEN 1 END),1)) from WorkOrderActivity woa where woa.activity.abstractEstimate.egwStatus.code != 'CANCELLED' and woa.activity.abstractEstimate.id != ? and woa.workOrderEstimate.workOrder.egwStatus.code<>'CANCELLED' and (woa.workOrderEstimate.workOrder = ? or (woa.workOrderEstimate.workOrder.parent is not null and woa.workOrderEstimate.workOrder.parent = ?)) group by woa.activity.parent having (woa.activity.parent is not null and woa.activity.parent.id = ? ) "), @NamedQuery(name="totalEstimatedQuantityForPreviousREs", query=" select sum(woa.approvedQuantity*coalesce((CASE WHEN woa.activity.revisionType = 'REDUCED_QUANTITY' THEN -1 WHEN woa.activity.revisionType = 'ADDITIONAL_QUANTITY' THEN 1 WHEN woa.activity.revisionType = 'NON_TENDERED_ITEM' THEN 1 WHEN woa.activity.revisionType = 'LUMP_SUM_ITEM' THEN 1 END),1)) from WorkOrderActivity woa where woa.activity.abstractEstimate.egwStatus.code != 'CANCELLED' and woa.activity.abstractEstimate.createdDate < (select est.createdDate from AbstractEstimate est where est.id = ?) and woa.workOrderEstimate.workOrder.egwStatus.code<>'CANCELLED' and (woa.workOrderEstimate.workOrder = ? or (woa.workOrderEstimate.workOrder.parent is not null and woa.workOrderEstimate.workOrder.parent = ?)) group by woa.activity.parent having (woa.activity.parent is not null and woa.activity.parent.id = ? )  ")})
@SequenceGenerator(name="SEQ_EGW_MB_DETAILS", sequenceName="SEQ_EGW_MB_DETAILS", allocationSize=1)
public class MBDetails
extends AbstractAuditable {
    private static final long serialVersionUID = -5088074625605584344L;
    public static final String SEQ_EGW_MB_DETAILS = "SEQ_EGW_MB_DETAILS";
    public static final String PREVCUMULATIVEQUANTITY = "prevCumulativeQuantity";
    public static final String PREVCUMULATIVEQUANTITYFORCQ = "prevCumulativeQuantityForCQ";
    public static final String PREVCUMULATIVEQUANTITYFORRES = "prevCumulativeQuantityForREs";
    public static final String TOTALAPPROVEDMBAMOUNT = "totalApprovedMBAmount";
    public static final String TOTALAPPROVEDMBAMOUNTFORCANCELLEDBILL = "totalApprovedMBAmountForCancelledBill";
    public static final String GETUTLIZEDAMOUNTFORUNARROVEDBILL = "getUtlizedAmountForUnArrovedBill";
    public static final String GETTOTALAPPROVEDMBS = "gettotalApprovedMBs";
    public static final String GETTOTALAPPROVEDMBSFORCANCELLEDBILL = "gettotalApprovedMBsForCancelledBill";
    public static final String GETMBAMOUNTFORBILL = "getMBAmountForBill";
    public static final String TOTALESTIMATEDQUANTITY = "totalEstimatedQuantity";
    public static final String TOTALESTIMATEDQUANTITYFORRE = "totalEstimatedQuantityForRE";
    public static final String TOTALESTIMATEDQUANTITYINRE = "totalEstimatedQuantityInRE";
    public static final String TOTALESTIMATEDQUANTITYFORREINRE = "totalEstimatedQuantityForREinRE";
    public static final String TOTALESTIMATEDQUANTITYFORPREVIOUSRES = "totalEstimatedQuantityForPreviousREs";
    @Id
    @GeneratedValue(generator="SEQ_EGW_MB_DETAILS", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Required(message="mbdetails.mbheader.null")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="MBHEADER_ID", nullable=false)
    private MBHeader mbHeader;
    @Required(message="mbdetails.activity.null")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="WO_ACTIVITY_ID", nullable=false)
    private WorkOrderActivity workOrderActivity;
    @GreaterThan(value=0L, message="mbdetails.quantity.non.negative")
    private double quantity;
    private double rate;
    @Length(max=400, message="mbdetails.remark.length")
    private String remarks;
    @Transient
    private double prevCumlvQuantity;
    @Transient
    private double currCumlvQuantity;
    @Transient
    private double amtForCurrQuantity;
    @Transient
    private double cumlvAmtForCurrCumlvQuantity;
    @Column(name="ORDER_DATE")
    @Temporal(value=TemporalType.DATE)
    private Date mbdetailsDate;
    @Column(name="ORDER_NUMBER")
    @OptionalPattern(regex="[0-9a-zA-Z/]+", message="mbdetails.ordernumber")
    private String OrderNumber;
    @Transient
    private double totalEstQuantity;
    private double amount = 0.0;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="mbDetails", targetEntity=MBMeasurementSheet.class)
    private List<MBMeasurementSheet> measurementSheets = new LinkedList<MBMeasurementSheet>();

    public List<ValidationError> validate() {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        if (this.mbHeader != null && (this.mbHeader.getId() == null || this.mbHeader.getId() == 0L || this.mbHeader.getId() == -1L)) {
            validationErrors.add(new ValidationError("mbHeader", "mbdetails.mbheader.null"));
        }
        if (this.workOrderActivity != null && (this.workOrderActivity.getId() == null || this.workOrderActivity.getId() == 0L || this.workOrderActivity.getId() == -1L)) {
            validationErrors.add(new ValidationError("workOrderActivity", "mbdetails.activity.null"));
        }
        return validationErrors;
    }

    public void setMbHeader(MBHeader mbHeader) {
        this.mbHeader = mbHeader;
    }

    public MBHeader getMbHeader() {
        return this.mbHeader;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public WorkOrderActivity getWorkOrderActivity() {
        return this.workOrderActivity;
    }

    public void setWorkOrderActivity(WorkOrderActivity workOrderActivity) {
        this.workOrderActivity = workOrderActivity;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public double getPrevCumlvQuantity() {
        return this.prevCumlvQuantity;
    }

    public void setPrevCumlvQuantity(double prevCumlvQuantity) {
        this.prevCumlvQuantity = prevCumlvQuantity;
    }

    public double getCurrCumlvQuantity() {
        return this.currCumlvQuantity;
    }

    public void setCurrCumlvQuantity(double currCumlvQuantity) {
        this.currCumlvQuantity = currCumlvQuantity;
    }

    public double getAmtForCurrQuantity() {
        return this.amtForCurrQuantity;
    }

    public void setAmtForCurrQuantity(double amtForCurrQuantity) {
        this.amtForCurrQuantity = amtForCurrQuantity;
    }

    public double getCumlvAmtForCurrCumlvQuantity() {
        return this.cumlvAmtForCurrCumlvQuantity;
    }

    public void setCumlvAmtForCurrCumlvQuantity(double cumlvAmtForCurrCumlvQuantity) {
        this.cumlvAmtForCurrCumlvQuantity = cumlvAmtForCurrCumlvQuantity;
    }

    public Date getMbdetailsDate() {
        return this.mbdetailsDate;
    }

    public void setMbdetailsDate(Date mbdetailsDate) {
        this.mbdetailsDate = mbdetailsDate;
    }

    public String getOrderNumber() {
        return this.OrderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.OrderNumber = orderNumber;
    }

    public double getTotalEstQuantity() {
        return this.totalEstQuantity;
    }

    public void setTotalEstQuantity(double totalEstQuantity) {
        this.totalEstQuantity = totalEstQuantity;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public double getRate() {
        return this.rate;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<MBMeasurementSheet> getMeasurementSheets() {
        return this.measurementSheets;
    }

    public void setMeasurementSheets(List<MBMeasurementSheet> measurementSheets) {
        this.measurementSheets = measurementSheets;
    }

    public void addMBMeasurementSheet(MBMeasurementSheet mbMeasurementSheet) {
        this.measurementSheets.add(mbMeasurementSheet);
    }
}

