/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.master.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.persistence.entity.component.Money;
import org.egov.infra.persistence.entity.component.Period;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQueryHQL;
import org.egov.works.master.repository.ScheduleOfRateRepository;
import org.egov.works.models.masters.MarketRate;
import org.egov.works.models.masters.SORRate;
import org.egov.works.models.masters.ScheduleOfRate;
import org.egov.works.services.WorksService;
import org.egov.works.uploadsor.UploadScheduleOfRate;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ScheduleOfRateService {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private ScheduleOfRateRepository scheduleOfRateRepository;
    @Autowired
    private WorksService worksService;
    @Autowired
    private UserService userService;

    public ScheduleOfRate getScheduleOfRateById(Long scheduleOfRateId) {
        ScheduleOfRate scheduleOfRate = (ScheduleOfRate)((Object)this.entityManager.find(ScheduleOfRate.class, (Object)scheduleOfRateId));
        return scheduleOfRate;
    }

    public List<ScheduleOfRate> getAllScheduleOfRates() {
        Query query = this.entityManager.createQuery("from ScheduleOfRate sor order by code asc");
        List scheduleOfRateList = query.getResultList();
        return scheduleOfRateList;
    }

    public List getAllAbstractEstimateByScheduleOrRateId(Long scheduleOfRateId) {
        Query query = this.entityManager.createQuery("select ae from AbstractEstimate ae, Activity act where act.abstractEstimate = ae and act.abstractEstimate.parent is null and act.abstractEstimate.egwStatus.code <> 'CANCELLED' and act.schedule.id = :scheduleOfRateId");
        query.setParameter("scheduleOfRateId", (Object)scheduleOfRateId);
        List list = query.getResultList();
        return list;
    }

    public List getAllWorkOrderEstimateByScheduleOfRateId(Long scheduleOfRateId) {
        Query query = this.entityManager.createQuery("select distinct(woa.workOrderEstimate) from WorkOrderActivity woa where woa.workOrderEstimate.estimate.parent.id is not null and woa.workOrderEstimate.estimate.egwStatus.code<> 'CANCELLED' and exists (select sor.id from ScheduleOfRate sor where sor.id = woa.activity.schedule.id and sor.id = :scheduleOfRateId )");
        query.setParameter("scheduleOfRateId", (Object)scheduleOfRateId);
        List list = query.getResultList();
        return list;
    }

    public SearchQuery prepareSearchQuery(Long scheduleCategoryId, String code, String description) {
        StringBuffer scheduleOfRateSql = new StringBuffer(100);
        String scheduleOfRateStr = "";
        ArrayList<Object> paramList = new ArrayList<Object>();
        scheduleOfRateSql.append(" from ScheduleOfRate sor where sor.scheduleCategory.id=?");
        paramList.add(scheduleCategoryId);
        if (code != null && !code.equals("")) {
            scheduleOfRateSql.append(" and UPPER(sor.code) like ?");
            paramList.add("%" + code.toUpperCase() + "%");
        }
        if (description != null && !description.equals("")) {
            scheduleOfRateSql.append(" and UPPER(sor.description) like ?");
            paramList.add("%" + description.toUpperCase() + "%");
        }
        scheduleOfRateStr = scheduleOfRateSql.toString();
        String countQuery = "select count(*) " + scheduleOfRateStr;
        return new SearchQueryHQL(scheduleOfRateStr, countQuery, paramList);
    }

    @Transactional
    public ScheduleOfRate save(ScheduleOfRate scheduleOfRate) {
        return (ScheduleOfRate)((Object)this.scheduleOfRateRepository.save((Object)scheduleOfRate));
    }

    public ScheduleOfRate findById(Long id, boolean b) {
        return (ScheduleOfRate)((Object)this.scheduleOfRateRepository.findOne(id));
    }

    public List<ScheduleOfRate> getScheduleOfRatesByCodeAndScheduleOfCategories(String code, String ids, Date estimateDate) {
        String[] split;
        ArrayList<Long> scheduleOfCategoryIds = new ArrayList<Long>();
        for (String s : split = ids.split(",")) {
            scheduleOfCategoryIds.add(Long.parseLong(s));
        }
        if (estimateDate == null) {
            estimateDate = new Date();
        }
        List<ScheduleOfRate> scheduleOfRates = this.scheduleOfRateRepository.findByCodeContainingIgnoreCaseAndScheduleCategory_IdInOrderByCode(code.toUpperCase(), scheduleOfCategoryIds, estimateDate);
        for (ScheduleOfRate rate : scheduleOfRates) {
            rate.setSorRateValue(rate.getRateOn(estimateDate).getRate().getValue());
        }
        return scheduleOfRates;
    }

    public ScheduleOfRate setPrimaryDetails(ScheduleOfRate scheduleOfRate) {
        User user = this.userService.getUserById(this.worksService.getCurrentLoggedInUserId());
        if (scheduleOfRate.getId() == null) {
            scheduleOfRate.setCreatedBy(user);
            scheduleOfRate.setCreatedDate(new Date());
        }
        scheduleOfRate.setModifiedBy(user);
        scheduleOfRate.setModifiedDate(new Date());
        return scheduleOfRate;
    }

    public SORRate setPrimaryDetailsForSorRates(SORRate sorRate) {
        User user = this.userService.getUserById(this.worksService.getCurrentLoggedInUserId());
        sorRate.setCreatedBy(user);
        sorRate.setCreatedDate(new Date());
        sorRate.setModifiedBy(user);
        sorRate.setModifiedDate(new Date());
        return sorRate;
    }

    public MarketRate setPrimaryDetailsForMarketRates(MarketRate marketRate) {
        User user = this.userService.getUserById(this.worksService.getCurrentLoggedInUserId());
        marketRate.setCreatedBy(user);
        marketRate.setCreatedDate(new Date());
        marketRate.setModifiedBy(user);
        marketRate.setModifiedDate(new Date());
        return marketRate;
    }

    public ScheduleOfRate getByCode(String code) {
        return this.scheduleOfRateRepository.findByCode(code);
    }

    public ScheduleOfRate getByCodeAndScheduleCategoryId(String code, Long id) {
        return this.scheduleOfRateRepository.findByCodeAndScheduleCategory_id(code, id);
    }

    @Transactional
    public List<UploadScheduleOfRate> createScheduleOfRate(List<UploadScheduleOfRate> uploadSORRatesList) {
        Date currentDate = new Date();
        for (UploadScheduleOfRate obj : uploadSORRatesList) {
            if (obj.getCreateSor().booleanValue()) {
                ScheduleOfRate scheduleOfRate = new ScheduleOfRate();
                SORRate sorRate = new SORRate();
                MarketRate marketRate = new MarketRate();
                scheduleOfRate.setCode(obj.getSorCode());
                scheduleOfRate.setScheduleCategory(obj.getScheduleCategory());
                scheduleOfRate.setUom(obj.getUom());
                scheduleOfRate.setDescription(obj.getSorDescription());
                sorRate.setRate(new Money(obj.getRate().doubleValue()));
                sorRate.setValidity(new Period(obj.getFromDate(), obj.getToDate() != null ? obj.getToDate() : null));
                sorRate.setScheduleOfRate(scheduleOfRate);
                sorRate.setCreatedBy((User)((Session)this.entityManager.unwrap(Session.class)).load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
                sorRate.setCreatedDate(currentDate);
                sorRate.setModifiedBy((User)((Session)this.entityManager.unwrap(Session.class)).load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
                sorRate.setModifiedDate(currentDate);
                scheduleOfRate.getSorRates().add(sorRate);
                if (obj.getMarketRate() != null) {
                    marketRate.setMarketRate(new Money(obj.getMarketRate().doubleValue()));
                    marketRate.setValidity(new Period(obj.getMarketFromDate(), obj.getMarketToDate() != null ? obj.getMarketToDate() : null));
                    marketRate.setCreatedBy((User)((Session)this.entityManager.unwrap(Session.class)).load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
                    marketRate.setCreatedDate(currentDate);
                    marketRate.setModifiedBy((User)((Session)this.entityManager.unwrap(Session.class)).load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
                    marketRate.setModifiedDate(currentDate);
                    marketRate.setScheduleOfRate(scheduleOfRate);
                    scheduleOfRate.getMarketRates().add(marketRate);
                }
                scheduleOfRate.setCreatedBy((User)((Session)this.entityManager.unwrap(Session.class)).load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
                scheduleOfRate.setCreatedDate(currentDate);
                scheduleOfRate.setModifiedBy((User)((Session)this.entityManager.unwrap(Session.class)).load(User.class, (Serializable)ApplicationThreadLocals.getUserId()));
                scheduleOfRate.setModifiedDate(currentDate);
                this.save(scheduleOfRate);
            }
            obj.setFinalStatus("Success");
        }
        return uploadSORRatesList;
    }
}

