/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.letterofacceptance.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.works.letterofacceptance.repository.WorkOrderActivityRepository;
import org.egov.works.workorder.entity.WorkOrderActivity;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class WorkOrderActivityService {
    @PersistenceContext
    private EntityManager entityManager;
    private final WorkOrderActivityRepository workOrderActivityRepository;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public WorkOrderActivityService(WorkOrderActivityRepository workOrderActivityRepository) {
        this.workOrderActivityRepository = workOrderActivityRepository;
    }

    public WorkOrderActivity getWorkOrderActivityById(Long id) {
        return (WorkOrderActivity)((Object)this.workOrderActivityRepository.findOne(id));
    }

    @Transactional
    public WorkOrderActivity create(WorkOrderActivity workOrderActivity) {
        return (WorkOrderActivity)((Object)this.workOrderActivityRepository.save((Object)workOrderActivity));
    }

    public List<WorkOrderActivity> searchActivities(Long workOrderEstimateId, String description, String itemCode, String sorType) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(WorkOrderActivity.class, "woa").createAlias("woa.workOrderEstimate", "woe").createAlias("activity", "act");
        if (workOrderEstimateId != null) {
            criteria.add((Criterion)Restrictions.eq((String)"woe.id", (Object)workOrderEstimateId));
        }
        if (sorType != null && sorType.equalsIgnoreCase("SOR")) {
            criteria.add(Restrictions.isNotNull((String)"act.schedule"));
        }
        if (sorType != null && sorType.equalsIgnoreCase("Non Sor")) {
            criteria.add(Restrictions.isNull((String)"act.schedule"));
        }
        return criteria.list();
    }
}

