/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.subcategory;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.tl.entity.LicenseCategory;
import org.egov.tl.entity.LicenseSubCategory;
import org.egov.tl.service.masters.LicenseCategoryService;
import org.egov.tl.service.masters.LicenseSubCategoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/licensesubcategory"})
public class SearchSubCategoryController {
    @Autowired
    private LicenseCategoryService licenseCategoryService;
    private final LicenseSubCategoryService licenseSubCategoryService;

    @Autowired
    public SearchSubCategoryController(LicenseSubCategoryService licenseSubCategoryService) {
        this.licenseSubCategoryService = licenseSubCategoryService;
    }

    @ModelAttribute
    public LicenseCategory licenseCategoryModel() {
        return new LicenseCategory();
    }

    @ModelAttribute(value="licenseCategories")
    public List<LicenseCategory> getAllCategories() {
        return this.licenseCategoryService.findAll();
    }

    @ModelAttribute(value="licenseSubCategories")
    public List<LicenseSubCategory> getAllSubCategoryByCategory(Long categoryId) {
        return this.licenseSubCategoryService.findAllSubCategoryByCategory(categoryId);
    }

    @RequestMapping(value={"/subcategories-by-category"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<LicenseSubCategory> getSubcategories(@RequestParam Long categoryId) {
        return this.licenseSubCategoryService.findAllSubCategoryByCategory(categoryId);
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.GET})
    public String updateLicenseSubCategory(@ModelAttribute LicenseSubCategory licenseSubCategory, Model model) {
        return "subcategory-search-update";
    }

    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public String viewLicenseCategory(@ModelAttribute LicenseSubCategory licenseSubCategory, Model model) {
        return "subcategory-search-view";
    }

    @RequestMapping(value={"/view"}, method={RequestMethod.POST})
    public String searchView(@ModelAttribute LicenseSubCategory licenseSubCategory, BindingResult errors, RedirectAttributes redirectAttrs, HttpServletRequest request) {
        if (errors.hasErrors()) {
            return "subcategory-search-view";
        }
        return "redirect:/licensesubcategory/view/" + licenseSubCategory.getCode();
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String searchUpdate(@ModelAttribute LicenseSubCategory licenseSubCategory, BindingResult errors, RedirectAttributes redirectAttrs, HttpServletRequest request) {
        if (errors.hasErrors()) {
            return "subcategory-search-update";
        }
        return "redirect:/licensesubcategory/update/" + licenseSubCategory.getCode();
    }
}

