/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller;

import javax.validation.Valid;
import org.egov.tl.entity.FeeType;
import org.egov.tl.service.FeeTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/feeType"})
public class FeeTypeController {
    private static final String FEETYPE_NEW = "feetype-new";
    private static final String FEETYPE_RESULT = "feetype-result";
    private static final String FEETYPE_EDIT = "feetype-edit";
    private static final String FEETYPE_VIEW = "feetype-view";
    @Autowired
    private FeeTypeService feeTypeService;

    private void prepareForNewForm(Model model) {
        model.addAttribute("feeProcessTypes", (Object)FeeType.FeeProcessType.values());
    }

    @RequestMapping(value={"new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        return FEETYPE_NEW;
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute FeeType feeType, BindingResult errors, Model model) {
        if (errors.hasErrors()) {
            return FEETYPE_RESULT;
        }
        this.feeTypeService.create(feeType);
        return FEETYPE_RESULT;
    }

    @RequestMapping(value={"edit/{id}"}, method={RequestMethod.POST})
    public String edit(@PathVariable(value="id") String id) {
        return FEETYPE_EDIT;
    }

    @RequestMapping(value={"update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute FeeType feeType, BindingResult errors) {
        if (errors.hasErrors()) {
            return FEETYPE_RESULT;
        }
        this.feeTypeService.update(feeType);
        return FEETYPE_RESULT;
    }

    @RequestMapping(value={"view/{id}"}, method={RequestMethod.POST})
    public String view(@PathVariable(value="id") String id) {
        return FEETYPE_VIEW;
    }
}

