/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.web.utils.WebUtils;
import org.egov.infstr.services.PersistenceService;
import org.egov.tl.entity.FeeMatrix;
import org.egov.tl.entity.FeeMatrixDetail;
import org.egov.tl.service.FeeMatrixDetailService;
import org.egov.tl.service.FeeMatrixService;
import org.egov.tl.service.masters.LicenseCategoryService;
import org.egov.tl.web.response.adaptor.FeeMatrixResponseAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/feematrix/"})
public class FeeMatrixController {
    private static final String FEEMATRIX_NEW = "feematrix-new";
    private static final String FEEMATRIX_RESULT = "feematrix-result";
    private static final String FEEMATRIX_EDIT = "feematrix-edit";
    private static final String FEEMATRIX_VIEW = "feematrix-view";
    private static final String FEE_MATRIX_MODEL_ATTRIB_NAME = "feeMatrix";
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private FeeMatrixService feeMatrixService;
    @Autowired
    private FeeMatrixDetailService feeMatrixDetailService;
    @Autowired
    private FinancialYearDAO financialYearDAO;
    @Autowired
    private AppConfigValueService appConfigValueService;
    @Autowired
    private LicenseCategoryService licenseCategoryService;

    private void prepareForNewForm(Model model) {
        List newRenewAppconfigList;
        new ArrayList();
        new ArrayList();
        model.addAttribute("licenseCategorys", (Object)this.licenseCategoryService.findAllOrderByName());
        model.addAttribute("natureOfBusinesss", (Object)this.persistenceService.findAllBy("select n from org.egov.tl.entity.NatureOfBusiness n order by name asc", new Object[0]));
        model.addAttribute("financialYears", (Object)this.financialYearDAO.getAllActiveFinancialYearList());
        List permTempAppconfigList = this.appConfigValueService.getConfigValuesByModuleAndKey("Trade License", "Is Fee For Permanent and Temporary Same");
        if ("Y".equals(((AppConfigValues)permTempAppconfigList.get(0)).getValue())) {
            model.addAttribute("hideTemporary", (Object)true);
        }
        if ("Y".equals(((AppConfigValues)(newRenewAppconfigList = this.appConfigValueService.getConfigValuesByModuleAndKey("Trade License", "Is Fee For New and Renew Same")).get(0)).getValue())) {
            model.addAttribute("hideRenew", (Object)true);
        }
        model.addAttribute(FEE_MATRIX_MODEL_ATTRIB_NAME, (Object)new FeeMatrix());
        model.addAttribute("subCategorys", Collections.emptyList());
        model.addAttribute("feeTypes", Collections.emptyList());
        model.addAttribute("unitOfMeasurements", Collections.emptyList());
        model.addAttribute("licenseAppTypes", (Object)this.persistenceService.findAllBy("select a from LicenseAppType a order by name asc", new Object[0]));
    }

    @RequestMapping(value={"create"}, method={RequestMethod.GET})
    public String newForm(Model model, @RequestParam(required=false) String fee) {
        this.prepareForNewForm(model);
        return FEEMATRIX_NEW;
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute FeeMatrix feeMatrix, BindingResult errors, Model model) {
        if (errors.hasErrors()) {
            return FEEMATRIX_RESULT;
        }
        this.feeMatrixService.create(feeMatrix);
        model.addAttribute(FEE_MATRIX_MODEL_ATTRIB_NAME, (Object)feeMatrix);
        return FEEMATRIX_RESULT;
    }

    @RequestMapping(value={"search"}, method={RequestMethod.GET})
    public String search(@ModelAttribute FeeMatrix feeMatrix, BindingResult errors, Model model) {
        if (errors.hasErrors()) {
            return FEEMATRIX_RESULT;
        }
        FeeMatrix searchfeeMatrix = this.feeMatrixService.search(feeMatrix);
        if (searchfeeMatrix == null) {
            searchfeeMatrix = new FeeMatrix();
        }
        model.addAttribute(FEE_MATRIX_MODEL_ATTRIB_NAME, (Object)searchfeeMatrix);
        return FEEMATRIX_RESULT;
    }

    @RequestMapping(value={"edit/{id}"}, method={RequestMethod.POST})
    public String edit(@PathVariable(value="id") String id) {
        return FEEMATRIX_EDIT;
    }

    @RequestMapping(value={"update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute FeeMatrix feeMatrix, BindingResult errors) {
        if (errors.hasErrors()) {
            return FEEMATRIX_RESULT;
        }
        this.feeMatrixService.update(feeMatrix);
        return FEEMATRIX_RESULT;
    }

    @RequestMapping(value={"view/{id}"}, method={RequestMethod.POST})
    public String view(@PathVariable(value="id") String id) {
        return FEEMATRIX_VIEW;
    }

    @RequestMapping(value={"view-feematrix"}, method={RequestMethod.GET})
    public String viewForm(Model model) {
        model.addAttribute(FEE_MATRIX_MODEL_ATTRIB_NAME, (Object)new FeeMatrix());
        model.addAttribute("financialYears", (Object)this.financialYearDAO.getAllActiveFinancialYearList());
        model.addAttribute("licenseCategorys", (Object)this.licenseCategoryService.findAllOrderByName());
        model.addAttribute("subCategorys", Collections.emptyList());
        return FEEMATRIX_VIEW;
    }

    @RequestMapping(value={"viewresult"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String viewresult(@RequestParam(required=false) Long category, @RequestParam(required=false) Long subCategory, @RequestParam(required=false) Long finyear) {
        return "{ \"data\":" + WebUtils.toJSON((Collection)this.feeMatrixDetailService.searchFeeMatrix(category, subCategory, finyear), FeeMatrixDetail.class, FeeMatrixResponseAdaptor.class) + "}";
    }
}

