/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller;

import java.util.Collection;
import javax.validation.Valid;
import org.egov.infra.web.utils.WebUtils;
import org.egov.tl.entity.LicenseDocumentType;
import org.egov.tl.entity.enums.ApplicationType;
import org.egov.tl.service.DocumentTypeService;
import org.egov.tl.web.response.adaptor.LicenseDocumentTypeResponseAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/documenttype"})
public class DocumentTypeController {
    @Autowired
    private DocumentTypeService documentTypeService;

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String documentTypeForm(@ModelAttribute(value="documenttype") LicenseDocumentType documenttype) {
        return "document-new";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String documentTypeCreate(@Valid @ModelAttribute(value="documenttype") LicenseDocumentType documenttype, BindingResult errors, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return "document-new";
        }
        this.documentTypeService.create(documenttype);
        redirectAttrs.addFlashAttribute("documenttype", (Object)documenttype);
        redirectAttrs.addFlashAttribute("message", (Object)"msg.document.success");
        redirectAttrs.addFlashAttribute("heading", (Object)"msg.heading.success");
        return "redirect:/documenttype/view/" + documenttype.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String documentTypeView(@PathVariable(value="id") Long id, Model model) {
        LicenseDocumentType documenttype = this.documentTypeService.getDocumentTypeById(id);
        model.addAttribute("documenttype", (Object)documenttype);
        return "document-view";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String documentTypeSearch(@ModelAttribute(value="documenttype") LicenseDocumentType documenttype) {
        return "document-search";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String documentTypeSearch(@RequestParam String name, @RequestParam ApplicationType applicationType) {
        return "{ \"data\":" + WebUtils.toJSON((Collection)this.documentTypeService.search(name, applicationType), LicenseDocumentType.class, LicenseDocumentTypeResponseAdaptor.class) + "}";
    }
}

