/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.actions.domain;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.egov.commons.exception.NoSuchObjectException;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.tl.entity.LicenseSubCategory;
import org.egov.tl.entity.LicenseSubCategoryDetails;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.entity.UnitOfMeasurement;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.service.masters.LicenseSubCategoryService;
import org.egov.tl.utils.LicenseUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Results(value={@Result(name={"AJAX_RESULT"}, type="redirectAction", location="returnStream", params={"contentType", "text/plain"}), @Result(name={"ward"}, location="commonAjax-ward.jsp"), @Result(name={"success"}, type="redirectAction", location="CommonTradeLicenseAjaxAction.action"), @Result(name={"subCategory"}, location="commonTradeLicenseAjax-subCategory.jsp"), @Result(name={"populateData"}, location="commonTradeLicenseAjax-autoComplete.jsp")})
@ParentPackage(value="egov")
public class CommonTradeLicenseAjaxAction
extends BaseFormAction
implements ServletResponseAware {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(CommonTradeLicenseAjaxAction.class);
    protected LicenseUtils licenseUtils;
    private int zoneId;
    private List<Boundary> divisionList = new LinkedList();
    private Long categoryId;
    private List<LicenseSubCategory> subCategoryList = new LinkedList();
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private TradeLicenseService tradeLicenseService;
    private LicenseSubCategoryService licenseSubCategoryService;
    public static final String SUBCATEGORY = "subCategory";
    private Long locality;
    private HttpServletResponse response;
    private Long subCategoryId;
    private Long feeTypeId;
    private String searchParamValue;
    private String searchParamType;
    private List<TradeLicense> licenseList = new ArrayList();

    @Action(value="/domain/commonTradeLicenseAjax-populateDivisions")
    public String populateDivisions() {
        try {
            Boundary boundary = this.boundaryService.getBoundaryById(Long.valueOf(this.zoneId));
            String cityName = ((Boundary)this.licenseUtils.getAllCity().get(0)).getName();
            if (!boundary.getName().equals(cityName)) {
                this.divisionList = this.boundaryService.getChildBoundariesByBoundaryId(Long.valueOf(this.zoneId));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("populateDivisions() - Error while loading divisions ." + e.getMessage()));
            this.addFieldError("divisions", "Unable to load division information");
            throw new ApplicationRuntimeException("Unable to load division information", (Throwable)e);
        }
        return "ward";
    }

    @Action(value="/domain/commonTradeLicenseAjax-populateSubCategory")
    public String populateSubCategory() {
        try {
            if (this.categoryId != null) {
                this.subCategoryList = this.licenseSubCategoryService.findAllSubCategoryByCategory(this.categoryId);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("populateSubCategory() - Error while loading subCategory ." + e.getMessage()));
            this.addFieldError(SUBCATEGORY, "Unable to load Sub Category information");
            throw new ApplicationRuntimeException("Unable to load Sub Category information", (Throwable)e);
        }
        return SUBCATEGORY;
    }

    @Action(value="/domain/commonTradeLicenseAjax-blockByLocality")
    public void blockByLocality() throws IOException, NoSuchObjectException {
        LOGGER.debug((Object)("Entered into blockByLocality, locality: " + this.locality));
        Boundary wardBoundary = (Boundary)this.getPersistenceService().find("select CH.parent from CrossHierarchy CH where CH.child.id = ? and CH.parentType.hierarchyType.name= ? and CH.parentType.name=?", new Object[]{this.getLocality(), "REVENUE", "Ward"});
        Boundary zoneBoundary = wardBoundary.getParent();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"zoneName", (Object)zoneBoundary.getName());
        jsonObject.put((Object)"wardName", (Object)wardBoundary.getName());
        jsonObject.put((Object)"wardId", (Object)wardBoundary.getId());
        this.response.setContentType("application/json");
        IOUtils.write((String)jsonObject.toString(), (Writer)this.response.getWriter());
    }

    @Action(value="/domain/commonTradeLicenseAjax-ajaxLoadUomName")
    public void ajaxLoadUomName() throws IOException, NoSuchObjectException {
        LicenseSubCategory subCategory = this.licenseSubCategoryService.findById(this.subCategoryId);
        ArrayList<UnitOfMeasurement> uomList = new ArrayList<UnitOfMeasurement>();
        if (subCategory != null && !subCategory.getLicenseSubCategoryDetails().isEmpty()) {
            for (LicenseSubCategoryDetails scd : subCategory.getLicenseSubCategoryDetails()) {
                if (scd.getFeeType().getId() != this.feeTypeId) continue;
                uomList.add(scd.getUom());
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"uom", (Object)((UnitOfMeasurement)uomList.get(0)).getName());
        this.response.setContentType("application/json");
        IOUtils.write((String)jsonObject.toString(), (Writer)this.response.getWriter());
    }

    @Action(value="/domain/commonTradeLicenseAjax-populateData")
    public String populateData() {
        try {
            if (this.searchParamValue != null) {
                this.licenseList = this.tradeLicenseService.getTradeLicenseForGivenParam(this.searchParamValue, this.searchParamType);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("populateData() - Error while loading Data ." + e.getMessage()));
            throw new ApplicationRuntimeException("Unable to load Data", (Throwable)e);
        }
        return "populateData";
    }

    public Object getModel() {
        return null;
    }

    public HttpServletResponse getServletResponse() {
        return ServletActionContext.getResponse();
    }

    public LicenseUtils getLicenseUtils() {
        return this.licenseUtils;
    }

    public void setLicenseUtils(LicenseUtils licenseUtils) {
        this.licenseUtils = licenseUtils;
    }

    public int getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(int zoneId) {
        this.zoneId = zoneId;
    }

    public List<Boundary> getDivisionList() {
        return this.divisionList;
    }

    public void setDivisionList(List<Boundary> divisionList) {
        this.divisionList = divisionList;
    }

    public Long getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public List<LicenseSubCategory> getSubCategoryList() {
        return this.subCategoryList;
    }

    public void setSubCategoryList(List<LicenseSubCategory> subCategoryList) {
        this.subCategoryList = subCategoryList;
    }

    public Long getLocality() {
        return this.locality;
    }

    public void setLocality(Long locality) {
        this.locality = locality;
    }

    public void setServletResponse(HttpServletResponse httpServletResponse) {
        this.response = httpServletResponse;
    }

    public void setLicenseSubCategoryService(LicenseSubCategoryService licenseSubCategoryService) {
        this.licenseSubCategoryService = licenseSubCategoryService;
    }

    public LicenseSubCategoryService getLicenseSubCategoryService() {
        return this.licenseSubCategoryService;
    }

    public Long getSubCategoryId() {
        return this.subCategoryId;
    }

    public void setSubCategoryId(Long subCategoryId) {
        this.subCategoryId = subCategoryId;
    }

    public Long getFeeTypeId() {
        return this.feeTypeId;
    }

    public void setFeeTypeId(Long feeTypeId) {
        this.feeTypeId = feeTypeId;
    }

    public List<TradeLicense> getLicenseList() {
        return this.licenseList;
    }

    public void setLicenseList(List<TradeLicense> licenseList) {
        this.licenseList = licenseList;
    }

    public String getSearchParamType() {
        return this.searchParamType;
    }

    public void setSearchParamType(String searchParamType) {
        this.searchParamType = searchParamType;
    }

    public String getSearchParamValue() {
        return this.searchParamValue;
    }

    public void setSearchParamValue(String searchParamValue) {
        this.searchParamValue = searchParamValue;
    }
}

