/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.web.controller.uom;

import javax.validation.Valid;
import org.egov.tl.entity.UnitOfMeasurement;
import org.egov.tl.service.masters.UnitOfMeasurementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/licenseunitofmeasurement"})
public class UpdateLicenseUomController {
    private final UnitOfMeasurementService unitOfMeasurementService;

    @Autowired
    public UpdateLicenseUomController(UnitOfMeasurementService unitOfMeasurementService) {
        this.unitOfMeasurementService = unitOfMeasurementService;
    }

    @ModelAttribute
    public UnitOfMeasurement unitOfMeasurementModel(@PathVariable String code) {
        return this.unitOfMeasurementService.findUOMByCode(code);
    }

    @RequestMapping(value={"/update/{code}"}, method={RequestMethod.GET})
    public String categoryUpdateForm(@ModelAttribute @Valid UnitOfMeasurement unitOfMeasurement, Model model) {
        return "uom-update";
    }

    @RequestMapping(value={"/update/{code}"}, method={RequestMethod.POST})
    public String updateCategory(@ModelAttribute @Valid UnitOfMeasurement unitOfMeasurement, BindingResult errors, RedirectAttributes additionalAttr) {
        if (errors.hasErrors()) {
            return "uom-update";
        }
        this.unitOfMeasurementService.persistUnitOfMeasurement(unitOfMeasurement);
        additionalAttr.addFlashAttribute("message", (Object)"msg.success.uom.update");
        return "redirect:/licenseunitofmeasurement/view/" + unitOfMeasurement.getCode();
    }
}

