/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service.integration;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.Installment;
import org.egov.demand.interfaces.LatePayPenaltyCalculator;
import org.egov.demand.model.AbstractBillable;
import org.egov.demand.model.EgBillType;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.admin.master.entity.Module;
import org.egov.tl.entity.License;
import org.egov.tl.service.PenaltyRatesService;
import org.joda.time.LocalDate;

public class LicenseBill
extends AbstractBillable
implements LatePayPenaltyCalculator {
    public static final String DEFAULT_FUNCTIONARY_CODE = "1";
    private License license;
    private String moduleName;
    private String serviceCode;
    private String referenceNumber;
    private String departmentCode;
    private Boolean isCallbackForApportion = Boolean.FALSE;
    private Long userId;
    private Module module;
    private EgBillType billType;
    private PenaltyRatesService penaltyRatesService;

    public License getLicense() {
        return this.license;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    public void setPenaltyRatesService(PenaltyRatesService penaltyRatesService) {
        this.penaltyRatesService = penaltyRatesService;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getConsumerType() {
        return this.moduleName;
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public String getBillPayee() {
        return this.license.getLicensee().getApplicantName();
    }

    public String getEmailId() {
        return "";
    }

    public String getBillAddress() {
        return this.license.getLicensee().getAddress() + "\nPh : " + StringUtils.defaultIfBlank((String)this.license.getLicensee().getMobilePhoneNumber(), (String)"NA");
    }

    public EgDemand getCurrentDemand() {
        return this.license.getCurrentDemand();
    }

    public List<EgDemand> getAllDemands() {
        return Arrays.asList(new EgDemand[]{this.license.getLicenseDemand()});
    }

    public EgBillType getBillType() {
        return this.billType;
    }

    public void setBillType(EgBillType billType) {
        this.billType = billType;
    }

    public Date getBillLastDueDate() {
        return new LocalDate().plusMonths(1).toDate();
    }

    public Long getBoundaryNum() {
        return this.license.getBoundary().getId();
    }

    public String getBoundaryType() {
        return this.license.getBoundary().getBoundaryType().getName();
    }

    public String getDepartmentCode() {
        return this.departmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }

    public BigDecimal getFunctionaryCode() {
        return new BigDecimal(DEFAULT_FUNCTIONARY_CODE);
    }

    public String getFundCode() {
        return "01";
    }

    public String getFundSourceCode() {
        return "01";
    }

    public Date getIssueDate() {
        return new Date();
    }

    public Date getLastDate() {
        return this.getBillLastDueDate();
    }

    public Boolean getOverrideAccountHeadsAllowed() {
        return false;
    }

    public Boolean getPartPaymentAllowed() {
        return false;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }

    public void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    public BigDecimal getTotalAmount() {
        return this.license.getTotalBalance();
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getDescription() {
        return StringUtils.isBlank((String)this.license.getLicenseNumber()) ? "Application No : " + this.license.getApplicationNumber() : "License No : " + this.license.getLicenseNumber();
    }

    public String getDisplayMessage() {
        return this.moduleName + " Collection";
    }

    public String getCollModesNotAllowed() {
        return "";
    }

    public Boolean isCallbackForApportion() {
        return this.isCallbackForApportion;
    }

    public void setCallbackForApportion(Boolean b) {
        this.isCallbackForApportion = b;
    }

    public BigDecimal getLPPPercentage() {
        return BigDecimal.ZERO;
    }

    public LatePayPenaltyCalculator.LPPenaltyCalcType getLPPenaltyCalcType() {
        return null;
    }

    public void setPenaltyCalcType(LatePayPenaltyCalculator.LPPenaltyCalcType penaltyType) {
    }

    public String getConsumerId() {
        return StringUtils.defaultIfBlank((String)this.license.getLicenseNumber(), (String)this.license.getApplicationNumber());
    }

    public BigDecimal calculateLPPenaltyForPeriod(Date fromDate, Date toDate, BigDecimal amount) {
        return null;
    }

    public BigDecimal calculatePenalty(Date commencementDate, Date collectionDate, BigDecimal amount) {
        return this.penaltyRatesService.calculatePenalty(this.license, commencementDate, collectionDate, amount);
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public String getTransanctionReferenceNumber() {
        return "";
    }

    public Map<Installment, BigDecimal> getCalculatedPenalty(Date fromDate, Date collectionDate, EgDemand demand) {
        HashMap<Installment, BigDecimal> installmentPenalty = new HashMap<Installment, BigDecimal>();
        for (EgDemandDetails demandDetails : demand.getEgDemandDetails()) {
            if (demandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equals("Penalty") || demandDetails.getAmount().subtract(demandDetails.getAmtCollected()).signum() != 1) continue;
            if (fromDate != null) {
                installmentPenalty.put(demandDetails.getEgDemandReason().getEgInstallmentMaster(), this.calculatePenalty(fromDate, collectionDate, demandDetails.getAmount()));
                continue;
            }
            installmentPenalty.put(demandDetails.getEgDemandReason().getEgInstallmentMaster(), this.calculatePenalty(demandDetails.getEgDemandReason().getEgInstallmentMaster().getFromDate(), collectionDate, demandDetails.getAmount()));
        }
        return installmentPenalty;
    }
}

