/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.utils.DateUtils;
import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseAppType;
import org.egov.tl.entity.PenaltyRates;
import org.egov.tl.repository.PenaltyRatesRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PenaltyRatesService {
    @Autowired
    private PenaltyRatesRepository penaltyRatesRepository;

    public PenaltyRates findByDaysAndLicenseAppType(Integer days, LicenseAppType licenseAppType) {
        return this.penaltyRatesRepository.findByDaysAndLicenseAppType((long)days, licenseAppType);
    }

    public PenaltyRates findOne(Long id) {
        return (PenaltyRates)((Object)this.penaltyRatesRepository.findOne(id));
    }

    @Transactional
    public List<PenaltyRates> create(List<PenaltyRates> penaltyRates) {
        return this.penaltyRatesRepository.save(penaltyRates);
    }

    @ReadOnly
    public List<PenaltyRates> search(Long licenseAppType) {
        return licenseAppType != null ? this.penaltyRatesRepository.findByLicenseAppTypeIdOrderByIdAsc(licenseAppType) : this.penaltyRatesRepository.findAll();
    }

    @Transactional
    public void delete(PenaltyRates penaltyRates) {
        this.penaltyRatesRepository.delete((Object)penaltyRates);
    }

    public BigDecimal calculatePenalty(License license, Date fromDate, Date toDate, BigDecimal amount) {
        if (fromDate != null) {
            int paymentDueDays = DateUtils.daysBetween((Date)fromDate, (Date)toDate);
            PenaltyRates penaltyRates = this.findByDaysAndLicenseAppType(paymentDueDays, license.getLicenseAppType());
            if (penaltyRates == null) {
                return BigDecimal.ZERO;
            }
            return amount.multiply(BigDecimal.valueOf(penaltyRates.getRate() / 100.0));
        }
        return BigDecimal.ZERO;
    }
}

