/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentHibDao;
import org.egov.demand.dao.DemandGenericHibDao;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseDemand;
import org.egov.tl.entity.LicenseDocument;
import org.egov.tl.entity.LicenseDocumentType;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.repository.LicenseDocumentTypeRepository;
import org.egov.tl.repository.LicenseRepository;
import org.egov.tl.service.LicenseAppTypeService;
import org.egov.tl.service.LicenseStatusService;
import org.egov.tl.service.TradeLicenseService;
import org.egov.tl.service.ValidityService;
import org.egov.tl.utils.LicenseNumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class LegacyLicenseService {
    @Autowired
    private LicenseRepository licenseRepository;
    @Autowired
    private LicenseStatusService licenseStatusService;
    @Autowired
    private LicenseNumberUtils licenseNumberUtils;
    @Autowired
    private ValidityService validityService;
    @Autowired
    private DemandGenericHibDao demandGenericDao;
    @Autowired
    private InstallmentHibDao installmentDao;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private LicenseAppTypeService licenseAppTypeService;
    @Autowired
    private LicenseDocumentTypeRepository licenseDocumentTypeRepository;
    @Autowired
    private TradeLicenseService tradeLicenseService;
    @Autowired
    private FileStoreService fileStoreService;

    private static <K extends Comparable<? super K>, V> Map<K, V> sortByKey(Map<K, V> map) {
        LinkedHashMap result = new LinkedHashMap();
        Stream mapInStream = map.entrySet().stream();
        mapInStream.sorted(Map.Entry.comparingByKey()).forEachOrdered(x -> result.put(x.getKey(), x.getValue()));
        return result;
    }

    @Transactional
    public void createLegacy(TradeLicense license) {
        this.addLegacyDemand(license);
        license.setLicenseAppType(this.licenseAppTypeService.getLicenseAppTypeByName("New"));
        license.getLicensee().setLicense(license);
        license.setStatus(this.licenseStatusService.getLicenseStatusByName("Active"));
        license.setApplicationNumber(this.licenseNumberUtils.generateApplicationNumber());
        license.setLegacy(true);
        license.setActive(true);
        license.setLicenseNumber(this.licenseNumberUtils.generateLicenseNumber());
        this.validityService.applyLicenseValidity(license);
        this.licenseRepository.save((Object)license);
    }

    @Transactional
    public void updateLegacy(TradeLicense license) {
        this.updateLegacyDemand(license);
        this.validityService.applyLicenseValidity(license);
        this.licenseRepository.save((Object)license);
    }

    public Map<Integer, Integer> legacyInstallmentwiseFeesForCreate() {
        LinkedHashMap<Integer, Integer> legacyInstallmentwiseFees = new LinkedHashMap<Integer, Integer>();
        for (Installment installment : this.tradeLicenseService.getLastFiveYearInstallmentsForLicense()) {
            legacyInstallmentwiseFees.put(installment.getInstallmentNumber(), 0);
        }
        return legacyInstallmentwiseFees;
    }

    public Map<Integer, Integer> legacyInstallmentwiseFees(TradeLicense license) {
        Map<Integer, Integer> legacyInstallmentwiseFees = this.legacyInstallmentwiseFeesForCreate();
        for (EgDemandDetails demandDetail : license.getCurrentDemand().getEgDemandDetails()) {
            legacyInstallmentwiseFees.put(demandDetail.getEgDemandReason().getEgInstallmentMaster().getInstallmentNumber(), demandDetail.getAmount().intValue());
        }
        return LegacyLicenseService.sortByKey(legacyInstallmentwiseFees);
    }

    public Map<Integer, Boolean> legacyFeePayStatusForCreate() {
        LinkedHashMap<Integer, Boolean> legacyFeePayStatus = new LinkedHashMap<Integer, Boolean>();
        for (Installment installment : this.tradeLicenseService.getLastFiveYearInstallmentsForLicense()) {
            legacyFeePayStatus.put(installment.getInstallmentNumber(), false);
        }
        return legacyFeePayStatus;
    }

    public Map<Integer, Boolean> legacyFeePayStatus(TradeLicense license) {
        Map<Integer, Boolean> legacyFeePayStatus = this.legacyFeePayStatusForCreate();
        for (EgDemandDetails demandDetail : license.getCurrentDemand().getEgDemandDetails()) {
            legacyFeePayStatus.put(demandDetail.getEgDemandReason().getEgInstallmentMaster().getInstallmentNumber(), demandDetail.getAmtCollected().compareTo(BigDecimal.ZERO) != 0 && demandDetail.getAmtCollected().compareTo(demandDetail.getAmount()) == 0);
        }
        return LegacyLicenseService.sortByKey(legacyFeePayStatus);
    }

    private Map<Integer, Integer> legacyInstallmentfee(TradeLicense license) {
        List<String> installmentYears = license.getFinancialyear();
        List<String> installmentFees = license.getLegacyInstallmentwiseFees();
        LinkedHashMap<Integer, Integer> legacyInstallmentwiseFees = new LinkedHashMap<Integer, Integer>();
        for (int i = 0; i < installmentYears.size(); ++i) {
            if (installmentFees.get(i) == null) {
                installmentFees.set(i, "0");
            }
            legacyInstallmentwiseFees.put(Integer.valueOf(installmentYears.get(i)), Integer.valueOf(installmentFees.get(i)));
        }
        return legacyInstallmentwiseFees;
    }

    private Map<Integer, Boolean> legacyFeeStatus(TradeLicense license) {
        List<String> legacyFeePaymentStatus = license.getLegacyFeePayStatus();
        List<String> installmentYears = license.getFinancialyear();
        LinkedHashMap<Integer, Boolean> legacyFeePayStatus = new LinkedHashMap<Integer, Boolean>();
        for (int i = 0; i < installmentYears.size(); ++i) {
            if (legacyFeePaymentStatus.size() - 1 < i) {
                legacyFeePaymentStatus.add("false");
            } else if (StringUtils.isNotBlank((CharSequence)legacyFeePaymentStatus.get(i))) {
                legacyFeePaymentStatus.set(i, "true");
            } else {
                legacyFeePaymentStatus.set(i, "false");
            }
            legacyFeePayStatus.put(Integer.valueOf(installmentYears.get(i)), Boolean.valueOf(legacyFeePaymentStatus.get(i)));
        }
        return legacyFeePayStatus;
    }

    private void addLegacyDemand(TradeLicense license) {
        Map<Integer, Integer> legacyInstallmentwiseFees = this.legacyInstallmentfee(license);
        Map<Integer, Boolean> legacyFeePayStatus = this.legacyFeeStatus(license);
        LicenseDemand licenseDemand = new LicenseDemand();
        licenseDemand.setIsHistory("N");
        licenseDemand.setCreateDate(new Date());
        licenseDemand.setModifiedDate(new Date());
        licenseDemand.setLicense(license);
        licenseDemand.setIsLateRenewal('0');
        Module module = this.moduleService.getModuleByName("Trade License");
        for (Map.Entry<Integer, Integer> legacyInstallmentwiseFee : legacyInstallmentwiseFees.entrySet()) {
            if (legacyInstallmentwiseFee.getValue() == null || legacyInstallmentwiseFee.getValue() <= 0) continue;
            Installment installment = this.installmentDao.fetchInstallmentByModuleAndInstallmentNumber(module, legacyInstallmentwiseFee.getKey());
            licenseDemand.setEgInstallmentMaster(installment);
            BigDecimal demandAmount = BigDecimal.valueOf(legacyInstallmentwiseFee.getValue().intValue()).setScale(0, RoundingMode.HALF_UP);
            BigDecimal amtCollected = legacyFeePayStatus.get(legacyInstallmentwiseFee.getKey()) == null || legacyFeePayStatus.get(legacyInstallmentwiseFee.getKey()) == false ? BigDecimal.ZERO : demandAmount;
            licenseDemand.getEgDemandDetails().add(EgDemandDetails.fromReasonAndAmounts((BigDecimal)demandAmount, (EgDemandReason)this.demandGenericDao.getDmdReasonByDmdReasonMsterInstallAndMod(this.demandGenericDao.getDemandReasonMasterByCode("License Fee", module), installment, module), (BigDecimal)amtCollected));
            licenseDemand.setBaseDemand(demandAmount.add(licenseDemand.getBaseDemand()).setScale(0, RoundingMode.HALF_UP));
            licenseDemand.setAmtCollected(amtCollected.add(licenseDemand.getAmtCollected()).setScale(0, RoundingMode.HALF_UP));
        }
        license.setLicenseDemand(licenseDemand);
    }

    private void updateLegacyDemand(TradeLicense license) {
        Map<Integer, Integer> updatedInstallmentFees = this.legacyInstallmentfee(license);
        Map<Integer, Boolean> legacyFeePayStatus = this.legacyFeeStatus(license);
        LicenseDemand licenseDemand = license.getCurrentDemand();
        Iterator demandDetails = licenseDemand.getEgDemandDetails().iterator();
        while (demandDetails.hasNext()) {
            EgDemandDetails demandDetail = (EgDemandDetails)demandDetails.next();
            Integer installmentNumber = demandDetail.getEgDemandReason().getEgInstallmentMaster().getInstallmentNumber();
            Integer updatedFee = updatedInstallmentFees.get(installmentNumber);
            Boolean feePaymentStatus = legacyFeePayStatus.get(installmentNumber);
            if (updatedFee != null) {
                BigDecimal updatedDemandAmt = BigDecimal.valueOf(updatedFee.intValue()).setScale(0, RoundingMode.HALF_UP);
                demandDetail.setAmount(updatedDemandAmt);
                if (feePaymentStatus != null && feePaymentStatus.booleanValue()) {
                    demandDetail.setAmtCollected(updatedDemandAmt);
                } else {
                    demandDetail.setAmtCollected(BigDecimal.ZERO);
                }
            } else {
                demandDetails.remove();
            }
            updatedInstallmentFees.put(installmentNumber, 0);
        }
        this.updateNewLegacyDemand(updatedInstallmentFees, legacyFeePayStatus, licenseDemand);
    }

    private void updateNewLegacyDemand(Map<Integer, Integer> updatedInstallmentFees, Map<Integer, Boolean> legacyFeePayStatus, LicenseDemand licenseDemand) {
        Module module = this.moduleService.getModuleByName("Trade License");
        for (Map.Entry<Integer, Integer> updatedInstallmentFee : updatedInstallmentFees.entrySet()) {
            if (updatedInstallmentFee.getValue() == null || updatedInstallmentFee.getValue() <= 0) continue;
            Installment installment = this.installmentDao.fetchInstallmentByModuleAndInstallmentNumber(module, updatedInstallmentFee.getKey());
            BigDecimal demandAmount = BigDecimal.valueOf(updatedInstallmentFee.getValue().intValue()).setScale(0, RoundingMode.HALF_UP);
            BigDecimal amtCollected = legacyFeePayStatus.get(updatedInstallmentFee.getKey()) == null || legacyFeePayStatus.get(updatedInstallmentFee.getKey()) == false ? BigDecimal.ZERO : demandAmount;
            licenseDemand.getEgDemandDetails().add(EgDemandDetails.fromReasonAndAmounts((BigDecimal)demandAmount, (EgDemandReason)this.demandGenericDao.getDmdReasonByDmdReasonMsterInstallAndMod(this.demandGenericDao.getDemandReasonMasterByCode("License Fee", module), installment, module), (BigDecimal)amtCollected));
        }
        licenseDemand.recalculateBaseDemand();
    }

    public void storeDocument(License license, MultipartFile[] files) throws IOException {
        List<LicenseDocument> documents = license.getDocuments();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                documents.get(i).setType((LicenseDocumentType)((Object)this.licenseDocumentTypeRepository.findOne(documents.get(i).getType().getId())));
                if (!files[i].isEmpty()) {
                    documents.get(i).getFiles().add(this.fileStoreService.store(files[i].getInputStream(), files[i].getOriginalFilename(), files[i].getContentType(), "EGTL"));
                    documents.get(i).setEnclosed(true);
                } else if (documents.get(i).getType().isMandatory() && files[i].isEmpty() && documents.isEmpty()) {
                    documents.get(i).getFiles().clear();
                    throw new ValidationException("TL-011", "File should not be Empty", new String[]{documents.get(i).getType().getName()});
                }
                documents.get(i).setDocDate(license.getApplicationDate());
                documents.get(i).setLicense(license);
            }
        }
    }
}

