/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.tl.entity.dto.DCBReportSearchRequest;
import org.egov.tl.entity.view.DCBReportResult;
import org.egov.tl.repository.DCBReportRepository;
import org.egov.tl.repository.specs.DCBReportSpec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DCBReportService {
    @Autowired
    private DCBReportRepository dCBReportRepository;

    @ReadOnly
    public Page<DCBReportResult> pagedDCBRecords(DCBReportSearchRequest searchRequest) {
        PageRequest pageable = new PageRequest(searchRequest.pageNumber(), searchRequest.pageSize(), searchRequest.orderDir(), new String[]{searchRequest.orderBy()});
        return StringUtils.isBlank((CharSequence)searchRequest.getLicensenumber()) ? this.dCBReportRepository.findAll((Pageable)pageable) : this.dCBReportRepository.findAll(DCBReportSpec.dCBReportSpecification(searchRequest), (Pageable)pageable);
    }

    @ReadOnly
    public List<DCBReportResult> getAllDCBRecords(DCBReportSearchRequest searchRequest) {
        return this.dCBReportRepository.findAll(DCBReportSpec.dCBReportSpecification(searchRequest));
    }

    @ReadOnly
    public Object[] dcbGrandTotal(DCBReportSearchRequest searchRequest) {
        return this.dCBReportRepository.findByBaseRegisterRequest(searchRequest);
    }
}

