/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.commons.EgwStatus;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.HierarchyType;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.admin.master.service.HierarchyTypeService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseStatus;
import org.egov.tl.entity.LicenseSubCategory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class LicenseUtils {
    public static final String ADMIN_HIERARCHY_TYPE = "ADMINISTRATION";
    private static final String CITY_BOUNDARY_TYPE = "City";
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private BoundaryTypeService boundaryTypeService;
    @Autowired
    private HierarchyTypeService hierarchyTypeService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private AppConfigValueService appConfigValuesService;

    public Module getModule(String moduleName) {
        return this.moduleService.getModuleByName(moduleName);
    }

    public List<Boundary> getAllCity() {
        HierarchyType hType = this.hierarchyTypeService.getHierarchyTypeByName(ADMIN_HIERARCHY_TYPE);
        BoundaryType bType = this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyType(CITY_BOUNDARY_TYPE, hType);
        return this.boundaryService.getAllBoundariesByBoundaryTypeId(bType.getId());
    }

    public List<LicenseSubCategory> getAllTradeNames(String simpleName) {
        return this.persistenceService.findAllBy("from org.egov.tl.entity.LicenseSubCategory where licenseType.name=?", new Object[]{simpleName});
    }

    public LicenseStatus getLicenseStatusbyCode(String statusCode) {
        return (LicenseStatus)((Object)this.persistenceService.find("FROM org.egov.tl.entity.LicenseStatus where statusCode=?", new Object[]{statusCode}));
    }

    public List<Department> getAllDepartments() {
        return this.departmentService.getAllDepartments();
    }

    public Installment getCurrInstallment(Module module) {
        return this.installmentDao.getInsatllmentByModuleForGivenDate(module, new Date());
    }

    public Boolean isDigitalSignEnabled() {
        AppConfigValues appConfigValue = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Trade License", "DIGITALSIGNINCLUDEINWORKFLOW").get(0);
        return "YES".equalsIgnoreCase(appConfigValue.getValue());
    }

    public String getDepartmentCodeForBillGenerate() {
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Trade License", "DEPARTMENTFORGENERATEBILL");
        return !appConfigValue.isEmpty() ? ((AppConfigValues)appConfigValue.get(0)).getValue() : "";
    }

    public Position getCityLevelCommissioner() {
        Department deptObj = this.departmentService.getDepartmentByName("Health");
        Designation desgnObj = this.designationService.getDesignationByName("Commissioner");
        List assignlist = new ArrayList();
        if (deptObj != null) {
            assignlist = this.assignmentService.getAssignmentsByDeptDesigAndDates(deptObj.getId(), desgnObj.getId(), new Date(), new Date());
        }
        if (assignlist.isEmpty()) {
            assignlist = this.assignmentService.getAllPositionsByDepartmentAndDesignationForGivenRange(null, desgnObj.getId(), new Date());
        }
        if (assignlist.isEmpty()) {
            assignlist = this.assignmentService.getAllActiveAssignments(desgnObj.getId());
        }
        return !assignlist.isEmpty() ? ((Assignment)assignlist.get(0)).getPosition() : null;
    }

    public License applicationStatusChange(License licenseObj, String code) {
        EgwStatus statusChange = (EgwStatus)this.persistenceService.find("from org.egov.commons.EgwStatus where moduletype=? and code=?", new Object[]{"TRADELICENSE", code});
        licenseObj.setEgwStatus(statusChange);
        return licenseObj;
    }
}

