/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service.masters;

import java.util.List;
import org.egov.infstr.services.PersistenceService;
import org.egov.tl.entity.LicenseSubCategory;
import org.egov.tl.entity.LicenseSubCategoryDetails;
import org.egov.tl.entity.LicenseType;
import org.egov.tl.repository.LicenseSubCategoryRepository;
import org.egov.tl.service.FeeTypeService;
import org.egov.tl.service.masters.LicenseCategoryService;
import org.egov.tl.service.masters.UnitOfMeasurementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class LicenseSubCategoryService {
    @Autowired
    private LicenseSubCategoryRepository licenseSubCategoryRepository;
    @Autowired
    private LicenseCategoryService licenseCategoryService;
    @Autowired
    @Qualifier(value="entityQueryService")
    private PersistenceService entityQueryService;
    @Autowired
    private FeeTypeService feeTypeService;
    @Autowired
    private UnitOfMeasurementService unitOfMeasurementService;

    @Transactional
    public LicenseSubCategory create(LicenseSubCategory subCategory, List<LicenseSubCategoryDetails> details, Long categoryId) {
        if (categoryId != null) {
            subCategory.setCategory(this.licenseCategoryService.findById(categoryId));
        }
        LicenseType licenseType = (LicenseType)((Object)this.entityQueryService.find("from org.egov.tl.entity.LicenseType where name=?", new Object[]{"TradeLicense"}));
        subCategory.setLicenseType(licenseType);
        for (LicenseSubCategoryDetails scDetails : details) {
            if (scDetails == null) continue;
            scDetails.setSubCategory(subCategory);
            scDetails.setFeeType(this.feeTypeService.findById(scDetails.getFeeType().getId()));
            scDetails.setRateType(scDetails.getRateType());
            scDetails.setUom(this.unitOfMeasurementService.findById(scDetails.getUom().getId()));
            subCategory.addLicenseSubCategoryDetails(scDetails);
        }
        return (LicenseSubCategory)((Object)this.licenseSubCategoryRepository.save((Object)subCategory));
    }

    public List<LicenseSubCategory> findAllSubCategoryByCategory(Long categoryId) {
        return this.licenseSubCategoryRepository.findAllByCategoryId(categoryId);
    }

    public LicenseSubCategory findSubCategoryByName(String name) {
        return this.licenseSubCategoryRepository.findByName(name);
    }

    public LicenseSubCategory findSubCategoryByCode(String code) {
        return this.licenseSubCategoryRepository.findByCode(code);
    }

    public LicenseSubCategory findById(Long subCategoryId) {
        return this.licenseSubCategoryRepository.findOne(subCategoryId);
    }

    public List<LicenseSubCategory> findAll() {
        return this.licenseSubCategoryRepository.findAll();
    }
}

