/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.egov.eis.entity.Assignment;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseAppType;
import org.egov.tl.entity.LicenseDemand;
import org.egov.tl.entity.LicenseStatus;
import org.egov.tl.entity.NatureOfBusiness;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.entity.WorkflowBean;
import org.egov.tl.service.AbstractLicenseService;
import org.egov.tl.service.TradeLicenseSmsAndEmailService;
import org.egov.tl.utils.LicenseUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class TradeLicenseService
extends AbstractLicenseService<TradeLicense> {
    @Autowired
    private TradeLicenseSmsAndEmailService tradeLicenseSmsAndEmailService;
    @Autowired
    private ReportService reportService;
    @Autowired
    private LicenseUtils licenseUtils;

    @Override
    protected NatureOfBusiness getNatureOfBusiness() {
        NatureOfBusiness natureOfBusiness = (NatureOfBusiness)((Object)this.entityQueryService.find("from org.egov.tl.entity.NatureOfBusiness where   name='Permanent'"));
        return natureOfBusiness;
    }

    @Override
    protected Module getModuleName() {
        Module module = (Module)this.entityQueryService.find("from org.egov.infra.admin.master.entity.Module where parentModule is null and name=?", new Object[]{"Trade License"});
        return module;
    }

    @Override
    protected void sendEmailAndSMS(TradeLicense license, String currentAction) {
        this.tradeLicenseSmsAndEmailService.sendSmsAndEmail(license, currentAction);
    }

    @Override
    protected Assignment getWorkflowInitiator(TradeLicense license) {
        Assignment wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(license.getCreatedBy().getId());
        return wfInitiator;
    }

    @Override
    protected LicenseAppType getLicenseApplicationTypeForRenew() {
        LicenseAppType appType = (LicenseAppType)((Object)this.entityQueryService.find("from org.egov.tl.entity.LicenseAppType where   name='Renew'"));
        return appType;
    }

    @Override
    protected LicenseAppType getLicenseApplicationType() {
        LicenseAppType appType = (LicenseAppType)((Object)this.entityQueryService.find("from org.egov.tl.entity.LicenseAppType where   name='New'"));
        return appType;
    }

    @Transactional
    public void updateTradeLicense(TradeLicense license, WorkflowBean workflowBean) {
        this.licenseRepository.save((Object)license);
        this.tradeLicenseSmsAndEmailService.sendSmsAndEmail(license, workflowBean.getWorkFlowAction());
        this.updateIndexService.updateTradeLicenseIndexes(license);
    }

    @Transactional
    public void updateStatusInWorkFlowProgress(TradeLicense license, String workFlowAction) {
        LicenseStatus activeStatus;
        if ("Approve".equals(workFlowAction)) {
            if (license.getLicenseAppType() != null && !license.getLicenseAppType().getName().equals("Renew")) {
                this.validityService.applyLicenseValidity(license);
                if (license.getTempLicenseNumber() == null) {
                    license.setLicenseNumber(this.licenseNumberUtils.generateLicenseNumber());
                }
            }
            license.setActive(true);
            license = (TradeLicense)this.licenseUtils.applicationStatusChange(license, "COLLECTIONPENDING");
        }
        if ("Approve".equals(workFlowAction) || "Forward".equals(workFlowAction) && license.getState().getValue().contains("Sanitary inspector Approve pending")) {
            activeStatus = (LicenseStatus)((Object)this.entityQueryService.find("from org.egov.tl.entity.LicenseStatus where code='UWF'"));
            license.setStatus(activeStatus);
            if ("Forward".equals(workFlowAction) && license.getEgwStatus() != null && license.getEgwStatus().getCode().equals("CREATED")) {
                license = (TradeLicense)this.licenseUtils.applicationStatusChange(license, "INSPECTIONDONE");
            }
        }
        if ("Generate Certificate".equals(workFlowAction)) {
            activeStatus = (LicenseStatus)((Object)this.entityQueryService.find("from org.egov.tl.entity.LicenseStatus where code='ACT'"));
            license.setStatus(activeStatus);
            license.setLegacy(false);
            license = (TradeLicense)this.licenseUtils.applicationStatusChange(license, "CERTIFICATEGENERATED");
        }
        if ("Reject".equals(workFlowAction) && license.getState().getValue().contains("Rejected")) {
            if (license.getLicenseAppType() != null && license.getLicenseAppType().getName().equals("Renew")) {
                activeStatus = (LicenseStatus)((Object)this.entityQueryService.find("from org.egov.tl.entity.LicenseStatus where code='ACT'"));
                license.setStatus(activeStatus);
            } else {
                activeStatus = (LicenseStatus)((Object)this.entityQueryService.find("from org.egov.tl.entity.LicenseStatus where code='CAN'"));
                license.setStatus(activeStatus);
            }
        }
        if (null != license && null != license.getState() && license.getState().getValue().contains("Sanitary inspector Approve pending")) {
            this.updateDemandForChangeTradeArea(license);
        }
    }

    public ReportRequest prepareReportInputData(License license) {
        Map<String, Object> reportParams = this.getReportParamsForCertificate(license, null, null);
        return new ReportRequest("licenseCertificate", (Object)license, reportParams);
    }

    public ReportOutput prepareReportInputDataForDig(License license, String districtName, String cityMunicipalityName) {
        return this.reportService.createReport(new ReportRequest("licenseCertificate", (Object)license, this.getReportParamsForCertificate(license, districtName, cityMunicipalityName)));
    }

    private Map<String, Object> getReportParamsForCertificate(License license, String districtName, String cityMunicipalityName) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat formatterYear = new SimpleDateFormat("YYYY");
        reportParams.put("applicationnumber", license.getApplicationNumber());
        reportParams.put("applicantName", license.getLicensee().getApplicantName());
        reportParams.put("licencenumber", license.getLicenseNumber());
        reportParams.put("wardName", license.getBoundary().getName());
        reportParams.put("cscNumber", "");
        reportParams.put("nameOfEstablishment", license.getNameOfEstablishment() != null ? license.getNameOfEstablishment() : "");
        reportParams.put("licenceAddress", license.getAddress());
        reportParams.put("municipality", cityMunicipalityName);
        reportParams.put("district", districtName);
        reportParams.put("subCategory", license.getTradeName() != null ? license.getTradeName().getName() : null);
        reportParams.put("appType", license.getLicenseAppType() != null ? (license.getLicenseAppType().getName() != null && license.getLicenseAppType().getName().equals("New") ? "New Trade" : "Renewal") : "New");
        if (ApplicationThreadLocals.getMunicipalityName().contains("Corporation")) {
            reportParams.put("carporationulbType", Boolean.TRUE);
        }
        reportParams.put("municipality", ApplicationThreadLocals.getMunicipalityName());
        LicenseDemand licenseDemand = license.getLicenseDemand();
        String startYear = formatterYear.format((Object)licenseDemand.getEgInstallmentMaster().getFromDate());
        String EndYear = formatterYear.format((Object)licenseDemand.getEgInstallmentMaster().getToDate());
        String installMentYear = startYear + "-" + EndYear;
        reportParams.put("installMentYear", installMentYear);
        reportParams.put("applicationdate", formatter.format(license.getApplicationDate()));
        reportParams.put("demandUpdateDate", formatter.format(license.getCurrentDemand().getModifiedDate()));
        reportParams.put("demandTotalamt", license.getCurrentLicenseFee());
        return reportParams;
    }

    public List<TradeLicense> getTradeLicenseForGivenParam(String paramValue, String paramType) {
        List licenseList = new ArrayList();
        if (paramType.equals("ApplicationNumber")) {
            licenseList = this.entityQueryService.findAllBy("from License where upper(applicationNumber) like ?", new Object[]{"%" + paramValue.toUpperCase() + "%"});
        } else if (paramType.equals("LicenseNumber")) {
            licenseList = this.entityQueryService.findAllBy("from License where  upper(licenseNumber) like ?", new Object[]{"%" + paramValue.toUpperCase() + "%"});
        } else if (paramType.equals("OldLicenseNumber")) {
            licenseList = this.entityQueryService.findAllBy("from License where  upper(oldLicenseNumber) like ?", new Object[]{"%" + paramValue.toUpperCase() + "%"});
        } else if (paramType.equals("TradeTitle")) {
            licenseList = this.entityQueryService.findAllBy("from License where  upper(nameOfEstablishment) like ?", new Object[]{"%" + paramValue.toUpperCase() + "%"});
        } else if (paramType.equals("TradeOwnerName")) {
            licenseList = this.entityQueryService.findAllBy("from License where  upper(licensee.applicantName) like ?", new Object[]{"%" + paramValue.toUpperCase() + "%"});
        } else if (paramType.equals("PropertyAssessmentNo")) {
            licenseList = this.entityQueryService.findAllBy("from License where  upper(assessmentNo) like ?", new Object[]{"%" + paramValue.toUpperCase() + "%"});
        } else if (paramType.equals("MobileNo")) {
            licenseList = this.entityQueryService.findAllBy("from License where  licensee.mobilePhoneNumber like ?", new Object[]{"%" + paramValue + "%"});
        }
        return licenseList;
    }

    public List<TradeLicense> searchTradeLicense(String applicationNumber, String licenseNumber, String oldLicenseNumber, Long categoryId, Long subCategoryId, String tradeTitle, String tradeOwnerName, String propertyAssessmentNo, String mobileNo, Boolean isCancelled) {
        Criteria searchCriteria = this.entityQueryService.getSession().createCriteria(TradeLicense.class);
        searchCriteria.createAlias("licensee", "licc").createAlias("category", "cat").createAlias("tradeName", "subcat").createAlias("status", "licstatus");
        if (StringUtils.isNotBlank((CharSequence)applicationNumber)) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"applicationNumber", (Object)applicationNumber).ignoreCase());
        }
        if (StringUtils.isNotBlank((CharSequence)licenseNumber)) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"licenseNumber", (Object)licenseNumber).ignoreCase());
        }
        if (StringUtils.isNotBlank((CharSequence)oldLicenseNumber)) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"oldLicenseNumber", (Object)oldLicenseNumber).ignoreCase());
        }
        if (categoryId != null && categoryId != -1L) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"cat.id", (Object)categoryId));
        }
        if (subCategoryId != null && subCategoryId != -1L) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"subcat.id", (Object)subCategoryId));
        }
        if (tradeTitle != null && !tradeTitle.isEmpty()) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"nameOfEstablishment", (Object)tradeTitle).ignoreCase());
        }
        if (StringUtils.isNotBlank((CharSequence)tradeOwnerName)) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"licc.applicantName", (Object)tradeOwnerName).ignoreCase());
        }
        if (StringUtils.isNotBlank((CharSequence)propertyAssessmentNo)) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"assessmentNo", (Object)propertyAssessmentNo).ignoreCase());
        }
        if (StringUtils.isNotBlank((CharSequence)mobileNo)) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"licc.mobilePhoneNumber", (Object)mobileNo));
        }
        if (isCancelled != null && isCancelled.equals(Boolean.TRUE)) {
            searchCriteria.add((Criterion)Restrictions.eq((String)"licstatus.statusCode", (Object)StringUtils.upperCase((String)"CAN")));
        } else {
            searchCriteria.add((Criterion)Restrictions.ne((String)"licstatus.statusCode", (Object)StringUtils.upperCase((String)"CAN")));
        }
        searchCriteria.add(Restrictions.isNotNull((String)"applicationNumber"));
        searchCriteria.addOrder(Order.asc((String)"id"));
        return searchCriteria.list();
    }
}

