/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import org.egov.tl.entity.DemandGenerationLog;
import org.egov.tl.entity.DemandGenerationLogDetail;
import org.egov.tl.entity.License;
import org.egov.tl.entity.enums.ProcessStatus;
import org.egov.tl.repository.DemandGenerationLogDetailRepository;
import org.egov.tl.repository.DemandGenerationLogRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DemandGenerationLogService {
    private final DemandGenerationLogRepository demandGenerationLogRepository;
    private final DemandGenerationLogDetailRepository demandGenerationLogDetailRepository;

    @Autowired
    public DemandGenerationLogService(DemandGenerationLogRepository demandGenerationLogRepository, DemandGenerationLogDetailRepository demandGenerationLogDetailRepository) {
        this.demandGenerationLogRepository = demandGenerationLogRepository;
        this.demandGenerationLogDetailRepository = demandGenerationLogDetailRepository;
    }

    public DemandGenerationLog findByInstallmentYear(String installmentYear) {
        return this.demandGenerationLogRepository.findByInstallmentYear(installmentYear);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public DemandGenerationLog createDemandGenerationLog(DemandGenerationLog demandGenerationLog) {
        demandGenerationLog.setExecutionStatus(ProcessStatus.INPROGRESS);
        demandGenerationLog.setDemandGenerationStatus(ProcessStatus.INCOMPLETE);
        return (DemandGenerationLog)((Object)this.demandGenerationLogRepository.save((Object)demandGenerationLog));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public DemandGenerationLogDetail createDemandGenerationLogDetail(DemandGenerationLog demandGenerationLog, License license) {
        DemandGenerationLogDetail demandGenerationLogDetail = new DemandGenerationLogDetail();
        demandGenerationLogDetail.setLicense(license);
        demandGenerationLogDetail.setDemandGenerationLog(demandGenerationLog);
        demandGenerationLogDetail.setStatus(ProcessStatus.INPROGRESS);
        demandGenerationLog.getDetails().add(demandGenerationLogDetail);
        return (DemandGenerationLogDetail)((Object)this.demandGenerationLogDetailRepository.save((Object)demandGenerationLogDetail));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void updateDemandGenerationLogDetail(DemandGenerationLogDetail demandGenerationLogDetail, ProcessStatus status, String details) {
        demandGenerationLogDetail.setStatus(status);
        demandGenerationLogDetail.setDetail(details);
        this.demandGenerationLogDetailRepository.save((Object)demandGenerationLogDetail);
    }

    public DemandGenerationLog updateDemandGenerationLog(DemandGenerationLog demandGenerationLog, ProcessStatus executionStatus, ProcessStatus demandGenerationStatus) {
        demandGenerationLog.setExecutionStatus(executionStatus);
        demandGenerationLog.setDemandGenerationStatus(demandGenerationStatus);
        return (DemandGenerationLog)((Object)this.demandGenerationLogRepository.save((Object)demandGenerationLog));
    }
}

