/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.entity;

import com.google.gson.annotations.Expose;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.commons.EgwStatus;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.tl.entity.LicenseAppType;
import org.egov.tl.entity.LicenseCategory;
import org.egov.tl.entity.LicenseDemand;
import org.egov.tl.entity.LicenseDocument;
import org.egov.tl.entity.LicenseStatus;
import org.egov.tl.entity.LicenseSubCategory;
import org.egov.tl.entity.Licensee;
import org.egov.tl.entity.NatureOfBusiness;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="EGTL_LICENSE")
@Inheritance(strategy=InheritanceType.JOINED)
@SequenceGenerator(name="SEQ_EGTL_LICENSE", sequenceName="SEQ_EGTL_LICENSE", allocationSize=1)
@Unique(fields={"licenseNumber", "applicationNumber"}, enableDfltMsg=true, isSuperclass=true)
@NamedQuery(name="LICENSE_BY_APPLICATION_NO", query="select license FROM License license WHERE applicationNumber=:applicationNumber")
public class License
extends StateAware {
    private static final long serialVersionUID = -4621190785979222546L;
    public static final String SEQUENCE = "SEQ_EGTL_LICENSE";
    public static final String BY_APPLICATION_NO = "LICENSE_BY_APPLICATION_NO";
    @Id
    @GeneratedValue(generator="SEQ_EGTL_LICENSE", strategy=GenerationType.SEQUENCE)
    @DocumentId
    @Expose
    protected Long id;
    @NotBlank
    @SafeHtml
    @Length(max=128)
    @Column(name="APPL_NUM")
    @Audited
    protected String applicationNumber;
    @SafeHtml
    @Length(max=50)
    @Column(name="LICENSE_NUMBER")
    protected String licenseNumber;
    @SafeHtml
    @NotBlank
    @Length(max=256)
    @Column(name="NAME_OF_ESTAB")
    @Audited
    protected String nameOfEstablishment;
    @SafeHtml
    @Length(max=50)
    @Column(name="OLD_LICENSE_NUMBER")
    protected String oldLicenseNumber;
    @SafeHtml
    @Length(max=512)
    @Column(name="REMARKS")
    protected String remarks;
    @SafeHtml
    @NotBlank
    @Length(max=120)
    @Column(name="OWNERSHIP_TYPE")
    @Audited
    protected String ownershipType;
    @SafeHtml
    @NotBlank
    @Length(max=250)
    @Column(name="ADDRESS")
    @Audited
    protected String address;
    @SafeHtml
    @Length(max=100)
    @Column(name="TEMP_LICENSE_NUMBER")
    protected String tempLicenseNumber;
    @SafeHtml
    @Length(max=50)
    @Column(name="AGREEMENT_DOCUMENT_NO")
    @Audited
    protected String agreementDocNo;
    @SafeHtml
    @Length(max=40)
    @Column(name="digisignedcertfilestoreid")
    protected String digiSignedCertFileStoreId;
    @SafeHtml
    @Length(max=64)
    @Column(name="ASSESSMENTNO")
    protected String assessmentNo;
    @NotNull
    @Column(name="APPL_DATE")
    @Temporal(value=TemporalType.DATE)
    @Audited
    protected Date applicationDate;
    @Column(name="COMMENCEMENTDATE")
    @Temporal(value=TemporalType.DATE)
    @Audited
    protected Date commencementDate;
    @Column(name="AGREEMENT_DATE")
    @Temporal(value=TemporalType.DATE)
    @Audited
    protected Date agreementDate;
    @Column(name="DATEOFEXPIRY")
    @Temporal(value=TemporalType.DATE)
    protected Date dateOfExpiry;
    @Column(name="IS_ACTIVE")
    protected boolean isActive;
    @Column(name="ISLEGACY")
    protected boolean legacy;
    @Column(name="TRADE_AREA_WEIGHT")
    @Audited
    protected BigDecimal tradeArea_weight;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="EGWSTATUSID")
    protected EgwStatus egwStatus;
    @ManyToOne
    @JoinColumn(name="ID_ADM_BNDRY")
    protected Boundary boundary;
    @ManyToOne
    @JoinColumn(name="ID_PARENT_BNDRY")
    protected Boundary parentBoundary;
    @ManyToOne
    @JoinColumn(name="NATUREOFBUSINESS")
    protected NatureOfBusiness natureOfBusiness;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="id_demand")
    protected LicenseDemand licenseDemand;
    @Valid
    @OneToOne(mappedBy="license", cascade={CascadeType.ALL})
    protected Licensee licensee;
    @ManyToOne
    @JoinColumn(name="ID_STATUS")
    protected LicenseStatus status;
    @NotNull
    @ManyToOne
    @JoinColumn(name="ID_SUB_CATEGORY")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    protected LicenseSubCategory tradeName;
    @NotNull
    @ManyToOne
    @JoinColumn(name="licenseAppType")
    protected LicenseAppType licenseAppType;
    @NotNull
    @ManyToOne
    @JoinColumn(name="ID_CATEGORY")
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    protected LicenseCategory category;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="license")
    protected List<LicenseDocument> documents = new ArrayList<LicenseDocument>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LicenseDemand getLicenseDemand() {
        return this.licenseDemand;
    }

    public void setLicenseDemand(LicenseDemand licenseDemand) {
        this.licenseDemand = licenseDemand;
    }

    public Date getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(Date applicationDate) {
        this.applicationDate = applicationDate;
    }

    public String getApplicationNumber() {
        return this.applicationNumber;
    }

    public void setApplicationNumber(String applicationNumber) {
        this.applicationNumber = applicationNumber;
    }

    public Boundary getBoundary() {
        return this.boundary;
    }

    public void setBoundary(Boundary boundary) {
        this.boundary = boundary;
    }

    public Date getDateOfExpiry() {
        return this.dateOfExpiry;
    }

    public void setDateOfExpiry(Date dateOfExpiry) {
        this.dateOfExpiry = dateOfExpiry;
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    public Licensee getLicensee() {
        return this.licensee;
    }

    public void setLicensee(Licensee licensee) {
        this.licensee = licensee;
    }

    public String getLicenseNumber() {
        return this.licenseNumber;
    }

    public void setLicenseNumber(String licenseNumber) {
        this.licenseNumber = licenseNumber;
    }

    public String getNameOfEstablishment() {
        return this.nameOfEstablishment;
    }

    public void setNameOfEstablishment(String nameOfEstablishment) {
        this.nameOfEstablishment = nameOfEstablishment;
    }

    public String getOldLicenseNumber() {
        return this.oldLicenseNumber;
    }

    public void setOldLicenseNumber(String oldLicenseNumber) {
        this.oldLicenseNumber = oldLicenseNumber;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public LicenseStatus getStatus() {
        return this.status;
    }

    public void setStatus(LicenseStatus status) {
        this.status = status;
    }

    public String getTempLicenseNumber() {
        return this.tempLicenseNumber;
    }

    public void setTempLicenseNumber(String tempLicenseNumber) {
        this.tempLicenseNumber = tempLicenseNumber;
    }

    public LicenseSubCategory getTradeName() {
        return this.tradeName;
    }

    public void setTradeName(LicenseSubCategory tradeName) {
        this.tradeName = tradeName;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public LicenseCategory getCategory() {
        return this.category;
    }

    public void setCategory(LicenseCategory category) {
        this.category = category;
    }

    public String getOwnershipType() {
        return this.ownershipType;
    }

    public void setOwnershipType(String ownershipType) {
        this.ownershipType = ownershipType;
    }

    public BigDecimal getTradeArea_weight() {
        return this.tradeArea_weight;
    }

    public void setTradeArea_weight(BigDecimal tradeArea_weight) {
        this.tradeArea_weight = tradeArea_weight;
    }

    public NatureOfBusiness getNatureOfBusiness() {
        return this.natureOfBusiness;
    }

    public void setNatureOfBusiness(NatureOfBusiness natureOfBusiness) {
        this.natureOfBusiness = natureOfBusiness;
    }

    public LicenseAppType getLicenseAppType() {
        return this.licenseAppType;
    }

    public void setLicenseAppType(LicenseAppType licenseAppType) {
        this.licenseAppType = licenseAppType;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public void setLegacy(boolean legacy) {
        this.legacy = legacy;
    }

    public Date getCommencementDate() {
        return this.commencementDate;
    }

    public void setCommencementDate(Date commencementDate) {
        this.commencementDate = commencementDate;
    }

    public EgwStatus getEgwStatus() {
        return this.egwStatus;
    }

    public void setEgwStatus(EgwStatus egwStatus) {
        this.egwStatus = egwStatus;
    }

    public Boundary getParentBoundary() {
        return this.parentBoundary;
    }

    public void setParentBoundary(Boundary parentBoundary) {
        this.parentBoundary = parentBoundary;
    }

    public Date getAgreementDate() {
        return this.agreementDate;
    }

    public void setAgreementDate(Date agreementDate) {
        this.agreementDate = agreementDate;
    }

    public String getAgreementDocNo() {
        return this.agreementDocNo;
    }

    public void setAgreementDocNo(String agreementDocNo) {
        this.agreementDocNo = agreementDocNo;
    }

    public String getDigiSignedCertFileStoreId() {
        return this.digiSignedCertFileStoreId;
    }

    public void setDigiSignedCertFileStoreId(String digiSignedCertFileStoreId) {
        this.digiSignedCertFileStoreId = digiSignedCertFileStoreId;
    }

    public LicenseDemand getCurrentDemand() {
        return this.getLicenseDemand();
    }

    public BigDecimal getCurrentLicenseFee() {
        return this.getCurrentDemand().getEgDemandDetails().stream().filter(dd -> dd.getEgDemandReason().getEgInstallmentMaster().equals((Object)this.getCurrentDemand().getEgInstallmentMaster())).findAny().get().getAmount();
    }

    public boolean isPaid() {
        return this.getTotalBalance().compareTo(BigDecimal.ZERO) == 0;
    }

    public BigDecimal getTotalBalance() {
        return this.licenseDemand.getBaseDemand().subtract(this.licenseDemand.getAmtCollected());
    }

    public boolean isStateRejected() {
        return this.getState() != null && this.getState().getValue().contains("Rejected");
    }

    public String getAssessmentNo() {
        return this.assessmentNo;
    }

    public void setAssessmentNo(String assessmentNo) {
        this.assessmentNo = assessmentNo;
    }

    public List<LicenseDocument> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<LicenseDocument> documents) {
        this.documents = documents;
    }

    public String getStateDetails() {
        return "";
    }
}

