/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service.integration;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.Installment;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.interfaces.LatePayPenaltyCalculator;
import org.egov.demand.model.AbstractBillable;
import org.egov.demand.model.EgBillType;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.tl.entity.License;
import org.egov.tl.entity.PenaltyRates;
import org.egov.tl.service.PenaltyRatesService;
import org.egov.tl.utils.LicenseUtils;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class LicenseBill
extends AbstractBillable
implements LatePayPenaltyCalculator {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseBill.class);
    private License license;
    private String moduleName;
    private String serviceCode;
    private String referenceNumber;
    private Boolean isCallbackForApportion = Boolean.FALSE;
    public static final String DEFAULT_FUNCTIONARY_CODE = "1";
    private String transanctionReferenceNumber;
    @Autowired
    private LicenseUtils licenseUtils;
    @Autowired
    private PenaltyRatesService penaltyRatesService;
    @Autowired
    private EgBillDao egBillDao;

    public License getLicense() {
        return this.license;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public Module getModule() {
        return this.licenseUtils.getModule(this.moduleName);
    }

    public String getBillPayee() {
        return this.license.getLicensee().getApplicantName();
    }

    public String getBillAddress() {
        return this.license.getLicensee().getAddress() + (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.license.getLicensee().getMobilePhoneNumber()) ? "\nPh : " + this.license.getLicensee().getMobilePhoneNumber() : "");
    }

    public EgDemand getCurrentDemand() {
        return this.license.getCurrentDemand();
    }

    public List<EgDemand> getAllDemands() {
        ArrayList<EgDemand> demands = new ArrayList<EgDemand>();
        demands.add(this.license.getLicenseDemand());
        return demands;
    }

    public EgBillType getBillType() {
        return this.egBillDao.getBillTypeByCode("AUTO");
    }

    public Date getBillLastDueDate() {
        Date dueDate = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(dueDate);
        cal.get(3);
        dueDate = cal.getTime();
        return dueDate;
    }

    public Long getBoundaryNum() {
        return this.license.getBoundary().getId();
    }

    public String getBoundaryType() {
        return this.license.getBoundary().getBoundaryType().getName();
    }

    public String getDepartmentCode() {
        return this.licenseUtils.getDepartmentCodeForBillGenerate();
    }

    public BigDecimal getFunctionaryCode() {
        return new BigDecimal(DEFAULT_FUNCTIONARY_CODE);
    }

    public String getFundCode() {
        return "01";
    }

    public String getFundSourceCode() {
        return "01";
    }

    public Date getIssueDate() {
        return new Date();
    }

    public Date getLastDate() {
        return this.getBillLastDueDate();
    }

    public Boolean getOverrideAccountHeadsAllowed() {
        return false;
    }

    public Boolean getPartPaymentAllowed() {
        return false;
    }

    public void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }

    public BigDecimal getTotalAmount() {
        return this.license.getTotalBalance();
    }

    public Long getUserId() {
        return ApplicationThreadLocals.getUserId();
    }

    public String getDescription() {
        return StringUtils.isBlank((String)this.license.getLicenseNumber()) ? "Application No : " + this.license.getApplicationNumber() : "License No : " + this.license.getLicenseNumber();
    }

    public String getDisplayMessage() {
        return this.moduleName + " Collection";
    }

    public String getCollModesNotAllowed() {
        return "";
    }

    public String getPropertyId() {
        return StringUtils.defaultString((String)this.license.getLicenseNumber(), (String)this.license.getApplicationNumber());
    }

    public Boolean isCallbackForApportion() {
        return this.isCallbackForApportion;
    }

    public void setCallbackForApportion(Boolean b) {
        this.isCallbackForApportion = b;
    }

    public BigDecimal getLPPPercentage() {
        return BigDecimal.ZERO;
    }

    public LatePayPenaltyCalculator.LPPenaltyCalcType getLPPenaltyCalcType() {
        return null;
    }

    public void setPenaltyCalcType(LatePayPenaltyCalculator.LPPenaltyCalcType penaltyType) {
    }

    public String getConsumerId() {
        return null;
    }

    public BigDecimal calculateLPPenaltyForPeriod(Date fromDate, Date toDate, BigDecimal amount) {
        return null;
    }

    public BigDecimal calculatePenalty(Date commencementDate, Date collectionDate, BigDecimal amount) {
        if (commencementDate != null) {
            int paymentDueDays = Days.daysBetween((ReadablePartial)new LocalDate(commencementDate.getTime()), (ReadablePartial)new LocalDate(collectionDate.getTime())).getDays();
            PenaltyRates penaltyRates = this.penaltyRatesService.findByDaysAndLicenseAppType(Long.valueOf(paymentDueDays), this.license.getLicenseAppType());
            if (penaltyRates == null) {
                LOG.warn("License payment due since {} days, There is no penatlity rate definied for License Type {}", (Object)paymentDueDays, (Object)this.license.getLicenseAppType().getName());
                return BigDecimal.ZERO;
            }
            return amount.multiply(BigDecimal.valueOf(penaltyRates.getRate() / 100.0));
        }
        return BigDecimal.ZERO;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public String getTransanctionReferenceNumber() {
        return this.transanctionReferenceNumber;
    }

    public void setTransanctionReferenceNumber(String transanctionReferenceNumber) {
        this.transanctionReferenceNumber = transanctionReferenceNumber;
    }

    public Map<Installment, BigDecimal> getCalculatedPenalty(Date fromDate, Date collectionDate, EgDemand demand) {
        HashMap<Installment, BigDecimal> installmentPenalty = new HashMap<Installment, BigDecimal>();
        for (EgDemandDetails demandDetails : demand.getEgDemandDetails()) {
            if (demandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equals("Penalty") || demandDetails.getAmtCollected().signum() != 0) continue;
            if (fromDate != null) {
                installmentPenalty.put(demandDetails.getEgDemandReason().getEgInstallmentMaster(), this.calculatePenalty(fromDate, collectionDate, demandDetails.getAmount()));
                continue;
            }
            installmentPenalty.put(demandDetails.getEgDemandReason().getEgInstallmentMaster(), this.calculatePenalty(demandDetails.getEgDemandReason().getEgInstallmentMaster().getToDate(), collectionDate, demandDetails.getAmount()));
        }
        return installmentPenalty;
    }
}

