/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.messaging.MessagingService;
import org.egov.tl.entity.License;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;

@Service
public class TradeLicenseSmsAndEmailService {
    @Autowired
    private MessagingService messagingService;
    @Autowired
    private ResourceBundleMessageSource messageSource;

    public void sendSMSOnLicense(String mobileNumber, String smsBody) {
        this.messagingService.sendSMS(mobileNumber, smsBody);
    }

    public void sendEmailOnLicense(String email, String emailBody, String emailSubject) {
        this.messagingService.sendEmail(email, emailSubject, emailBody);
    }

    public String getMunicipalityName() {
        return ApplicationThreadLocals.getMunicipalityName();
    }

    public void sendSmsAndEmail(License license, String workFlowAction) {
        String mobileNumber = license.getLicensee() != null && license.getLicensee().getMobilePhoneNumber() != null ? license.getLicensee().getMobilePhoneNumber() : null;
        String email = license.getLicensee() != null && license.getLicensee().getEmailId() != null ? license.getLicensee().getEmailId() : null;
        this.getSmsAndEmailForNewTradeLicense(license, workFlowAction, email, mobileNumber);
    }

    public void getSmsAndEmailForNewTradeLicense(License license, String workFlowAction, String email, String mobileNumber) {
        String smsMsg = null;
        String emailBody = "";
        String emailSubject = "";
        Locale locale = Locale.getDefault();
        String[] strarr = this.getMunicipalityName().split(" ");
        String cityname = strarr[0];
        String smsCode = "";
        String emailCode = "";
        if (license.getState().getHistory().isEmpty() && "ACK".equalsIgnoreCase(license.getStatus().getStatusCode()) || license.getState().getValue().contains("Sanitary inspector Approve pending")) {
            if (license.getLicenseAppType() != null && license.getLicenseAppType().getName().equals("Renew")) {
                smsCode = "msg.renewTradeLicensecreator.sms";
                emailCode = "msg.renewTradeLicensecreate.email.body";
            } else {
                smsCode = "msg.newTradeLicensecreator.sms";
                emailCode = "msg.newTradeLicensecreate.email.body";
            }
            smsMsg = this.messageSource.getMessage(smsCode, (Object[])new String[]{license.getLicensee().getApplicantName(), license.getApplicationNumber(), this.getMunicipalityName()}, locale);
            emailBody = this.messageSource.getMessage(emailCode, (Object[])new String[]{license.getLicensee().getApplicantName(), license.getApplicationNumber(), this.getMunicipalityName()}, locale);
            emailSubject = this.messageSource.getMessage("msg.newTradeLicensecreate.email.subject", (Object[])new String[]{license.getApplicationNumber()}, locale);
        } else if (workFlowAction.equals("Approve") && "UWF".equalsIgnoreCase(license.getStatus().getStatusCode())) {
            BigDecimal demAmt = license.getCurrentLicenseFee();
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            emailCode = license.getLicenseAppType() != null && license.getLicenseAppType().getName().equals("Renew") ? "msg.renewTradeLicenseapproval.email.body" : "msg.newTradeLicenseapproval.email.body";
            smsMsg = this.messageSource.getMessage("msg.newTradeLicenseapproval.sms", (Object[])new String[]{license.getLicensee().getApplicantName(), license.getLicenseNumber(), demAmt.toString(), formatter.format(license.getApplicationDate()), cityname, this.getMunicipalityName()}, locale);
            emailBody = this.messageSource.getMessage(emailCode, (Object[])new String[]{license.getLicensee().getApplicantName(), license.getLicenseNumber(), demAmt.toString(), formatter.format(license.getApplicationDate()), cityname, this.getMunicipalityName()}, locale);
            emailSubject = this.messageSource.getMessage("msg.newTradeLicenseApproval.email.subject", (Object[])new String[]{license.getLicenseNumber()}, locale);
        } else if ("CAN".equalsIgnoreCase(license.getStatus().getStatusCode())) {
            smsMsg = this.messageSource.getMessage("msg.newTradeLicensecancelled.sms", (Object[])new String[]{license.getLicensee().getApplicantName(), license.getApplicationNumber(), cityname, this.getMunicipalityName()}, locale);
            emailBody = this.messageSource.getMessage("msg.newTradeLicensecancelled.email.body", (Object[])new String[]{license.getLicensee().getApplicantName(), license.getApplicationNumber(), cityname, this.getMunicipalityName()}, locale);
            emailSubject = this.messageSource.getMessage("msg.newTradeLicensecancelled.email.subject", (Object[])new String[]{license.getApplicationNumber()}, locale);
        }
        this.sendSMSOnLicense(mobileNumber, smsMsg);
        this.sendEmailOnLicense(email, emailBody, emailSubject);
    }

    public void sendSMsAndEmailOnCollection(License license, Date receiptDate, BigDecimal demandAmount) {
        String smsMsgColl = String.format("Dear %s,\nTrade License with TIN No.%s, fee collected is at the rate of Rs.%s/- per year w.e.f %s.\nThanks,\n%s", license.getLicensee().getApplicantName(), license.getLicenseNumber(), demandAmount.toString(), new SimpleDateFormat("dd/MM/yyyy").format(receiptDate), ApplicationThreadLocals.getMunicipalityName());
        StringBuilder emailSubjectColl = new StringBuilder();
        emailSubjectColl.append("Trade License application Amount Collected for TIN No.").append(license.getLicenseNumber());
        this.messagingService.sendSMS(license.getLicensee().getMobilePhoneNumber(), smsMsgColl);
        this.messagingService.sendEmail(license.getLicensee().getEmailId(), emailSubjectColl.toString(), smsMsgColl.toString());
    }
}

