/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.utils;

import java.io.Serializable;
import java.sql.SQLException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.utils.DBSequenceGenerator;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.hibernate.exception.SQLGrammarException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LicenseNumberGenerator {
    @Autowired
    private DBSequenceGenerator dbSequenceGenerator;
    @Autowired
    private SequenceNumberGenerator sequenceNumberGenerator;

    public String generateBillNumber(String installmentYear) {
        try {
            Serializable sequenceNumber;
            String sequenceName = "SEQ_BILLNO_" + installmentYear;
            try {
                sequenceNumber = this.sequenceNumberGenerator.getNextSequence(sequenceName);
            }
            catch (SQLGrammarException e) {
                sequenceNumber = this.dbSequenceGenerator.createAndGetNextSequence(sequenceName);
            }
            return String.format("%s%06d", "", sequenceNumber);
        }
        catch (SQLException e) {
            throw new ApplicationRuntimeException("Error occurred while generating water connection charges bill Number ", (Throwable)e);
        }
    }
}

